/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj;

import com.sap.dictionary.tools.sqlj.SQLJEditorPlugin;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SQLJNature
implements IProjectNature {
    public static final String NATURE_ID = "com.sap.dictionary.tools.sqlj.SQLJNature";
    public static final String ENHANCER_BUILDER_ID = "com.sap.dictionary.tools.sqlj.DebugInformationEnhancer";
    public static final String TRANSLATOR_BUILDER_ID = "com.sap.dictionary.tools.sqlj.Translator";
    public static final String SQLJ_RUNTIME_CLASSPATH_VARIABLE = "SQLJ_RUNTIME";
    public static final String DC_NATURE = "com.sap.ide.eclipse.component.provider.dcnature";
    public static final String DDIC_NATURE = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    public static final String SQLJ_PLUGIN_ID = "com.sap.sqlj";
    public static final String SQLJ_RUNTIME_JAR = "lib\\sqljapi.jar";
    private IProject project;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void configure() throws CoreException {
        SQLJNature.setCompilerFilter();
        this.modifyClassPath();
        this.addBuilders();
    }

    public void deconfigure() throws CoreException {
        this.removeBuilders();
    }

    public static void setCompilerFilter() {
        Hashtable options = JavaCore.getOptions();
        String option = (String)options.get("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        if (option.indexOf("*.sqlj") <= 0) {
            option = option.concat(",*.sqlj");
            options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", option);
            JavaCore.setOptions((Hashtable)options);
        }
    }

    private void modifyClassPath() {
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        try {
            IClasspathEntry entry;
            IPath path = JavaCore.getClasspathVariable((String)SQLJ_RUNTIME_CLASSPATH_VARIABLE);
            IPluginDescriptor runtimePluginDescriptor = Platform.getPlugin((String)SQLJ_PLUGIN_ID).getDescriptor();
            URL runtimePluginUrl = null;
            runtimePluginUrl = Platform.resolve((URL)runtimePluginDescriptor.getInstallURL());
            Path runtimePluginPath = new Path(runtimePluginUrl.getFile());
            runtimePluginPath = runtimePluginPath.append(SQLJ_RUNTIME_JAR);
            JavaCore.setClasspathVariable((String)SQLJ_RUNTIME_CLASSPATH_VARIABLE, (IPath)runtimePluginPath, null);
            IClasspathEntry[] classPathEntries = jProject.getRawClasspath();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < classPathEntries.length) {
                list.add(classPathEntries[i]);
                if (classPathEntries[i].getEntryKind() == 4 && (path = classPathEntries[i].getPath()).toOSString().startsWith(SQLJ_RUNTIME_CLASSPATH_VARIABLE)) {
                    return;
                }
                ++i;
            }
            IProjectNature nature = null;
            try {
                nature = this.project.getNature(DC_NATURE);
                if (nature == null) {
                    path = new Path(SQLJ_RUNTIME_CLASSPATH_VARIABLE);
                    entry = JavaCore.newVariableEntry((IPath)path, (IPath)path, (IPath)new Path(""));
                    list.add(entry);
                }
            }
            catch (CoreException e1) {
                SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "modify classpath", (Throwable)e1));
            }
            boolean srcIsProjectPath = false;
            int i2 = 0;
            while (i2 < classPathEntries.length) {
                if (classPathEntries[i2].getEntryKind() == 3 && classPathEntries[i2].getPath().equals((Object)this.project.getFullPath())) {
                    srcIsProjectPath = true;
                }
                ++i2;
            }
            if (!srcIsProjectPath) {
                path = this.project.getFullPath().append("gen_sqlj");
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                if (!folder.exists()) {
                    try {
                        folder.create(false, false, null);
                    }
                    catch (CoreException e) {
                        SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "create folder", (Throwable)e));
                    }
                }
                entry = JavaCore.newSourceEntry((IPath)path);
                list.add(entry);
            }
            IClasspathEntry[] newClassPathEntries = new IClasspathEntry[list.size()];
            newClassPathEntries = list.toArray(newClassPathEntries);
            jProject.setRawClasspath(newClassPathEntries, jProject.getOutputLocation(), null);
        }
        catch (IOException e1) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "modify classpath", (Throwable)e1));
            return;
        }
        catch (JavaModelException e2) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "translate resource", (Throwable)e2));
            return;
        }
    }

    private void addBuilders() throws CoreException {
        String DICTIONARY_BUILDER_ID = "com.sap.dictionary.tools.generation.GenerationBuilder";
        IProjectDescription description = this.project.getDescription();
        ICommand[] lCommands = description.getBuildSpec();
        int lDictionaryBuilderPosition = -1;
        int i = 0;
        while (i < lCommands.length) {
            if (lCommands[i].getBuilderName().equals(TRANSLATOR_BUILDER_ID)) {
                return;
            }
            if (lCommands[i].getBuilderName().equals(DICTIONARY_BUILDER_ID)) {
                lDictionaryBuilderPosition = i;
            }
            ++i;
        }
        ICommand translatorCommand = description.newCommand();
        translatorCommand.setBuilderName(TRANSLATOR_BUILDER_ID);
        ICommand[] lSpecs = new ICommand[lCommands.length + 2];
        if (lDictionaryBuilderPosition >= 0) {
            System.arraycopy(lCommands, 0, lSpecs, 0, lDictionaryBuilderPosition + 1);
            lSpecs[lDictionaryBuilderPosition + 1] = translatorCommand;
            System.arraycopy(lCommands, lDictionaryBuilderPosition + 1, lSpecs, lDictionaryBuilderPosition + 2, lCommands.length - (lDictionaryBuilderPosition + 1));
        } else {
            System.arraycopy(lCommands, 0, lSpecs, 1, lCommands.length);
            lSpecs[0] = translatorCommand;
        }
        ICommand enhancerCommand = description.newCommand();
        enhancerCommand.setBuilderName(ENHANCER_BUILDER_ID);
        lSpecs[lCommands.length + 1] = enhancerCommand;
        description.setBuildSpec(lSpecs);
        this.project.setDescription(description, null);
    }

    private void removeBuilders() throws CoreException {
        String id = ENHANCER_BUILDER_ID;
        IProjectDescription lDescription = this.project.getDescription();
        ICommand[] lCommands = lDescription.getBuildSpec();
        int i = 0;
        while (i < lCommands.length) {
            if (lCommands[i].getBuilderName().equals(id)) {
                ICommand[] lSpecs = new ICommand[lCommands.length - 1];
                System.arraycopy(lCommands, 0, lSpecs, 0, i);
                System.arraycopy(lCommands, i + 1, lSpecs, i, lCommands.length - i - 1);
                lDescription.setBuildSpec(lSpecs);
                this.project.setDescription(lDescription, null);
                return;
            }
            ++i;
        }
    }
}

