/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.sqlj;

import com.sap.dictionary.tools.sqlj.SQLJPartListener;
import com.sap.dictionary.tools.sqlj.SQLJResourceChangeListener;
import com.sap.dictionary.tools.sqlj.debug.SQLJDebugSourceLocatorListener;
import com.sap.dictionary.tools.sqlj.editor.SQLJDocumentProvider;
import com.sap.dictionary.tools.sqlj.translator.SQLJTranslator;
import com.sap.ide.eclipse.debugExtensionPlugin.DebugExtensionPlugin;
import com.sap.ide.eclipse.debugExtensionPlugin.DebugSourceLocatorListener;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SQLJEditorPlugin
extends AbstractUIPlugin
implements IStartup {
    private static SQLJEditorPlugin plugin;
    private static SQLJDocumentProvider documentProvider;
    private HashMap projectTranslatorMap;
    private static SQLJDebugSourceLocatorListener debugListener;

    public SQLJEditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        this.addListeners();
    }

    public void earlyStartup() {
        try {
            IPath path = JavaCore.getClasspathVariable((String)"SQLJ_RUNTIME");
            IPluginDescriptor runtimePluginDescriptor = Platform.getPlugin((String)"com.sap.sqlj").getDescriptor();
            URL runtimePluginUrl = null;
            runtimePluginUrl = Platform.resolve((URL)runtimePluginDescriptor.getInstallURL());
            Path runtimePluginPath = new Path(runtimePluginUrl.getFile());
            runtimePluginPath = runtimePluginPath.append("lib\\sqljapi.jar");
            JavaCore.setClasspathVariable((String)"SQLJ_RUNTIME", (IPath)runtimePluginPath, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SQLJEditorPlugin getDefault() {
        return plugin;
    }

    public static SQLJDocumentProvider getDocumentProvider() {
        if (documentProvider == null) {
            documentProvider = new SQLJDocumentProvider();
        }
        return documentProvider;
    }

    private void addListeners() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new SQLJResourceChangeListener(), 24);
                DebugExtensionPlugin.getDefault().addDebugSourceLocatorListener((DebugSourceLocatorListener)new SQLJDebugSourceLocatorListener());
                SQLJEditorPlugin.this.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)new SQLJPartListener());
            }
        });
    }

    private static boolean hasSqljNature(String[] natures) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("com.sap.dictionary.tools.sqlj.SQLJNature")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasJavaNature(String[] natures) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("org.eclipse.jdt.core.javanature")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void setNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            if (!SQLJEditorPlugin.hasJavaNature(natures)) {
                String[] newNatures = new String[natures.length + 2];
                System.arraycopy(natures, 0, newNatures, 2, natures.length);
                newNatures[0] = "org.eclipse.jdt.core.javanature";
                newNatures[1] = "com.sap.dictionary.tools.sqlj.SQLJNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            } else if (!SQLJEditorPlugin.hasSqljNature(natures)) {
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 1, natures.length);
                newNatures[0] = "com.sap.dictionary.tools.sqlj.SQLJNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            SQLJEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.sap.dictionary.tools.sqlj", 4, "set nature", (Throwable)e));
        }
    }

    public SQLJTranslator getTranslator(IProject project) {
        SQLJTranslator translator;
        if (this.projectTranslatorMap == null) {
            this.projectTranslatorMap = new HashMap();
        }
        if ((translator = (SQLJTranslator)this.projectTranslatorMap.get(project)) == null) {
            translator = new SQLJTranslator(project);
            this.projectTranslatorMap.put(project, translator);
        }
        return translator;
    }
}

