/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.SoftwareComponent;
import com.sap.sdm.util.Constants;
import com.sap.sdm.util.FileExtension;
import com.sap.sdm.util.jarsl.ConstantsIF;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class ProjectInfo
implements ConstantsIF {
    private boolean activ = true;
    private String infodir = null;
    private Component component = null;
    private SoftwareComponent softwareComponent = null;
    private String sduName = null;
    private String project = null;
    private String codeline = null;
    private String configuration = null;
    private File component2archivelinkfile = null;
    private File archive2archivelinkfile = null;
    private File sc2dclinkfile = null;

    ProjectInfo() {
        this.activ = false;
    }

    ProjectInfo(Component component, String project, String codeline, String configuration, String infodir, String sduName) {
        if (null == component || null == infodir || null == sduName) {
            throw new NullPointerException("Internal Error: Wrong arguments for constructor of " + this.getClass().getName() + "(component or infodir or sduName are null)");
        }
        this.component = component;
        this.project = project;
        this.codeline = codeline;
        this.configuration = configuration;
        this.infodir = infodir;
        this.sduName = sduName;
        this.initFiles();
    }

    ProjectInfo(SoftwareComponent softwareComponent, String project, String codeline, String configuration, String infodir, String sduName) {
        if (null == softwareComponent || null == infodir || null == sduName) {
            throw new NullPointerException("Internal Error: Wrong arguments for constructor of " + this.getClass().getName() + "(softwareComponent or infodir or sduName are null)");
        }
        this.softwareComponent = softwareComponent;
        this.project = project;
        this.codeline = codeline;
        this.configuration = configuration;
        this.infodir = infodir;
        this.sduName = sduName;
        this.initFiles();
    }

    private void initFiles() {
        if (this.activ) {
            this.component2archivelinkfile = new File(this.infodir, "component2archive.lst");
            this.archive2archivelinkfile = new File(this.infodir, "archive2archive.lst");
            this.sc2dclinkfile = new File(this.infodir, "sc2dc.lst");
        }
    }

    public void writeComponentToArchiveLinkFile() {
        if (this.activ) {
            if (null != this.component) {
                this.writeDCToSDALinkFile();
            } else if (null != this.softwareComponent) {
                this.writeSCToSCALinkFile();
            }
        }
    }

    public void writeArchiveToArchiveLinkFile(String archiveName) {
        if (this.activ) {
            String pureArchiveName = archiveName;
            int lastindexOfDirSep = -1;
            lastindexOfDirSep = pureArchiveName.lastIndexOf("/");
            if (-1 != lastindexOfDirSep || -1 != (lastindexOfDirSep = pureArchiveName.lastIndexOf("\\"))) {
                pureArchiveName = pureArchiveName.substring(lastindexOfDirSep + 1, pureArchiveName.length());
            }
            if (null != this.component) {
                this.writeArchiveToArchiveLinkFile(pureArchiveName, "SDA");
            } else if (null != this.softwareComponent) {
                this.writeArchiveToArchiveLinkFile(pureArchiveName, "SCA");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeScToDcLinkFile(Component component) {
        if (!this.activ || null == this.softwareComponent || null == component || null == this.sc2dclinkfile) return;
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(this.sc2dclinkfile.getAbsolutePath(), true);
                fileWriter.write(this.project + " ");
                fileWriter.write(this.codeline + " ");
                fileWriter.write(this.configuration + " ");
                fileWriter.write(this.softwareComponent.getName() + " ");
                fileWriter.write(this.softwareComponent.getVendor() + " ");
                fileWriter.write(this.extractCRVersionFromCounter(this.softwareComponent.getCounter()) + " ");
                fileWriter.write(component.getName() + " ");
                fileWriter.write(component.getVendor() + " ");
                fileWriter.write(this.extractCRVersionFromCounter(component.getCounter()) + Constants.EOL);
                fileWriter.close();
                return;
            }
            catch (IOException e) {
                Object var5_4 = null;
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDCToSDALinkFile() {
        if (this.component == null || this.component2archivelinkfile == null) return;
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(this.component2archivelinkfile.getAbsolutePath(), true);
                fileWriter.write(this.project + " ");
                fileWriter.write(this.codeline + " ");
                fileWriter.write(this.configuration + " ");
                fileWriter.write(this.component.getName() + " ");
                fileWriter.write(this.component.getVendor() + " ");
                fileWriter.write(this.extractCRVersionFromCounter(this.component.getCounter()) + " ");
                fileWriter.write(this.sduName + " ");
                fileWriter.write("DC" + Constants.EOL);
                fileWriter.close();
                return;
            }
            catch (IOException e) {
                Object var4_3 = null;
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSCToSCALinkFile() {
        if (this.softwareComponent == null || this.component2archivelinkfile == null) return;
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(this.component2archivelinkfile.getAbsolutePath(), true);
                fileWriter.write(this.project + " ");
                fileWriter.write(this.codeline + " ");
                fileWriter.write(this.configuration + " ");
                fileWriter.write(this.softwareComponent.getName() + " ");
                fileWriter.write(this.softwareComponent.getVendor() + " ");
                fileWriter.write(this.extractCRVersionFromCounter(this.softwareComponent.getCounter()) + " ");
                fileWriter.write(this.sduName + " ");
                fileWriter.write("SC" + Constants.EOL);
                fileWriter.close();
                return;
            }
            catch (IOException e) {
                Object var4_3 = null;
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArchiveToArchiveLinkFile(String archiveName, String type) {
        if (!(this.archive2archivelinkfile != null & null != archiveName)) return;
        int extensionType = FileExtension.getExtensionType((String)archiveName);
        switch (extensionType) {
            case 0: 
            case 1: 
            case 8: {
                return;
            }
            default: {
                FileWriter fileWriter = null;
                try {
                    try {
                        fileWriter = new FileWriter(this.archive2archivelinkfile.getAbsolutePath(), true);
                        fileWriter.write(this.project + " ");
                        fileWriter.write(this.codeline + " ");
                        fileWriter.write(this.configuration + " ");
                        fileWriter.write(this.sduName + " ");
                        fileWriter.write(archiveName + " ");
                        fileWriter.write(type + Constants.EOL);
                        fileWriter.close();
                        return;
                    }
                    catch (IOException e) {
                        Object var7_6 = null;
                        if (fileWriter == null) return;
                        try {
                            fileWriter.close();
                            return;
                        }
                        catch (IOException e2) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (fileWriter == null) throw throwable;
                    try {
                        fileWriter.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private String extractCRVersionFromCounter(String counter) {
        String result = new String(counter);
        if (null != result) {
            int indexOfLastDot = -1;
            indexOfLastDot = result.lastIndexOf(".");
            if (-1 != indexOfLastDot) {
                if (-1 != (indexOfLastDot = (result = result.substring(0, indexOfLastDot)).lastIndexOf("."))) {
                    result = result.substring(0, indexOfLastDot);
                } else {
                    return counter;
                }
            }
        }
        return result;
    }
}

