/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

public class PlattformConstants {
    private static String[] libpostfix = new String[]{"", "lib", "lib", "lib", "lib", "lib", "lib"};
    private static String[] libprefix = new String[]{".dll", ".so", ".so", ".so", ".so", ".sl", ".so"};
    private static String[] plattform = new String[]{"Windows", "SunOS", "Linux", "AIX", "HP-UXIA64", "HP", "OSF"};
    private static String givenplatform = null;

    static boolean setPlatform(String platform) {
        boolean rc = false;
        if (platform == null) {
            givenplatform = null;
            rc = true;
        }
        int i = 0;
        while (i < plattform.length && !rc) {
            if (platform.equals(plattform[i])) {
                rc = true;
                givenplatform = platform;
            }
            ++i;
        }
        return rc;
    }

    static String getPlatform() {
        if (givenplatform != null) {
            return givenplatform;
        }
        return System.getProperty("os.name") + System.getProperty("os.arch");
    }

    static String getLibraryPostFix() {
        String localplattform = System.getProperty("os.name") + System.getProperty("os.arch");
        if (givenplatform != null) {
            localplattform = givenplatform;
        }
        int i = 0;
        while (i < plattform.length) {
            if (localplattform.toLowerCase().startsWith(plattform[i].toLowerCase())) {
                return libpostfix[i];
            }
            ++i;
        }
        return null;
    }

    static String getLibraryPreFix() {
        String localplattform = System.getProperty("os.name") + System.getProperty("os.arch");
        if (givenplatform != null) {
            localplattform = givenplatform;
        }
        int i = 0;
        while (i < plattform.length) {
            if (localplattform.toLowerCase().startsWith(plattform[i].toLowerCase())) {
                return libprefix[i];
            }
            ++i;
        }
        return null;
    }

    static boolean plattformSupported() {
        String localplattform = System.getProperty("os.name") + System.getProperty("os.arch");
        if (givenplatform != null) {
            localplattform = givenplatform;
        }
        int i = 0;
        while (i < plattform.length) {
            if (localplattform.toLowerCase().startsWith(plattform[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] in) {
        System.out.println("System: " + System.getProperty("os.name") + System.getProperty("os.arch"));
        if (PlattformConstants.plattformSupported()) {
            System.out.println("Plattform is supported: ");
            System.out.println("preFix:  " + PlattformConstants.getLibraryPreFix());
            System.out.println("postfix: " + PlattformConstants.getLibraryPostFix());
        } else {
            System.out.println("Plattform is not supported.");
        }
    }
}

