/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.services;

import com.sap.dictionary.types.services.SAPStringBuffer;

public class NamingService {
    public static void main(String[] args) {
        NamingService.doTest("Das ist ein Test");
        NamingService.doTest("KUNNR_HUGO");
        NamingService.doTest("NAMESPACE/SOME_FIELD");
        NamingService.doTest("class");
        NamingService.doTest("output");
        NamingService.doTest("0_1_Test");
        NamingService.doTest("1_1_Test");
        NamingService.doTest("Umlaute \u00e4 \u00f6 \u00fc \u00df !\u00a7$%&%%%%%");
        NamingService.doTest("KUN5NR_HUGO");
        NamingService.doTest("KUN5NR8_HUGO");
        NamingService.doTest("KUN5NR8_9HUGO");
        NamingService.doTest("KUN5NR8_9H0UGO");
    }

    static void doTest(String testString) {
        System.out.print("ABAP : ");
        System.out.println(testString);
        System.out.print(" --> Backend :");
        String str = NamingService.internalGetBackendNameFromABAPName(testString);
        System.out.println(str);
        System.out.print(" --> ABAP :");
        str = NamingService.internalGetABAPNameFromBackendName(str);
        System.out.println(str);
        if (!str.equals(testString)) {
            throw new RuntimeException("severe error");
        }
        System.out.print(" --> Java :");
        str = NamingService.internalGetJavaNameFromBackendName(NamingService.internalGetBackendNameFromABAPName(testString));
        System.out.println(str);
        System.out.println();
        System.out.println();
    }

    private static String internalGetABAPNameFromBackendName(String name) {
        int nameLength = name.length();
        int readIndex = 0;
        while (readIndex < nameLength) {
            if (!NamingService.isDefaultChar(name.charAt(readIndex))) break;
            ++readIndex;
        }
        if (readIndex >= nameLength) {
            return name;
        }
        SAPStringBuffer newValue = new SAPStringBuffer(nameLength);
        if (readIndex > 0) {
            newValue.append(name, 0, readIndex);
        }
        while (readIndex < nameLength) {
            char theChar;
            if (NamingService.isDefaultChar(theChar = name.charAt(readIndex++))) {
                newValue.append(theChar);
                continue;
            }
            if (theChar == '%') {
                String theSubStr = name.substring(readIndex, name.indexOf(37, readIndex));
                readIndex += theSubStr.length() + 1;
                newValue.append((char)Integer.parseInt(theSubStr, 10));
                continue;
            }
            throw new IllegalArgumentException("Invalid char " + theChar + " found in " + name);
        }
        return newValue.toString();
    }

    private static String internalGetBackendNameFromABAPName(String name) {
        int nameLength = name.length();
        int readIndex = 0;
        while (readIndex < nameLength) {
            if (!NamingService.isDefaultChar(name.charAt(readIndex))) break;
            ++readIndex;
        }
        if (readIndex >= nameLength) {
            return name;
        }
        SAPStringBuffer newValue = new SAPStringBuffer(name.length() + 10);
        if (readIndex > 0) {
            newValue.append(name, 0, readIndex);
        }
        while (readIndex < name.length()) {
            char theChar;
            if (NamingService.isDefaultChar(theChar = name.charAt(readIndex++))) {
                newValue.append(theChar);
                continue;
            }
            newValue.append('%').append(Integer.toString(theChar, 10)).append('%');
        }
        return newValue.toString();
    }

    private static String internalGetJavaNameFromBackendName(String name) {
        int nameLength = name.length();
        if (nameLength == 0) {
            return "";
        }
        if (name.equalsIgnoreCase("class")) {
            return "_Class";
        }
        if (name.equalsIgnoreCase("output")) {
            return "_Output";
        }
        SAPStringBuffer newName = new SAPStringBuffer(nameLength + 10);
        int readIndex = 0;
        switch (name.charAt(readIndex)) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                newName.append('_');
            }
        }
        boolean nextCharUpper = true;
        block6: while (readIndex < nameLength) {
            char theChar;
            if (NamingService.isDefaultChar(theChar = name.charAt(readIndex++))) {
                newName.append(nextCharUpper ? Character.toUpperCase(theChar) : Character.toLowerCase(theChar));
                nextCharUpper = NamingService.isNextCharUpper(theChar);
                continue;
            }
            switch (theChar) {
                case '%': {
                    String theSubStr = name.substring(readIndex, name.indexOf(37, readIndex + 1));
                    readIndex += theSubStr.length() + 1;
                    String replacement = NamingService.getJavaCharsFromHex(theSubStr);
                    int i = 0;
                    while (i < replacement.length()) {
                        newName.append(nextCharUpper ? Character.toUpperCase(replacement.charAt(i)) : replacement.charAt(i));
                        nextCharUpper = NamingService.isNextCharUpper(replacement.charAt(i));
                        ++i;
                    }
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Name may only contain A..Z, a..z, 0..9 or '_' but is " + name);
                }
            }
        }
        return newName.toString();
    }

    private static boolean isNextCharUpper(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private static boolean isDefaultChar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    private static String getJavaCharsFromHex(String str) {
        int code = Integer.decode(str);
        switch (code) {
            case 60: {
                return "_lt_";
            }
            case 62: {
                return "_gt_";
            }
            case 38: {
                return "_amp_";
            }
            case 167: {
                return "_para_";
            }
            case 37: {
                return "_proz_";
            }
            case 228: {
                return "ae";
            }
            case 246: {
                return "oe";
            }
            case 252: {
                return "ue";
            }
            case 223: {
                return "ss";
            }
            case 47: {
                return "__";
            }
        }
        return "_$_";
    }

    public static class Type {
        public static String getABAPNameFromBackendName(String name) {
            return NamingService.internalGetABAPNameFromBackendName(name);
        }

        public static String getBackendNameFromABAPName(String name) {
            return NamingService.internalGetBackendNameFromABAPName(name);
        }

        public static String getJavaNameFromBackendName(String name) {
            return NamingService.internalGetJavaNameFromBackendName(name);
        }
    }

    public static class Field {
        public static String getABAPNameFromBackendName(String name) {
            return NamingService.internalGetABAPNameFromBackendName(name);
        }

        public static String getBackendNameFromABAPName(String name) {
            return NamingService.internalGetBackendNameFromABAPName(name);
        }

        public static String getJavaNameFromBackendName(String name) {
            return NamingService.internalGetJavaNameFromBackendName(name);
        }
    }

    public static class Structure {
        public static String getABAPNameFromBackendName(String name) {
            return NamingService.internalGetABAPNameFromBackendName(name);
        }

        public static String getBackendNameFromABAPName(String name) {
            return NamingService.internalGetBackendNameFromABAPName(name);
        }

        public static String getJavaNameFromBackendName(String name) {
            return NamingService.internalGetJavaNameFromBackendName(name);
        }
    }
}

