/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.java.explorer.views;

import com.togethersoft.togetherxj.java.explorer.references.UMLExplorerView;
import com.togethersoft.togetherxj.java.explorer.views.UMLExplorerContentProvider;
import com.togethersoft.togetherxj.java.explorer.views.UMLExplorerElementWrapper;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class UMLExplorerContentManager
implements ModelAccessListener,
ModelChangeListener {
    private TreeViewer myViewer;
    private Map myCollectionsMap = new HashMap();
    private Map myViewsMap = new HashMap();
    private Map myPendingTreeElements = new HashMap();

    public UMLExplorerContentManager(TreeViewer treeViewer) {
        this.myViewer = treeViewer;
        ModelAccess.addModelAccessListener((ModelAccessListener)this);
        Enumeration enumeration = ModelAccess.models();
        while (enumeration.hasMoreElements()) {
            ((Model)enumeration.nextElement()).addModelDeltaListener((ModelChangeListener)this);
        }
    }

    public TreeViewer getViewer() {
        return this.myViewer;
    }

    public void dispose() {
        ModelAccess.removeModelAccessListener((ModelAccessListener)this);
        Enumeration enumeration = ModelAccess.models();
        while (enumeration.hasMoreElements()) {
            Model model = (Model)enumeration.nextElement();
            model.removeModelDeltaListener((ModelChangeListener)this);
            Iterator iterator = this.getViewsMap(model).values().iterator();
            while (iterator.hasNext()) {
                ViewManager viewManager;
                View view = (View)iterator.next();
                if (model.getUniqueName() == null || (viewManager = ViewAccess.getViewManager((UniqueName)model.getUniqueName())) == null) continue;
                viewManager.disposeView(view);
            }
            this.myViewsMap.remove(model);
        }
        this.myCollectionsMap.clear();
        this.myPendingTreeElements.clear();
        this.myViewsMap.clear();
    }

    public void modelCreated(ModelAccessEvent modelAccessEvent) {
        modelAccessEvent.getModel().addModelDeltaListener((ModelChangeListener)this);
    }

    public void modelRemoved(ModelAccessEvent modelAccessEvent) {
        modelAccessEvent.getModel().removeModelDeltaListener((ModelChangeListener)this);
        this.myCollectionsMap.remove(modelAccessEvent.getModel().getUniqueName());
        Iterator iterator = this.getViewsMap(modelAccessEvent.getModel()).values().iterator();
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            ViewAccess.getViewManager((UniqueName)modelAccessEvent.getModel().getUniqueName()).disposeView(view);
        }
        this.myViewsMap.remove(modelAccessEvent.getModel());
    }

    public void modelChanged(ModelChangeEvent modelChangeEvent) {
        Iterator iterator;
        Iterator iterator2;
        if (modelChangeEvent.getRootDelta().isTotallyChanged()) {
            if (this.myViewer != null && modelChangeEvent.getModel() != null) {
                JavaModel javaModel;
                IProject iProject = ModelUinSupport.getProject((UniqueName)modelChangeEvent.getModel().getUniqueName());
                if (iProject != null && (javaModel = JavaModelManager.getJavaModelManager().getJavaModel()) != null) {
                    this.myViewer.refresh((Object)javaModel.getJavaProject((IResource)iProject), true);
                    return;
                }
                this.myViewer.refresh(true);
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<UniqueName> arrayList3 = new ArrayList<UniqueName>();
        this.processDelta(modelChangeEvent.getRootDelta(), arrayList, arrayList2, arrayList3);
        Iterator iterator3 = arrayList2.iterator();
        while (iterator3.hasNext()) {
            iterator2 = iterator3.next();
            if (iterator2 == null) continue;
            arrayList3.add(((Element)iterator2).getUniqueName());
            arrayList.add(iterator2);
        }
        iterator2 = arrayList3.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            if (this.getCollectionsMap(modelChangeEvent.getModel()).get(iterator) == null) continue;
            this.myViewer.remove(this.getCollectionsMap(modelChangeEvent.getModel()).get(iterator));
            if (!this.getCollectionsMap(modelChangeEvent.getModel()).containsKey(iterator)) continue;
            this.deregisterReferenceCollection(modelChangeEvent.getModel(), iterator);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            UMLExplorerElementWrapper uMLExplorerElementWrapper = new UMLExplorerElementWrapper(element);
            this.myPendingTreeElements.put(element.getUniqueName(), uMLExplorerElementWrapper);
            if (element.getParent() == null) continue;
            IJavaElement iJavaElement = ElementUtil.getJavaElement((Element)element.getParent());
            if (iJavaElement instanceof IJavaProject) {
                this.myViewer.refresh((Object)iJavaElement);
            }
            if (iJavaElement == null) continue;
            this.myViewer.add((Object)iJavaElement, (Object)uMLExplorerElementWrapper);
            Property property = element.getProperty("#invoke_inplace");
            if (property == null || !"com.togethersoft.togetherxj.java.explorer.views.UMLExplorerView".equals(property.getValue())) continue;
            this.myViewer.setSelection((ISelection)new StructuredSelection((Object)uMLExplorerElementWrapper), true);
        }
        this.myPendingTreeElements.clear();
    }

    public Object registerReferenceCollection(ReferenceCollection referenceCollection, Object object) {
        this.getCollectionsMap(referenceCollection.getModel()).put(referenceCollection.getUniqueName(), object);
        if (this.getViewsMap(referenceCollection.getModel()).containsKey(referenceCollection.getUniqueName())) {
            return referenceCollection.getUniqueName();
        }
        View view = ViewAccess.getViewManager((UniqueName)referenceCollection.getModel().getUniqueName()).createView(referenceCollection, "com.togethersoft.togetherxj.java.explorer.rc");
        if (view instanceof UMLExplorerView) {
            this.getViewsMap(referenceCollection.getModel()).put(referenceCollection.getUniqueName(), view);
            ((UMLExplorerView)view).setContentManager(this);
        }
        return referenceCollection.getUniqueName();
    }

    public void deregisterReferenceCollection(Model model, Object object) {
        this.getCollectionsMap(model).remove(object);
        View view = (View)this.getViewsMap(model).get(object);
        ViewAccess.getViewManager((UniqueName)model.getUniqueName()).disposeView(view);
        this.getViewsMap(model).remove(object);
    }

    public void rebuildReferenceCollection(Model model, Object object) {
        Object v = this.getCollectionsMap(model).get(object);
        if (v != null) {
            this.myViewer.refresh(v, true);
        }
    }

    public void rebuildReferenceCollection(Model model, Object object, Element element) {
        Object[] objectArray;
        Object v = this.getCollectionsMap(model).get(object);
        if (v != null) {
            this.myViewer.refresh(v, true);
        }
        if ((objectArray = ((UMLExplorerContentProvider)this.myViewer.getContentProvider()).getElements(v)) == null || element == null) {
            return;
        }
        UMLExplorerElementWrapper uMLExplorerElementWrapper = new UMLExplorerElementWrapper(element);
        ArrayList arrayList = new ArrayList();
        Object object2 = this.findTreeElement(v, (Object)uMLExplorerElementWrapper, arrayList);
        if (object2 != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.myViewer.expandToLevel(e, 1);
            }
            this.myViewer.setSelection((ISelection)new StructuredSelection(object2), true);
        }
    }

    public Map getPendingTreeElements() {
        return this.myPendingTreeElements;
    }

    private Map getCollectionsMap(Model model) {
        HashMap hashMap = (HashMap)this.myCollectionsMap.get(model.getUniqueName());
        if (hashMap == null) {
            hashMap = new HashMap();
            this.myCollectionsMap.put(model.getUniqueName(), hashMap);
        }
        return hashMap;
    }

    private Map getViewsMap(Model model) {
        HashMap hashMap = (HashMap)this.myViewsMap.get(model.getUniqueName());
        if (hashMap == null) {
            hashMap = new HashMap();
            this.myViewsMap.put(model.getUniqueName(), hashMap);
        }
        return hashMap;
    }

    protected void processDelta(ModelDeltaNode modelDeltaNode, Collection collection, Collection collection2, Collection collection3) {
        if (modelDeltaNode.getElement() instanceof ReferenceCollection && modelDeltaNode.isNew()) {
            collection.add(modelDeltaNode.getElement());
            return;
        }
        if (modelDeltaNode.getElementUniqueName() != null) {
            if (modelDeltaNode.isDeleted()) {
                collection3.add(modelDeltaNode.getElementUniqueName());
                return;
            }
            if (modelDeltaNode.isChanged()) {
                collection2.add(modelDeltaNode.getElement());
                return;
            }
        }
        Enumeration enumeration = modelDeltaNode.changedChildren();
        while (enumeration.hasMoreElements()) {
            this.processDelta((ModelDeltaNode)enumeration.nextElement(), collection, collection2, collection3);
        }
    }

    protected Object findTreeElement(Object object, Object object2, Collection collection) {
        Object[] objectArray = ((UMLExplorerContentProvider)this.getViewer().getContentProvider()).getElements(object);
        collection.add(object);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(object2)) {
                collection.add(objectArray[n]);
                return objectArray[n];
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object3 = this.findTreeElement(objectArray[n2], object2, collection);
            if (object3 != null) {
                return object3;
            }
            ++n2;
        }
        collection.remove(object);
        return null;
    }
}

