/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.java.properties.providers;

import com.togethersoft.togetherxj.java.properties.providers.TypeUinSerializer;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class PropertyUtil {
    public static final String VOID = "V";
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";
    private static String PROPERTY_SUBDOMAIN = "e_property";
    private static String JDT_DOMAIN = "property";

    public static boolean isPartOfAProperty(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IField) {
            String string = null;
            if (iJavaElement.getElementName() == null || iJavaElement.getElementName().length() < 1) {
                return false;
            }
            try {
                string = ((IField)iJavaElement).getTypeSignature();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            return PropertyUtil.hasGetterOrSetter((IType)iJavaElement.getParent(), iJavaElement.getElementName(), string);
        }
        if (iJavaElement instanceof IMethod) {
            IMethod iMethod = (IMethod)iJavaElement;
            String string = null;
            Object var3_5 = null;
            try {
                if (iMethod.getElementName().startsWith(SET_PREFIX)) {
                    if (iMethod.getReturnType().equals(VOID) && iMethod.getNumberOfParameters() == 1) {
                        string = iMethod.getParameterTypes()[0];
                    }
                } else if (iMethod.getElementName().startsWith(GET_PREFIX) && iMethod.getNumberOfParameters() == 0) {
                    string = iMethod.getReturnType();
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            if (string != null) {
                String string2 = iMethod.getElementName().substring(GET_PREFIX.length());
                return PropertyUtil.hasField((IType)iJavaElement.getParent(), PropertyUtil.normalizePropertyName(string2), string) || PropertyUtil.hasField((IType)iJavaElement.getParent(), string2, string);
            }
        }
        return false;
    }

    private static boolean isGetterOrSetterMethodName(String string) {
        return string != null && string.length() > GET_PREFIX.length() && (string.startsWith(GET_PREFIX) || string.startsWith(SET_PREFIX));
    }

    public static boolean hasGetterOrSetter(IType iType, String string, String string2) {
        String string3 = PropertyUtil.getGetterName(string);
        IMethod iMethod = iType.getMethod(string3, new String[0]);
        if (PropertyUtil.isGetter(iMethod, string2)) {
            return true;
        }
        String string4 = PropertyUtil.getSetterName(string);
        IMethod iMethod2 = iType.getMethod(string4, new String[]{string2});
        return PropertyUtil.isSetter(iMethod2, string2);
    }

    public static boolean hasField(IType iType, String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        IField iField = iType.getField(string);
        if (iField == null) {
            return false;
        }
        try {
            return string2.equals(iField.getTypeSignature());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean hasProperty(IType iType, String string, String string2) {
        return PropertyUtil.hasField(iType, string, string2) && PropertyUtil.hasGetterOrSetter(iType, string, string2);
    }

    public static String getSetterName(String string) {
        return SET_PREFIX + PropertyUtil.denormalizePropertyName(string);
    }

    public static String getGetterName(String string) {
        return GET_PREFIX + PropertyUtil.denormalizePropertyName(string);
    }

    public static IField getField(IType iType, String string, String string2) {
        return iType.getField(string);
    }

    public static IMethod getSetter(IType iType, String string, String string2) {
        return iType.getMethod(PropertyUtil.getSetterName(string), new String[]{string2});
    }

    public static IMethod getGetter(IType iType, String string, String string2) {
        return iType.getMethod(PropertyUtil.getGetterName(string), new String[0]);
    }

    protected static boolean isSetter(IMethod iMethod, String string) {
        try {
            return iMethod != null && (iMethod.getFlags() & 1) > 0 && (iMethod.getFlags() & 8) == 0 && VOID.equals(iMethod.getReturnType()) && iMethod.getNumberOfParameters() == 1 && string.equals(iMethod.getParameterTypes()[0]);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected static boolean isGetter(IMethod iMethod, String string) {
        try {
            return iMethod != null && (iMethod.getFlags() & 1) > 0 && (iMethod.getFlags() & 8) == 0 && string.equals(iMethod.getReturnType()) && iMethod.getNumberOfParameters() == 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected static String normalizePropertyName(String string) {
        boolean bl;
        if (string == null || string.length() < 1) {
            return string;
        }
        if (string.startsWith(GET_PREFIX) || string.startsWith(SET_PREFIX)) {
            string = string.substring(GET_PREFIX.length());
        }
        if (string.length() == 0) {
            return string;
        }
        boolean bl2 = bl = string.length() > 1 && !Character.isLowerCase(string.charAt(1));
        if (bl) {
            return string;
        }
        char c = Character.toLowerCase(string.charAt(0));
        string = string.length() > 1 ? c + string.substring(1) : c + "";
        return string;
    }

    protected static String denormalizePropertyName(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isUpperCase(c)) {
            return string;
        }
        if (string.length() > 1) {
            return Character.toUpperCase(c) + string.substring(1);
        }
        return Character.toUpperCase(c) + "";
    }

    public static UniqueName createPropertyUniqueName(Element element, String string, String string2) {
        String string3 = TypeUinSerializer.serialize(element.getUniqueName());
        return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)PROPERTY_SUBDOMAIN, (String)string3, (String)string, (String[])new String[]{string2});
    }

    protected static Entity getField(Element element) {
        Entity entity = element.getParent();
        IType iType = (IType)ElementUtil.getJavaElement((Element)entity);
        IField iField = iType.getField(element.getUniqueName().getName());
        return (Entity)ElementUtil.getModelElement((UniqueName)element.getModel().getUniqueName(), (IJavaElement)iField);
    }

    protected static Entity getGetter(Element element) {
        Entity entity = element.getParent();
        IType iType = (IType)ElementUtil.getJavaElement((Element)entity);
        String string = PropertyUtil.getGetterName(element.getUniqueName().getName());
        IMethod iMethod = iType.getMethod(string, new String[0]);
        return (Entity)ElementUtil.getModelElement((UniqueName)element.getModel().getUniqueName(), (IJavaElement)iMethod);
    }

    protected static Entity getSetter(Element element) {
        Entity entity = element.getParent();
        IType iType = (IType)ElementUtil.getJavaElement((Element)entity);
        String string = PropertyUtil.getSetterName(element.getUniqueName().getName());
        IMethod iMethod = iType.getMethod(string, new String[]{element.getUniqueName().getParameter(0)});
        return (Entity)ElementUtil.getModelElement((UniqueName)element.getModel().getUniqueName(), (IJavaElement)iMethod);
    }
}

