/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.java.properties.providers;

import com.togethersoft.togetherxj.java.properties.PropertiesPlugin;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class PropertiesDeltaProvider
implements DeltaTreeProvider,
ModelAware,
IElementChangedListener {
    private IJavaProject myProject;
    private Model myModel;
    private RootModelDeltaNode myCurrentDelta;

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        if (!PropertiesPlugin.isRecognizeProperties()) {
            return;
        }
        IJavaElementDelta iJavaElementDelta = elementChangedEvent.getDelta();
        try {
            this.processDelta(iJavaElementDelta);
        }
        catch (JavaModelException javaModelException) {
            PropertiesPlugin.log(4, javaModelException);
        }
    }

    public void processDelta(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        if (iJavaElement instanceof IType && iJavaElement.exists() && ((IType)iJavaElement).isInterface()) {
            return;
        }
        if (iJavaElement instanceof IField) {
            RootModelDeltaNode rootModelDeltaNode = this.myCurrentDelta;
            synchronized (rootModelDeltaNode) {
                this.addChanged((IType)iJavaElement.getParent());
            }
            return;
        }
        if (iJavaElement instanceof IMethod) {
            if (iJavaElement.getElementName().startsWith("set") || iJavaElement.getElementName().startsWith("get")) {
                RootModelDeltaNode rootModelDeltaNode = this.myCurrentDelta;
                synchronized (rootModelDeltaNode) {
                    this.addChanged((IType)iJavaElement.getParent());
                }
            }
        } else {
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                this.processDelta(iJavaElementDeltaArray[n]);
                ++n;
            }
        }
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode rootModelDeltaNode = null;
        RootModelDeltaNode rootModelDeltaNode2 = this.myCurrentDelta;
        synchronized (rootModelDeltaNode2) {
            rootModelDeltaNode = this.myCurrentDelta;
            this.myCurrentDelta = new RootModelDeltaNode(this.myModel);
        }
        return rootModelDeltaNode;
    }

    public void registered(Model model) {
        this.myProject = ElementUtil.getJavaProject((UniqueName)model.getUniqueName());
        this.myModel = model;
        JavaCore.addElementChangedListener((IElementChangedListener)this);
        this.myCurrentDelta = new RootModelDeltaNode(model);
    }

    public void unregistered(Model model) {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.myProject = null;
        this.myModel = null;
        this.myCurrentDelta = null;
    }

    protected void addChanged(IType iType) {
        Entity entity = (Entity)ElementUtil.getModelElement((UniqueName)this.myModel.getUniqueName(), (IJavaElement)iType);
        if (entity == null || entity.isDeleted()) {
            return;
        }
        this.myCurrentDelta.addDeltaNode((TreeModelDeltaNode)new DefaultModelDeltaNode(this.myModel, entity.getUniqueName(), ModelDeltaNodeKind.CHANGED));
    }
}

