/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.lib.util.Queue;
import com.sap.engine.services.httptunneling.HttpLib;
import com.sap.engine.services.httptunneling.HttpTunnelingInputStream;
import com.sap.engine.services.httptunneling.HttpTunnelingOutputStream;
import com.sap.engine.services.httptunneling.HttpTunnelingServerSocket;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import com.sap.engine.services.httptunneling.ServerWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;

public class ServerReader
extends Thread {
    private HttpTunnelingServerSocket server;
    private Queue baseSockets;
    private Queue newSockets;
    private ConcurrentHashMapLongObject allSockets;

    ServerReader(HttpTunnelingServerSocket server, Queue baseSockets, Queue newSockets, ConcurrentHashMapLongObject allSockets) {
        this.server = server;
        this.baseSockets = baseSockets;
        this.newSockets = newSockets;
        this.allSockets = allSockets;
    }

    private void sendReceive(Socket socket, byte[] bytes) throws IOException {
        OutputStream out = socket.getOutputStream();
        out.write(bytes);
        out.flush();
        try {
            out.close();
            socket.close();
        }
        catch (IOException e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected IOException in ServerReader.sendReceive - " + e.getMessage());
        }
    }

    private void dealWithIncorrectSocket(Socket socket, long number) {
        try {
            socket.close();
        }
        catch (IOException exc) {
            HttpTunnelingServiceFrame.log(400, "Unexpected IOException in ServerReader.dealWithIncorrectSocket - " + exc.getMessage());
        }
        HttpTunnelingServiceFrame.log(500, "Connection with client killed - can not find the socket with number " + number);
    }

    public void run() {
        String header = null;
        while (!this.server.isClosed()) {
            Socket socket = null;
            Queue queue = this.baseSockets;
            synchronized (queue) {
                while (this.baseSockets.size() == 0) {
                    try {
                        this.baseSockets.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                socket = (Socket)this.baseSockets.dequeue();
            }
            try {
                header = HttpLib.readHeader(socket.getInputStream());
                long headerMessage = HttpLib.getHeaderFullMessage(header);
                switch (HttpLib.getHeaderMessage(headerMessage)) {
                    case 1: {
                        long lastNumber = 0L;
                        HttpTunnelingServerSocket httpTunnelingServerSocket = this.server;
                        synchronized (httpTunnelingServerSocket) {
                            lastNumber = this.server.lastNumber = HttpLib.getNextNumber(this.server.lastNumber);
                        }
                        HttpTunnelingSocket hts = new HttpTunnelingSocket(lastNumber, HttpLib.getSocketId(header), this.server, InetAddress.getByName(HttpLib.getLocalIP(header)), InetAddress.getByName(HttpLib.getHost(header)));
                        hts.setStatus((byte)0);
                        ConcurrentHashMapLongObject concurrentHashMapLongObject = this.allSockets;
                        synchronized (concurrentHashMapLongObject) {
                            if (!this.server.isClosed()) {
                                this.allSockets.put(lastNumber, (Object)hts);
                            }
                        }
                        this.sendReceive(socket, HttpLib.buildResponse(lastNumber));
                        break;
                    }
                    case 2: {
                        long key = HttpLib.getHeaderNumber(headerMessage);
                        HttpTunnelingSocket hts = (HttpTunnelingSocket)this.allSockets.get(key);
                        if (!hts.getId().equals(HttpLib.getSocketId(header))) {
                            throw new Exception("Invalid socket identificator! It can be a hackers attack from " + socket.getInetAddress() + "!");
                        }
                        if (hts != null && hts.getStatus() == 0) {
                            ((ServerWriter)((HttpTunnelingOutputStream)hts.getOutputStream()).getWriter()).setOutput(socket);
                            hts.setStatus((byte)1);
                            Queue queue2 = this.newSockets;
                            synchronized (queue2) {
                                this.newSockets.enqueue((Object)hts);
                                this.newSockets.notifyAll();
                                break;
                            }
                        }
                        this.dealWithIncorrectSocket(socket, HttpLib.getHeaderNumber(headerMessage));
                        break;
                    }
                    case 4: {
                        HttpTunnelingSocket hts = (HttpTunnelingSocket)this.allSockets.get(HttpLib.getHeaderNumber(headerMessage));
                        if (!hts.getId().equals(HttpLib.getSocketId(header))) {
                            throw new Exception("Invalid socket identificator! It can be a hackers attack from " + socket.getInetAddress() + "!");
                        }
                        if (hts != null && (hts.getStatus() == 2 || hts.getStatus() == 5)) {
                            ((ServerWriter)((HttpTunnelingOutputStream)hts.getOutputStream()).getWriter()).setOutput(socket);
                            break;
                        }
                        this.dealWithIncorrectSocket(socket, HttpLib.getHeaderNumber(headerMessage));
                        break;
                    }
                    case 0: {
                        HttpTunnelingSocket hts = (HttpTunnelingSocket)this.allSockets.get(HttpLib.getHeaderNumber(headerMessage));
                        if (!hts.getId().equals(HttpLib.getSocketId(header))) {
                            throw new Exception("Invalid socket identificator! It can be a hackers attack from " + socket.getInetAddress() + "!");
                        }
                        if (hts != null && hts.getStatus() != 4) {
                            HttpTunnelingInputStream hin = (HttpTunnelingInputStream)hts.getInputStream();
                            hin.addData(HttpLib.readMessage(socket.getInputStream(), HttpLib.getMessageLength(header)));
                            this.sendReceive(socket, HttpLib.buildResponse(4L));
                            break;
                        }
                        this.dealWithIncorrectSocket(socket, HttpLib.getHeaderNumber(headerMessage));
                        break;
                    }
                    case 8: {
                        HttpTunnelingSocket hts = (HttpTunnelingSocket)this.allSockets.get(HttpLib.getHeaderNumber(headerMessage));
                        if (!hts.getId().equals(HttpLib.getSocketId(header))) {
                            throw new Exception("Invalid socket identificator! It can be a hackers attack from " + socket.getInetAddress() + "!");
                        }
                        if (hts != null) {
                            hts.kill();
                            this.sendReceive(socket, HttpLib.buildResponse(4L));
                            break;
                        }
                        this.dealWithIncorrectSocket(socket, HttpLib.getHeaderNumber(headerMessage));
                        break;
                    }
                    case 16: {
                        HttpTunnelingSocket hts = (HttpTunnelingSocket)this.allSockets.get(HttpLib.getHeaderNumber(headerMessage));
                        if (!hts.getId().equals(HttpLib.getSocketId(header))) {
                            throw new Exception("Invalid socket identificator! It can be a hackers attack from " + socket.getInetAddress() + "!");
                        }
                        if (hts != null) {
                            ((HttpTunnelingInputStream)hts.getInputStream()).closeLocally();
                            this.sendReceive(socket, HttpLib.buildResponse(4L));
                            break;
                        }
                        this.dealWithIncorrectSocket(socket, HttpLib.getHeaderNumber(headerMessage));
                        break;
                    }
                    default: {
                        throw new UnsupportedEncodingException();
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                HttpTunnelingServiceFrame.log(500, "Connection with client killed - Invalid httptunneling header! \n" + header);
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    HttpTunnelingServiceFrame.log(400, "Unexpected IOException in ServerReader.run:190 - " + ioe.getMessage());
                }
            }
            catch (Exception e) {
                HttpTunnelingServiceFrame.log(500, "Connection with client killed - " + e.toString());
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    HttpTunnelingServiceFrame.log(400, "Unexpected IOException in ServerReader.run:197 - " + ioe.getMessage());
                }
            }
        }
    }
}

