/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.transport.TransportContext;
import com.sap.engine.frame.cluster.transport.TransportFactory;
import com.sap.engine.frame.cluster.transport.TransportSupplier;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.services.httptunneling.HttpTunnelingTransportFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import java.util.Properties;

public class HttpTunnelingServiceFrame
implements CommunicationServiceFrame,
TransportSupplier {
    public static Location location = null;
    private ServiceState serviceState = null;
    private TransportContext tc = null;
    static int prop_IdLength = 8;
    static int prop_ReadersCount = 1;
    static int prop_MaxBuffer = 0x100000;
    static int prop_Timeout = 10000;
    static int prop_MaxHLLength = 255;
    static int prop_MaxHLines = 30;

    public void start(CommunicationServiceContext sdc) throws ServiceException {
        this.serviceState = sdc.getServiceState();
        this.changeProperties(this.serviceState.getProperties());
        location = Location.getLocation((String)this.getClass().getName());
        try {
            this.tc = sdc.getClusterContext().getTransportContext();
            this.tc.registerTransportSupplier("httptunneling", (TransportSupplier)this);
            HttpTunnelingServiceFrame.log(300, "Http Tunneling Service started.");
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(500, "Http Tunneling Service just starting and : " + e.getMessage());
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() {
        this.tc.unregisterTransportSupplier("httptunneling");
        HttpTunnelingServiceFrame.log(300, "Http Tunneling Service stopped.");
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        try {
            int tmp_prop_IdLength = properties.getProperty("SocketsIDLength") == null ? prop_IdLength : Integer.parseInt(properties.getProperty("SocketsIDLength"));
            int tmp_prop_ReadersCount = properties.getProperty("ServerReaderThreads") == null ? prop_ReadersCount : Integer.parseInt(properties.getProperty("ServerReaderThreads"));
            int tmp_prop_MaxBuffer = properties.getProperty("MaxInputBufferSize") == null ? prop_MaxBuffer : Integer.parseInt(properties.getProperty("MaxInputBufferSize"));
            int tmp_prop_Timeout = properties.getProperty("InputStreamAddTimeout") == null ? prop_Timeout : Integer.parseInt(properties.getProperty("InputStreamAddTimeout"));
            int tmp_prop_MaxHLLength = properties.getProperty("MaximumHeaderLineLength") == null ? prop_MaxHLLength : Integer.parseInt(properties.getProperty("MaximumHeaderLineLength"));
            int tmp_prop_MaxHLines = properties.getProperty("MaximumHeaderLines") == null ? prop_MaxHLines : Integer.parseInt(properties.getProperty("MaximumHeaderLines"));
            prop_IdLength = tmp_prop_IdLength;
            prop_ReadersCount = tmp_prop_ReadersCount;
            prop_MaxBuffer = tmp_prop_MaxBuffer;
            prop_Timeout = tmp_prop_Timeout;
            prop_MaxHLLength = tmp_prop_MaxHLLength;
            prop_MaxHLines = tmp_prop_MaxHLines;
            return true;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.getMessage());
        }
    }

    public TransportFactory getTransportFactory(TransportFactory underlineFactory) {
        return new HttpTunnelingTransportFactory(underlineFactory);
    }

    public Object getServiceInterface() {
        return null;
    }

    static void log(int severity, String message) {
        if (location != null) {
            location.logT(severity, message);
        } else {
            System.out.println(Severity.toString((int)severity) + ':' + message);
        }
    }
}

