/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.test;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.test.AbstractTestCall;

public class TestSampleCalls
extends AbstractTestCall {
    public void prepare() throws Exception {
        super.prepare();
    }

    public void test_CreateAndRelease() {
        RpeObject o1 = this.m_context.createObject("SAMPLE_CLASS_1");
        this.flush();
        this.verify(this.noErrors(), "Create object failed.", 3);
        o1.release();
        this.flush();
        this.verify(this.noErrors(), "Release object failed.");
    }

    public void test_Call() {
        this.clear();
        RpeMethod m1 = this.m_o1.createMethod("METHOD1");
        this.m_o1.callMethod(m1);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
    }

    public void test_CallWithOneInParam() {
        this.clear();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("A simple parameter");
        String v1Str = v1.getStringValue();
        m2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v1);
        this.m_o1.callMethod(m2);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        this.verify(v1Str == v1.getStringValue(), "Input parameter changed.");
    }

    public void test_CallWithTwoInParams() {
        this.clear();
        RpeMethod m3 = this.m_o1.createMethod("METHOD3");
        IEdoAtomicValue v1 = this.m_context.createValue("A simple parameter");
        IEdoAtomicValue v2 = this.m_context.createValue("100");
        String v1Str = v1.getStringValue();
        String v2Str = v2.getStringValue();
        m3.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v1);
        m3.addImportingParameter("PARAMETER2", "INT4", RpeParameterMeta.Atomic, (IEdoValue)v2);
        this.m_o1.callMethod(m3);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        this.verify(v1Str == v1.getStringValue(), "Input parameter 1 changed.");
        this.verify(v2Str == v2.getStringValue(), "Input parameter 2 changed.");
    }

    public void test_CallWithASimpleReturnValue() {
        this.clear();
        RpeMethod m4 = this.m_o1.createMethod("METHOD4");
        IEdoAtomicValue v1 = this.m_context.createValue("Need to be changed");
        String v1Str = v1.getStringValue();
        m4.addReturnParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v1);
        this.m_o1.callMethod(m4);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        this.verify(v1Str != v1.getStringValue(), "Retrun parameter did not change.");
    }

    public void test_CallWithAnInObject() {
        this.clear();
        RpeMethod m6 = this.m_o1.createMethod("METHOD6");
        m6.addImportingParameter("PARAMETER1", "SAMPLE_CLASS_1", RpeParameterMeta.Object, (IEdoValue)this.m_o1);
        this.m_o1.callMethod(m6);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
    }

    public void test_CallWithAReturnObject() {
        this.clear();
        RpeMethod m11 = this.m_o1.createMethod("METHOD11");
        RpeObject o2 = this.m_context.createObject();
        m11.addReturnParameter("OBJ", "SAMPLE_CLASS_2", RpeParameterMeta.Object, (IEdoValue)o2);
        this.m_o1.callMethod(m11);
        this.flush();
        this.verify(this.m_context.getErrors() == null, "Method call failed.");
        RpeMethod m1 = o2.createMethod("SEARCH");
        IEdoAtomicValue vIn = this.m_context.createValue("Good");
        String vInStr = vIn.getStringValue();
        IEdoAtomicValue vOut = this.m_context.createValue("This text should be replaced.");
        m1.addImportingParameter("NAME1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)vIn);
        m1.addExportingParameter("NAME2", "STRING", RpeParameterMeta.Atomic, (IEdoValue)vOut);
        o2.callMethod(m1);
        this.flush();
        this.verify(this.noErrors(), "Method call on returned object failed.");
        this.verify(vInStr.equals(vOut.getStringValue()), "Exported value is not set correctly for the returned object.");
        o2.release();
        this.flush();
        this.verify(this.noErrors(), "Release of returned object failed.");
    }

    public void test_CallWithAnInStructure() {
        this.clear();
        RpeMethod m8 = this.m_o1.createMethod("METHOD8");
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_1);
        s1.setStringValue("FIELD1", "This is field 1 ");
        s1.setStringValue("FIELD3", "100");
        String field1 = s1.getStringValue("FIELD1");
        String field3 = s1.getStringValue("FIELD3");
        m8.addImportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Structure, (IEdoValue)s1);
        this.m_o1.callMethod(m8);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        this.verify(field1 == s1.getStringValue("FIELD1"), "Imported structure changed.");
        this.verify(field3 == s1.getStringValue("FIELD3"), "Imported structure changed.");
    }

    public void test_CallWithAnOutStructure() {
        this.clear();
        RpeMethod m9 = this.m_o1.createMethod("METHOD9");
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_1);
        s1.setStringValue("FIELD1", "This is to be replaced ");
        s1.setStringValue("FIELD3", "9899");
        m9.addExportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Structure, (IEdoValue)s1);
        this.m_o1.callMethod(m9);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        String field1 = s1.getStringValue("FIELD1");
        String field3 = s1.getStringValue("FIELD3");
        this.verify("This is a return value".equals(field1), "Field1 value not correct:" + field1);
        this.verify("11".equals(field3), "Field3 value is not correct:" + field3);
    }

    public void test_CallWithAnInTable() {
        this.clear();
        RpeMethod m12 = this.m_o1.createMethod("METHOD12");
        IEdoTable t1 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_1);
        t1.append(1000);
        int i = 0;
        while (i < 1000) {
            t1.setStringValue(i, "FIELD1", "This is parameter " + i);
            t1.setStringValue(i, "FIELD3", String.valueOf(i));
            ++i;
        }
        int recordCount = t1.getRecordCount();
        m12.addImportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Table, (IEdoValue)t1);
        this.m_o1.callMethod(m12);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        this.verify(recordCount == t1.getRecordCount(), "Imported table changed.");
    }

    public void test_CallWithAnOutTable() {
        this.clear();
        RpeMethod m10 = this.m_o1.createMethod("METHOD10");
        IEdoTable t1 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_1);
        t1.append(4);
        int i = 0;
        while (i < 4) {
            t1.setStringValue(i, "FIELD1", "This is parameter " + i);
            t1.setStringValue(i, "FIELD3", String.valueOf(i));
            ++i;
        }
        m10.addExportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Table, (IEdoValue)t1);
        this.m_o1.callMethod(m10);
        this.flush();
        this.verify(this.noErrors(), "Method call failed.");
        int recordCount = t1.getRecordCount();
        this.verify(recordCount == 1001, "Exported table doesn't have expected number of rows:" + recordCount);
    }

    protected void flush() {
        this.m_context.flush();
    }
}

