/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.test;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.test.AbstractTestCall;

public class TestRpeProxy
extends AbstractTestCall {
    StructureDescriptor m_structDef_5_1;

    public void prepare() throws Exception {
        super.prepare();
        FieldDescriptor[] fields = new FieldDescriptor[]{new FieldDescriptor("STRING_VALUE", "STRING"), new FieldDescriptor("INT_VALUE", "INTEGER")};
        this.m_structDef_5_1 = new StructureDescriptor("RPE_SVER_5_1", fields);
    }

    public void test_object_instances_lifetime_behavior() {
        String class_a = "CL_RPE_SVER_1_1";
        String class_b = "CL_RPE_SVER_1_2";
        int noOfInstances = 5;
        RpeObject[] instance_a = new RpeObject[noOfInstances];
        RpeObject[] instance_b = new RpeObject[noOfInstances];
        int i = 0;
        while (i < noOfInstances) {
            instance_a[i] = this.m_context.createObject(class_a);
            instance_b[i] = this.m_context.createObject(class_b);
            ++i;
        }
        this.m_context.flush();
        this.verify(this.noErrors(), "Creation of object instances failed.\n" + this.m_context.getErrors());
        IEdoAtomicValue[] setValue_a = new IEdoAtomicValue[noOfInstances];
        IEdoAtomicValue[] setValue_b = new IEdoAtomicValue[noOfInstances];
        int i2 = 0;
        while (i2 < noOfInstances) {
            RpeMethod setMethod_a = this.m_context.createMethod("SET_VALUE");
            setValue_a[i2] = this.m_context.createValue("Original Value of " + class_a + " instance # " + i2);
            setMethod_a.addImportingParameter("VALUE", "STRING", RpeParameterMeta.Atomic, (IEdoValue)setValue_a[i2]);
            instance_a[i2].callMethod(setMethod_a);
            RpeMethod setMethod_b = this.m_context.createMethod("SET_VALUE");
            setValue_b[i2] = this.m_context.createValue("98" + (100000 + i2));
            setMethod_b.addImportingParameter("VALUE", "INT4", RpeParameterMeta.Atomic, (IEdoValue)setValue_b[i2]);
            instance_b[i2].callMethod(setMethod_b);
            ++i2;
        }
        this.m_context.flush();
        this.dumpErrors();
        this.verify(this.noErrors(), "Setting of values failed.");
        IEdoAtomicValue[] getValue_a = new IEdoAtomicValue[noOfInstances];
        IEdoAtomicValue[] getValue_b = new IEdoAtomicValue[noOfInstances];
        int i3 = 0;
        while (i3 < noOfInstances) {
            RpeMethod getMethod_a = this.m_context.createMethod("GET_VALUE");
            getValue_a[i3] = this.m_context.createValue("place holder");
            getMethod_a.addExportingParameter("VALUE", "STRING", RpeParameterMeta.Atomic, (IEdoValue)getValue_a[i3]);
            instance_a[i3].callMethod(getMethod_a);
            RpeMethod getMethod_b = this.m_context.createMethod("GET_VALUE");
            getValue_b[i3] = this.m_context.createValue("place holder");
            getMethod_b.addExportingParameter("VALUE", "INT4", RpeParameterMeta.Atomic, (IEdoValue)getValue_b[i3]);
            instance_b[i3].callMethod(getMethod_b);
            ++i3;
        }
        this.m_context.flush();
        this.verify(this.noErrors(), "Getting of values failed.");
        int i4 = 0;
        while (i4 < noOfInstances) {
            this.verify(setValue_a[i4].equals(getValue_a[i4]), "Value different for instance " + i4 + " of class " + class_a, 1);
            this.verify(this.integerCompare(setValue_b[i4], getValue_b[i4]), "Value different for instance " + i4 + " of class " + class_a, 1);
            ++i4;
        }
        int i5 = 0;
        while (i5 < noOfInstances) {
            if (i5 % 3 == 2) {
                instance_a[i5].release();
            }
            if (i5 % 3 == 1) {
                instance_b[i5].release();
            }
            ++i5;
        }
        this.m_context.flush();
        this.verify(this.noErrors(), "Release of first batch of objects failed", 1);
        int i6 = 0;
        while (i6 < noOfInstances) {
            if (i6 % 3 == 0) {
                instance_a[i6].release();
            }
            if (i6 % 3 == 2) {
                instance_b[i6].release();
            }
            ++i6;
        }
        this.m_context.flush();
        this.verify(this.noErrors(), "Release of second batch of objects failed");
        int i7 = 0;
        while (i7 < noOfInstances) {
            if (i7 % 3 == 1) {
                instance_a[i7].release();
            }
            if (i7 % 3 == 0) {
                instance_b[i7].release();
            }
            ++i7;
        }
        this.m_context.flush();
        this.verify(this.noErrors(), "Release of third batch of objects failed");
    }

    public void test_object_instances_security_behavior() {
        this.clear();
        String class_1 = "CL_RPE_SVER_2_1";
        RpeObject instance_1 = null;
        instance_1 = this.m_context.createObject(class_1);
        this.m_context.flush();
        this.verify(this.m_context.getErrors().size() == 1, "There should have been only one error");
        this.verifyError(0, "RPE", "RPE_CNF", instance_1.getName(), class_1, "", null, null);
        instance_1.release();
        this.m_context.flush();
        this.verify(this.m_context.getErrors().size() == 2, "There should have been only one error");
        this.verifyError(1, "RPE", "RPE_ONF", instance_1.getName(), null, "", "OBJECT", instance_1.getName());
    }

    public void test_performance_of_client_proxy_framework() {
        this.clear();
        String class_1 = "CL_RPE_SVER_5_1";
        String class_2 = "CL_RPE_SVER_5_2";
        RpeObject instance_1 = null;
        RpeObject instance_2 = null;
        instance_1 = this.m_context.createObject(class_1);
        RpeMethod method_1_1 = instance_1.createMethod("SET_STRING");
        IEdoAtomicValue value_1_1 = this.m_context.createValue("RPE_TEST_1");
        method_1_1.addImportingParameter("STRING_VALUE", "STRING", RpeParameterMeta.Atomic, (IEdoValue)value_1_1);
        instance_1.callMethod(method_1_1);
        RpeMethod method_1_2 = instance_1.createMethod("SET_INT");
        IEdoAtomicValue value_1_2 = this.m_context.createValue("100");
        method_1_2.addImportingParameter("INT_VALUE", "INT4", RpeParameterMeta.Atomic, (IEdoValue)value_1_2);
        instance_1.callMethod(method_1_2);
        RpeMethod method_1_3 = instance_1.createMethod("GET_STRUCT");
        IEdoStructure value_1_3 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_5_1);
        method_1_3.addExportingParameter("STRUCT_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Structure, (IEdoValue)value_1_3);
        instance_1.callMethod(method_1_3);
        RpeMethod method_2_1 = instance_1.createMethod("SET_STRING_AND_INT");
        IEdoAtomicValue value_2_1 = this.m_context.createValue("RPE_TEST_2");
        IEdoAtomicValue value_2_2 = this.m_context.createValue("200");
        method_2_1.addImportingParameter("STRING_VALUE", "STRING", RpeParameterMeta.Atomic, (IEdoValue)value_2_1);
        method_2_1.addImportingParameter("INT_VALUE", "INT4", RpeParameterMeta.Atomic, (IEdoValue)value_2_2);
        instance_1.callMethod(method_2_1);
        RpeMethod method_2_2 = instance_1.createMethod("GET_STRUCT");
        IEdoStructure value_2_3 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_5_1);
        method_2_2.addExportingParameter("STRUCT_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Structure, (IEdoValue)value_2_3);
        instance_1.callMethod(method_2_2);
        RpeMethod method_3_1 = instance_1.createMethod("SET_STRING_AND_INT_GET_STRUCT");
        IEdoAtomicValue value_3_1 = this.m_context.createValue("RPE_TEST_3");
        IEdoAtomicValue value_3_2 = this.m_context.createValue("300");
        IEdoStructure value_3_3 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_5_1);
        method_3_1.addImportingParameter("STRING_VALUE", "STRING", RpeParameterMeta.Atomic, (IEdoValue)value_3_1);
        method_3_1.addImportingParameter("INT_VALUE", "INT4", RpeParameterMeta.Atomic, (IEdoValue)value_3_2);
        method_3_1.addExportingParameter("STRUCT_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Structure, (IEdoValue)value_3_3);
        instance_1.callMethod(method_3_1);
        instance_1.release();
        instance_2 = this.m_context.createObject(class_2);
        IEdoStructure[] values_1_1 = new IEdoStructure[10];
        int recCount = 10;
        int i = 0;
        while (i < recCount) {
            String intVal = Integer.toString(i + 1);
            String strVal = "RPE_TEST_" + intVal;
            values_1_1[i] = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_5_1);
            values_1_1[i].setStringValue("STRING_VALUE", strVal);
            values_1_1[i].setStringValue("INT_VALUE", intVal);
            RpeMethod method_1_12 = instance_2.createMethod("ADD_STRUCT_TO_LIST");
            method_1_12.addImportingParameter("STRUCT_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Structure, (IEdoValue)values_1_1[i]);
            instance_2.callMethod(method_1_12);
            ++i;
        }
        RpeMethod method_1_22 = instance_2.createMethod("GET_TABLE");
        IEdoTable value_1_22 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_5_1);
        method_1_22.addReturnParameter("TABLE_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Table, (IEdoValue)value_1_22);
        instance_2.callMethod(method_1_22);
        RpeMethod method_2_12 = instance_2.createMethod("SET_TABLE");
        IEdoTable value_2_12 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_5_1);
        value_2_12.append(recCount);
        int i2 = 0;
        while (i2 < recCount) {
            String intVal = String.valueOf(i2);
            String strVal = "RPE_TEST_" + intVal;
            value_2_12.setStringValue(i2, "STRING_VALUE", strVal);
            value_2_12.setStringValue(i2, "INT_VALUE", intVal);
            ++i2;
        }
        method_2_12.addImportingParameter("TABLE_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Table, (IEdoValue)value_2_12);
        instance_2.callMethod(method_2_12);
        RpeMethod method_2_22 = instance_2.createMethod("GET_TABLE");
        IEdoTable value_2_22 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_5_1);
        method_2_22.addReturnParameter("TABLE_VALUE", "RPE_SVER_5_2", RpeParameterMeta.Table, (IEdoValue)value_2_22);
        instance_2.callMethod(method_2_22);
        RpeMethod method_3_12 = instance_2.createMethod("ADD_TABLE_TO_LIST_GET_TABLE");
        IEdoTable value_3_12 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_5_1);
        IEdoTable value_3_22 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_5_1);
        value_3_12.append(recCount);
        int i3 = 0;
        while (i3 < recCount) {
            String intVal = String.valueOf(10000 - i3);
            String strVal = "RPE_TEST_" + intVal;
            value_3_12.setStringValue(i3, "STRING_VALUE", strVal);
            value_3_12.setStringValue(i3, "INT_VALUE", intVal);
            ++i3;
        }
        method_3_12.addImportingParameter("TABLE_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Table, (IEdoValue)value_3_12);
        method_3_12.addReturnParameter("RETURN_TABLE_VALUE", "RPE_SVER_5_1", RpeParameterMeta.Table, (IEdoValue)value_3_22);
        instance_2.callMethod(method_3_12);
        instance_2.release();
        this.m_context.flush();
        this.verify(this.noErrors(), "Error occured while flushing.");
    }

    protected boolean integerCompare(IEdoAtomicValue v1, IEdoAtomicValue v2) {
        boolean retVal = false;
        try {
            boolean bl = retVal = Integer.parseInt(v1.getStringValue().trim()) == Integer.parseInt(v2.getStringValue().trim());
            if (!retVal) {
                this.logln("integerCompare: '" + v1 + "'<>'" + v2 + "'\n");
            }
        }
        catch (Exception ex) {
            this.logln("integerCompare: '" + v1 + "'<>'" + v2 + "' because of exception:\n");
            this.logStackTrace(ex);
        }
        return retVal;
    }
}

