/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.test;

import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.test.AbstractTestCall;

public class TestAsynchCalls
extends AbstractTestCall {
    private static final String GOOD = "Good";
    private String m_oldValue;
    private IEdoAtomicValue m_valueObj;
    private IEdoAtomicValue[] m_values;

    protected void register2MonitorExecution() {
        RpeMethod m4 = this.m_o1.createMethod("METHOD4");
        this.m_valueObj = this.m_context.createValue("Need to be changed");
        this.m_oldValue = this.m_valueObj.getStringValue();
        m4.addReturnParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)this.m_valueObj);
        this.m_o1.callMethod(m4);
    }

    protected boolean hasExecuted() {
        return this.m_oldValue != this.m_valueObj.getStringValue();
    }

    protected void queueCalls(int count) {
        this.m_values = new IEdoAtomicValue[count];
        int index = 0;
        while (index < count) {
            RpeMethod m11 = this.m_o1.createMethod("METHOD11");
            RpeObject o2 = this.m_context.createObject();
            m11.addReturnParameter("OBJ", "SAMPLE_CLASS_2", RpeParameterMeta.Object, (IEdoValue)o2);
            this.m_o1.callMethod(m11);
            this.verify(!this.hasExecuted(), "Got executed");
            RpeMethod m1 = o2.createMethod("SEARCH");
            IEdoAtomicValue vIn = this.m_context.createValue(GOOD);
            IEdoAtomicValue vOut = this.m_context.createValue("This text should be replaced.");
            m1.addImportingParameter("NAME1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)vIn);
            m1.addExportingParameter("NAME2", "STRING", RpeParameterMeta.Atomic, (IEdoValue)vOut);
            o2.callMethod(m1);
            this.verify(!this.hasExecuted(), "Got executed");
            o2.release();
            this.verify(!this.hasExecuted(), "Got executed");
            this.m_values[index] = vOut;
            ++index;
        }
    }

    protected void verifyQueuedCalls() {
        int size = this.m_values.length;
        int index = 0;
        while (index < size) {
            this.verify(GOOD.equals(this.m_values[index].getStringValue()), "Value didn't get copied.");
            ++index;
        }
    }

    public void test_flushWithContexFlush() {
        this.clear();
        this.register2MonitorExecution();
        this.queueCalls(10);
        this.m_context.flush();
        this.verify(this.hasExecuted(), "Didn't get flushed.");
        this.verify(this.noErrors(), "Errors in execution.");
        this.verifyQueuedCalls();
    }

    public void test_flushWithFlushedCall() {
        this.clear();
        this.register2MonitorExecution();
        this.queueCalls(10);
        RpeMethod m1 = this.m_o1.createMethod("METHOD1");
        this.m_o1.callMethod(m1, true);
        this.verify(this.hasExecuted(), "Didn't get flushed.");
        this.verify(this.noErrors(), "Errors in execution.");
        this.verifyQueuedCalls();
    }

    public void test_flushWithSetSynchronous() {
        this.clear();
        this.register2MonitorExecution();
        this.queueCalls(10);
        this.m_context.setSynchronous(true);
        this.m_context.setSynchronous(false);
        this.verify(this.hasExecuted(), "Didn't get flushed.");
        this.verify(this.noErrors(), "Errors in execution.");
        this.verifyQueuedCalls();
    }

    public void test_CallManyTimes() {
        this.clear();
        this.register2MonitorExecution();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("A simple parameter");
        String v1Str = v1.getStringValue();
        m2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v1);
        int i = 0;
        while (i < 10) {
            this.m_o1.callMethod(m2);
            ++i;
        }
        this.m_context.flush();
        this.verify(this.hasExecuted(), "Didn't get flushed.");
        this.verify(this.noErrors(), "Errors in execution.");
        this.verify(v1Str == v1.getStringValue(), "Input parameter changed.");
    }

    public void test_ChainedCalls() {
        this.clear();
        this.register2MonitorExecution();
        RpeObject o2 = this.m_context.createObject("CL_RSETEST02");
        int chainSize = 10;
        IEdoAtomicValue[] values = new IEdoAtomicValue[11];
        String vInStr = GOOD;
        values[0] = this.m_context.createValue(GOOD);
        int i = 1;
        while (i <= 10) {
            values[i] = this.m_context.createValue("This text should be replaced " + i);
            ++i;
        }
        int i2 = 0;
        while (i2 < 10) {
            RpeMethod m1 = o2.createMethod("SEARCH");
            m1.addImportingParameter("NAME1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)values[i2]);
            m1.addExportingParameter("NAME2", "STRING", RpeParameterMeta.Atomic, (IEdoValue)values[i2 + 1]);
            RpeMethod m2 = this.m_o1.createMethod("METHOD2");
            m2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)values[i2 + 1]);
            o2.callMethod(m1);
            ++i2;
        }
        o2.release();
        this.verify(!this.hasExecuted(), "Got flushed already.");
        this.m_context.flush();
        this.verify(this.hasExecuted(), "Didn't get flushed.");
        this.verify(this.noErrors(), "Errors in execution.");
        this.verify(GOOD.equals(values[10].getStringValue()), "Exported value is not set correctly for the returned object.");
    }

    public void prepare() throws Exception {
        super.prepare();
        this.m_context.setSynchronous(false);
    }
}

