/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.spi;

import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.RpeContext;
import com.sap.tc.col.rpe.RpeError;
import com.sap.tc.col.rpe.RpeErrors;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.spi.IRpeConnectionFactory;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;
import java.util.HashMap;

public abstract class RpeContextSpi
extends RpeContext
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$RpeContext == null ? (class$com$sap$tc$col$rpe$RpeContext = RpeContextSpi.class$("com.sap.tc.col.rpe.RpeContext")) : class$com$sap$tc$col$rpe$RpeContext).getName();
    private static final Location _location = Location.getLocation((String)_className);
    protected static HashMap Connectors;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$RpeContext;

    protected RpeContextSpi() {
    }

    protected RpeContextSpi(RpeContextSpi original) {
        super(original);
    }

    public final void releaseConnection(IRpeConnection connection) {
        this.releaseConnection((IRpeConnectionSpi)connection);
    }

    protected abstract void releaseConnection(IRpeConnectionSpi var1);

    public IRpeConnection createConnection(String channel, boolean isDefault) {
        IRpeConnectionFactory connectionFactory = (IRpeConnectionFactory)Connectors.get(this.getChannelPrefix(channel));
        if (null == connectionFactory) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createConnection", "channel", channel, "Unsupported channel");
            _location.throwing("createConnection", (Throwable)ex);
            throw ex;
        }
        IRpeConnectionSpi connection = connectionFactory.createConnection(channel);
        this.addConnection(connection, isDefault);
        return connection;
    }

    private String getChannelPrefix(String channel) {
        String prefix = channel;
        int i = channel.indexOf(58);
        if (i > 0) {
            prefix = channel.substring(0, i);
        }
        return prefix;
    }

    public void addError(String method, String opCode, String object, String className, String param, String value, String category, String code, String description, String state, String location, IRpeConnection connection) {
        if (this.m_errors == null) {
            this.m_errors = new RpeErrors();
        }
        RpeError error = new RpeError(category, code, state, description, object, className, opCode, method, param, value, location, connection);
        this.m_errors.add(error);
        if ("RPE".equalsIgnoreCase(category)) {
            if ("FATAL".equalsIgnoreCase(state)) {
                if ("SYSTEM".equalsIgnoreCase(code)) {
                    _location.fatalT("Fatal System error in remote system: " + error.toString());
                } else if ("AUTHORIZATION".equalsIgnoreCase(code)) {
                    _location.warningT("Security exception in remote system: " + error.toString());
                } else {
                    _location.fatalT("Unrecognized fatal error in remote system: " + error.toString());
                }
                this.releaseConnection(connection);
            } else if ("INVALID_OPCODE".equalsIgnoreCase(code)) {
                _location.fatalT("Internal error in proxy. Invalid opcode sent to remote system: " + error.toString());
            }
        }
        if ("FATAL".equalsIgnoreCase(state)) {
            _location.warningT("Unrecognized fatal error in remote application: " + error.toString());
        }
    }

    protected abstract void addConnection(IRpeConnectionSpi var1, boolean var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_api/com/sap/tc/col/rpe/spi/RpeContextSpi.java#1 $");
        Connectors = new HashMap(4);
    }
}

