/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.jco;

import com.sap.mw.jco.JCO;
import com.sap.tc.col.cxa.ContextAccessor;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeCommunicationException;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.RpeIllegalMethodException;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.RpeSecurityException;
import com.sap.tc.col.rpe.core.RpeValueManager;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.col.rpe.spi.IRpeValueManager;
import com.sap.tc.col.rpe.spi.RpeContextSpi;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class RpeJCoConnectionBase
implements IRpeConnectionSpi,
CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$jco$RpeJCoConnectionBase == null ? (class$com$sap$tc$col$rpe$jco$RpeJCoConnectionBase = RpeJCoConnectionBase.class$("com.sap.tc.col.rpe.jco.RpeJCoConnectionBase")) : class$com$sap$tc$col$rpe$jco$RpeJCoConnectionBase).getName();
    private static final Location _location = Location.getLocation((String)_className);
    protected static String PROPERTY_DEBUG;
    protected static String REPOSITORY;
    protected static String JCO_ABAP_DEBUG;
    protected static final Properties defaultProperties;
    protected Properties m_conProps = new Properties(defaultProperties);
    protected JCO.Client m_connection;
    protected JCO.Function m_function;
    protected int m_timeForLastCall = 0;
    protected RpeContextSpi m_errorManager;
    protected IRpeValueManager m_valueManager;
    protected ConnectionInfo m_connectionInfo = new ConnectionInfo();
    static /* synthetic */ Class class$com$sap$tc$col$rpe$jco$RpeJCoConnectionBase;

    public void release() {
        this.discardCall();
        this.disconnect();
    }

    public void connect(String locator, String client, String user, String password, String language) {
        if (this.isConnected()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "Connected", "connect", "Should not be connected.");
            _location.throwing("connect", (Throwable)re);
            throw re;
        }
        if (locator != null) {
            this.parseLocator(locator);
        }
        if (client != null) {
            this.m_conProps.setProperty("jco.client.client", client);
        }
        if (user != null) {
            this.m_conProps.setProperty("jco.client.user", user);
        }
        if (password != null) {
            this.m_conProps.setProperty("jco.client.passwd", password);
        }
        if (language != null) {
            this.m_conProps.setProperty("jco.client.lang", language);
        }
        this.connect();
    }

    public void connect(String locator, String client, String sso, String language) {
        this.connect(locator, client, "$MYSAPSSO2$", sso, language);
    }

    public void connect() {
        if (this.isConnected()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "Connected", "connect", "Should not be connected.");
            _location.throwing("connect", (Throwable)re);
            throw re;
        }
        try {
            this.m_connection = JCO.createClient((Properties)this.m_conProps);
            this.m_connection.connect();
            if ("E".equalsIgnoreCase(this.m_connection.getProperty("jco.client.type"))) {
                JCO.ParameterList input_excl = JCO.createParameterList();
                input_excl.appendValue("EXCLUSIV", 0, 1, "Y");
                this.m_connection.execute("RFC_SET_REG_SERVER_PROPERTY", input_excl, null);
            }
            ((Hashtable)this.m_conProps).remove("jco.client.passwd");
            ((Hashtable)this.m_conProps).remove("passwd");
            this.m_connectionInfo.setAttributes(this.m_connection.getAttributes());
            if (_location.getEffectiveSeverity() < 200) {
                this.m_connection.setThroughput(new JCO.Throughput());
            }
            this.m_valueManager = new RpeValueManager();
            this.m_function = this.createFunction(this.m_connection);
            String functionName = this.m_conProps.getProperty("rpe.engine.rpc_name");
            if (functionName != null) {
                this.m_function.setName(functionName);
            }
            ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_CONNECT", (Object)this);
        }
        catch (JCO.Exception ex) {
            _location.catching("connect", (Throwable)ex);
            if (this.m_connection != null) {
                this.disconnect();
            }
            ((Hashtable)this.m_conProps).remove("jco.client.passwd");
            ((Hashtable)this.m_conProps).remove("passwd");
            ((Hashtable)this.m_connectionInfo).putAll(this.m_conProps);
            switch (ex.getGroup()) {
                case 103: {
                    RpeSecurityException rex = new RpeSecurityException("Logon on the remote server failed: " + ((Hashtable)this.m_conProps).toString(), (Exception)((Object)ex));
                    _location.throwing("connect", (Throwable)rex);
                    throw rex;
                }
                case 127: 
                case 131: {
                    String message = "Internal error in RPE JCO Connection in connect(): " + ex.getKey();
                    _location.fatalT(message);
                    RpeException rex = new RpeException(message, ex);
                    _location.throwing("connect", (Throwable)rex);
                    throw rex;
                }
            }
            RpeCommunicationException rex = new RpeCommunicationException("Failed to connect to the remote system: " + ((Hashtable)this.m_conProps).toString(), (Exception)((Object)ex));
            _location.throwing("connect", (Throwable)rex);
            throw rex;
        }
        this.resetCall();
    }

    private void parseLocator(String locator) {
        int protocolIndex = locator.indexOf("://");
        if (protocolIndex == -1) {
            int indexOfAt = locator.indexOf(64);
            if (indexOfAt < 1 || locator.length() < indexOfAt + 1) {
                RpeIllegalArgumentException re = new RpeIllegalArgumentException(_className, "parseLocator", "locator", locator, "incorrect format.");
                _location.throwing("parseLocator", (Throwable)re);
                throw re;
            }
            String system = locator.substring(0, indexOfAt);
            this.m_conProps.setProperty("jco.client.sysnr", system);
            String server = locator.substring(indexOfAt + 1);
            this.m_conProps.setProperty("jco.client.ashost", server);
        } else {
            String protocol = locator.substring(0, protocolIndex);
            if ("as".equalsIgnoreCase(protocol)) {
                this.parseProperties(locator.substring(protocolIndex + 3));
            } else if ("ms".equalsIgnoreCase(protocol)) {
                this.parseProperties(locator.substring(protocolIndex + 3));
            } else if ("de".equalsIgnoreCase(protocol)) {
                this.parseProperties(locator.substring(protocolIndex + 3));
            } else {
                RpeIllegalArgumentException re = new RpeIllegalArgumentException(_className, "parseLocator", "locator", locator, "unsupported protocol '" + protocol + "'.");
                _location.throwing("parseLocator", (Throwable)re);
                throw re;
            }
        }
    }

    private void parseProperties(String properties) {
        StringTokenizer tokenizer = new StringTokenizer(properties, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken("=");
            tokenizer.nextToken("=");
            String value = tokenizer.nextToken("\"'/");
            if ("'".equals(value)) {
                value = tokenizer.nextToken("'");
                tokenizer.nextToken("'");
            } else if ("\"".equals(value)) {
                value = tokenizer.nextToken("\"");
                tokenizer.nextToken("\"");
            }
            key = key.toLowerCase();
            if (!key.startsWith("rpe") && !key.startsWith("jco.client.")) {
                key = "jco.client." + key;
            }
            this.m_conProps.setProperty(key, value);
            if (!tokenizer.hasMoreTokens()) continue;
            tokenizer.nextToken("/");
        }
    }

    public void disconnect() {
        if (this.m_connection != null) {
            try {
                this.releaseFunction();
                if ("E".equalsIgnoreCase(this.m_connection.getProperty("jco.client.type"))) {
                    JCO.ParameterList input_excl = JCO.createParameterList();
                    input_excl.appendValue("EXCLUSIV", 0, 1, "E");
                    this.m_connection.execute("RFC_SET_REG_SERVER_PROPERTY", input_excl, null);
                }
                if ((0x10 & this.m_connection.getState()) != 0) {
                    JCO.releaseClient((JCO.Client)this.m_connection);
                } else {
                    this.m_connection.disconnect();
                }
                ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_DISCONNECT", (Object)this);
                this.m_connection = null;
            }
            catch (JCO.Exception ex) {
                _location.catching("disconnect", (Throwable)ex);
                String message = "Unrecognized exception in JCO Connection in disconnect() : " + ex.getKey();
                _location.fatalT(message);
                _location.fatalT(ex.getMessage());
                RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
                _location.throwing("disconnect", (Throwable)cex);
                throw cex;
            }
        }
    }

    public void initializeCall(RpeContextSpi errorManager) {
        if (this.isInCall()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "In Call", "initializeCall", "Should not be in a call.");
            _location.throwing("initializeCall", (Throwable)re);
            throw re;
        }
        if (!this.isConnected()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "Not Connected", "initializeCall", "Should be connected.");
            _location.throwing("initializeCall", (Throwable)re);
            throw re;
        }
        this.resetCall();
        this.m_errorManager = errorManager;
    }

    public void discardCall() {
        this.resetCall();
        this.m_errorManager = null;
    }

    public void flush() {
        if (!this.isConnected()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "Not Connected", "flush", "Should be connected.");
            _location.throwing("flush", (Throwable)re);
            throw re;
        }
        if (!this.isInCall()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "not In Call", "flush", "Should be in a call.");
            _location.throwing("flush", (Throwable)re);
            throw re;
        }
        ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_BEFORE_SERIALIZE", (Object)this);
        try {
            try {
                this.fillInput();
            }
            catch (Exception ex) {
                _location.catching("flush", (Throwable)ex);
                String message = "Unhandled Exception; error in serialization";
                RpeCommunicationException cex = new RpeCommunicationException(message, ex);
                _location.throwing("flush", (Throwable)cex);
                throw cex;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_SERIALIZE", (Object)this);
            throw throwable;
        }
        ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_SERIALIZE", (Object)this);
        try {
            JCO.Throughput stats;
            JCO.Throughput throughput = stats = _location.getEffectiveSeverity() >= 200 ? this.m_connection.getThroughput() : null;
            if (stats != null && stats.getNumCalls() > 1000L) {
                stats.reset();
            }
            if (stats != null) {
                _location.pathT(RpeJCoConnectionBase.formatStatsMessage(stats));
            }
            ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_BEFORE_FLUSH", (Object)this);
            long startTime = System.currentTimeMillis();
            try {
                this.m_connection.execute(this.m_function);
                Object var7_25 = null;
            }
            catch (Throwable throwable) {
                Object var7_26 = null;
                this.m_timeForLastCall = (int)(System.currentTimeMillis() - startTime);
                ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_FLUSH", (Object)this);
                throw throwable;
            }
            this.m_timeForLastCall = (int)(System.currentTimeMillis() - startTime);
            ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_FLUSH", (Object)this);
            if (stats != null) {
                _location.pathT(RpeJCoConnectionBase.formatStatsMessage(stats));
            }
        }
        catch (JCO.Exception ex) {
            _location.catching("flush", (Throwable)ex);
            switch (ex.getGroup()) {
                case 105: 
                case 126: {
                    String message = "Engine error: Application exception propogated to client with key " + ex.getKey();
                    _location.warningT(message);
                    RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
                    _location.throwing("flush", (Throwable)cex);
                    throw cex;
                }
                case 122: 
                case 123: 
                case 127: 
                case 131: 
                case 132: {
                    String message = "Internal error in RPE JCO Connection in flush(): " + ex.getKey();
                    _location.fatalT(message + " due to " + ex.getMessage());
                    RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
                    _location.throwing("flush", (Throwable)cex);
                    throw cex;
                }
                case 110: {
                    _location.throwing("flush", (Throwable)ex);
                    String message = "Server Buzy, retry.";
                    _location.warningT(message);
                    RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
                    _location.throwing("flush", (Throwable)cex);
                    throw cex;
                }
                case 104: {
                    String message = "Remote system failed : " + ex.getKey();
                    _location.fatalT(message + " due to " + ex.getMessage());
                    RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
                    _location.throwing("flush", (Throwable)cex);
                    throw cex;
                }
            }
            String message = "Unrecognized exception in JCO Connection in flush(): " + ex.getKey();
            _location.warningT(message + " due to " + ex.getMessage());
            RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
            _location.throwing("flush", (Throwable)cex);
            throw cex;
        }
        ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_BEFORE_DESERIALIZE", (Object)this);
        try {
            try {
                this.processOutput();
            }
            catch (Exception ex) {
                _location.catching("flush", (Throwable)ex);
                String message = "Unhandled Exception while processing output.";
                RpeCommunicationException cex = new RpeCommunicationException(message, ex);
                _location.throwing("flush", (Throwable)cex);
                throw cex;
            }
            Object var9_28 = null;
        }
        catch (Throwable throwable) {
            Object var9_29 = null;
            ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_DESERIALIZE", (Object)this);
            throw throwable;
        }
        ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_AFTER_DESERIALIZE", (Object)this);
        this.resetCall();
        this.m_errorManager = null;
    }

    public String getProperty(String name) {
        String value = PROPERTY_DEBUG.equals(name) ? String.valueOf("1".equals(this.m_conProps.getProperty(JCO_ABAP_DEBUG))) : (this.isConnected() ? this.m_connection.getProperty(name) : this.m_conProps.getProperty(name));
        return value;
    }

    public void setProperty(String name, String value) {
        if (PROPERTY_DEBUG.equals(name)) {
            if (this.isConnected()) {
                RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "Connected", "setProperty", "Debug should be set before connecting.");
                _location.throwing("setProperty", (Throwable)re);
                throw re;
            }
            this.m_conProps.setProperty(JCO_ABAP_DEBUG, Boolean.valueOf(value) != false ? "1" : "0");
        } else if (this.isConnected()) {
            this.m_connection.setProperty(name, value);
        } else {
            this.m_conProps.setProperty(name, value);
        }
    }

    protected boolean isConnected() {
        return this.m_connection != null;
    }

    protected boolean isInCall() {
        return this.m_connection != null && this.m_errorManager != null;
    }

    public Properties getConnectionInfo() {
        return this.m_connectionInfo;
    }

    public String toString() {
        return this.m_connectionInfo.toString();
    }

    protected abstract void fillInput() throws Exception;

    protected abstract void processOutput() throws Exception;

    protected abstract JCO.Function createFunction(JCO.Client var1);

    protected void releaseFunction() {
        this.m_function = null;
        this.m_valueManager = null;
    }

    protected void resetCall() {
        this.m_valueManager.clear();
    }

    private static String formatStatsMessage(JCO.Throughput stats) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("No. of calls:").append(stats.getNumCalls()).append(",").append("Data (bytes) {").append("Send:").append(stats.getNumSentBytes()).append(",").append("Received:").append(stats.getNumReceivedBytes()).append("}, Time (ms) {").append("Total:").append(stats.getTotalTime()).append(",").append("Marshalling:").append(stats.getMarshallTime()).append(",").append("UnMarshalling:").append(stats.getUnmarshallTime()).append(",").append("Middleware:").append(stats.getMiddlewareTime()).append(",").append("Handle request:").append(stats.getHandleRequestTime()).append("}.");
        return buffer.toString();
    }

    public final JCO.Function getJcoFunction() {
        return this.m_function;
    }

    public abstract int addLine(String var1, String var2, String var3, int var4, int var5, int var6, int var7);

    public abstract int addParam(String var1, String var2, RpeParameterKind var3, RpeParameterMeta var4, IEdoValue var5);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.jco").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/jco/RpeJCoConnectionBase.java#1 $");
        PROPERTY_DEBUG = "debug";
        REPOSITORY = "RpeRepository";
        JCO_ABAP_DEBUG = "jco.client.abap_debug";
        defaultProperties = new Properties();
        defaultProperties.setProperty(JCO_ABAP_DEBUG, "0");
    }

    public static class ConnectionInfo
    extends Properties {
        private String strInfo = "JCO Connection {Not Connected}";

        public void setAttributes(JCO.Attributes attributes) {
            String system = attributes.getSystemID();
            ((Hashtable)this).put("SYSTEM_ID", system);
            String server = attributes.getPartnerHost();
            ((Hashtable)this).put("SERVER", server);
            String sysNbr = attributes.getSystemNumber();
            ((Hashtable)this).put("SYSTEM_NUMBER", sysNbr);
            String user = attributes.getUser();
            ((Hashtable)this).put("USER", user);
            String client = attributes.getClient();
            ((Hashtable)this).put("CLIENT", client);
            String serverRelease = attributes.getPartnerRelease();
            ((Hashtable)this).put("SERVER_VERSION", serverRelease);
            String kernelRelease = attributes.getKernelRelease();
            ((Hashtable)this).put("KERNEL_VERSION", kernelRelease);
            String isoLanguage = attributes.getISOLanguage();
            ((Hashtable)this).put("ISO_LANGUAGE", isoLanguage);
            String sapLanguage = attributes.getLanguage();
            ((Hashtable)this).put("SAP_LANGUAGE", sapLanguage);
            this.strInfo = client + '_' + user + '@' + system + '_' + server + '_' + sysNbr + " SAP-Release: " + serverRelease + " Kernel Release: " + kernelRelease;
        }

        public String toString() {
            return this.strInfo;
        }
    }
}

