/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.esp;

import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class RpeTransportOutputStream
extends OutputStream {
    private static final String _className = (class$com$sap$tc$col$rpe$esp$RpeTransportOutputStream == null ? (class$com$sap$tc$col$rpe$esp$RpeTransportOutputStream = RpeTransportOutputStream.class$("com.sap.tc.col.rpe.esp.RpeTransportOutputStream")) : class$com$sap$tc$col$rpe$esp$RpeTransportOutputStream).getName();
    static final Location _location = Location.getLocation((String)_className);
    static final int max_length = 2048;
    JCO.Table m_table;
    byte[] m_buffer;
    int m_offset;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$esp$RpeTransportOutputStream;

    public RpeTransportOutputStream(JCO.Table table) {
        table.clear();
        this.m_table = table;
        this.m_buffer = new byte[2048];
        this.m_offset = 0;
    }

    public void write(int b) throws IOException {
        this.m_buffer[this.m_offset] = (byte)b;
        ++this.m_offset;
        if (this.m_offset == 2048) {
            this.addLine();
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        int overFlow = this.m_offset + len - 2048;
        if (overFlow < 0) {
            System.arraycopy(buf, off, this.m_buffer, this.m_offset, len);
            this.m_offset += len;
        } else if (overFlow == 0) {
            System.arraycopy(buf, off, this.m_buffer, this.m_offset, len);
            this.addLine();
        } else {
            int writeLen = 2048 - this.m_offset;
            System.arraycopy(buf, off, this.m_buffer, this.m_offset, writeLen);
            off += writeLen;
            this.addLine();
            writeLen = 2048;
            while (2048 < overFlow) {
                System.arraycopy(buf, off, this.m_buffer, this.m_offset, writeLen);
                off += writeLen;
                this.addLine();
                overFlow -= 2048;
            }
            if (overFlow > 0) {
                writeLen = overFlow;
                System.arraycopy(buf, off, this.m_buffer, this.m_offset, writeLen);
                this.m_offset += writeLen;
            }
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.m_offset > 0) {
            if (this.m_offset < 2048) {
                Arrays.fill(this.m_buffer, this.m_offset, 2048, (byte)32);
            }
            this.addLine();
        }
        this.m_buffer = null;
    }

    void addLine() {
        this.m_table.appendRow();
        this.m_table.setValue(this.m_buffer, 0);
        this.m_offset = 0;
    }

    public void dump(String file) {
        this.m_table.writeHTML(file);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.jco").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/esp/RpeTransportOutputStream.java#1 $" + _className);
    }
}

