/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.esp;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.edo.core.EdoXmlReader;
import com.sap.tc.col.edo.core.XMLHelper;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.esp.RpeRequestSaxSource;
import com.sap.tc.col.rpe.esp.RpeResponseEventHandler;
import com.sap.tc.col.rpe.spi.IRpeValueManager;
import com.sap.tc.col.rpe.spi.RpeContextSpi;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RpeEspProtocol
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$esp$RpeEspConnection == null ? (class$com$sap$tc$col$rpe$esp$RpeEspConnection = RpeEspProtocol.class$("com.sap.tc.col.rpe.esp.RpeEspConnection")) : class$com$sap$tc$col$rpe$esp$RpeEspConnection).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private static IStructureDescriptor input_lines;
    private static int LINES_OBJECT;
    private static int LINES_OPCODE;
    private static int LINES_METHOD;
    private static int LINES_BEG_IMP;
    private static int LINES_CNT_IMP;
    private static int LINES_BEG_OUT;
    private static int LINES_CNT_OUT;
    private static IStructureDescriptor input_params;
    private static int PARAMS_NAME;
    private static int PARAMS_TYPE;
    private static int PARAMS_VALUE;
    private static int PARAMS_META;
    private static int PARAMS_KIND;
    private static IStructureDescriptor output_errors;
    private static int ERRORS_CATEGORY;
    private static int ERRORS_LINE;
    private static int ERRORS_CLASS;
    private static int ERRORS_PARAM;
    private static int ERRORS_VALUE;
    private static int ERRORS_CODE;
    private static int ERRORS_STATE;
    private static int ERRORS_DESC;
    private static int ERRORS_LOCATION;
    protected EdoTable m_tlines;
    protected EdoTable m_tparams;
    protected EdoTable m_terrors;
    protected int m_linesCount;
    protected int m_paramsCount;
    private IRpeValueManager m_valueManager;
    private RpeResponseEventHandler m_responseProcessor;
    private RpeRequestSaxSource m_requestGenerator;
    private SAXSource m_saxSource;
    public final XMLHelper m_xmlhelper = new XMLHelper();
    static /* synthetic */ Class class$com$sap$tc$col$rpe$esp$RpeEspConnection;

    public RpeEspProtocol(IRpeValueManager valueManager) {
        this.m_valueManager = valueManager;
        this.m_tlines = new EdoTable(input_lines);
        this.m_tparams = new EdoTable(input_params);
        this.m_terrors = new EdoTable(output_errors);
        this.m_requestGenerator = new RpeRequestSaxSource((IEdoTable)this.m_tlines, (IEdoTable)this.m_tparams, valueManager);
        this.m_responseProcessor = new RpeResponseEventHandler(valueManager, (IEdoTable)this.m_terrors);
        this.m_saxSource = new SAXSource((XMLReader)new EdoXmlReader(), (InputSource)((Object)this.m_requestGenerator));
    }

    public void clear() {
        this.m_tlines.clear();
        this.m_linesCount = 0;
        this.m_tparams.clear();
        this.m_paramsCount = 0;
    }

    public int addParam(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        int iValue = this.m_valueManager.add(value, kind);
        int row = this.m_tparams.append(1);
        ++this.m_paramsCount;
        this.m_tparams.setStringValue(row, PARAMS_NAME, name);
        this.m_tparams.setStringValue(row, PARAMS_TYPE, type);
        this.m_tparams.setIntValue(row, PARAMS_VALUE, iValue);
        this.m_tparams.setStringValue(row, PARAMS_META, meta.toString());
        this.m_tparams.setStringValue(row, PARAMS_KIND, kind.toString());
        return this.m_paramsCount;
    }

    public int addLine(String objectKey, String opCode, String method, int beginImportParams, int countImportParams, int beginExportingParams, int countExportingParams) {
        ++this.m_linesCount;
        int row = this.m_tlines.append(1);
        this.m_tlines.setStringValue(row, LINES_OBJECT, objectKey);
        this.m_tlines.setStringValue(row, LINES_OPCODE, opCode);
        this.m_tlines.setStringValue(row, LINES_METHOD, method);
        this.m_tlines.setIntValue(row, LINES_BEG_IMP, beginImportParams);
        this.m_tlines.setIntValue(row, LINES_CNT_IMP, countImportParams);
        this.m_tlines.setIntValue(row, LINES_BEG_OUT, beginExportingParams);
        this.m_tlines.setIntValue(row, LINES_CNT_OUT, countExportingParams);
        return this.m_linesCount;
    }

    public SAXSource getRequest() {
        return this.m_saxSource;
    }

    public void fillRequest(OutputStream request) {
        Transformer xmr = null;
        try {
            try {
                xmr = this.m_xmlhelper.getTransformer();
                xmr.setOutputProperty("omit-xml-declaration", "no");
                xmr.setOutputProperty("encoding", "UTF-8");
                xmr.transform(this.m_saxSource, new StreamResult(request));
            }
            catch (TransformerException ex) {
                _location.catching("fillRequest", (Throwable)ex);
                RpeException nex = new RpeException("while serializing", ex);
                _location.throwing("fillRequest", (Throwable)nex);
                throw nex;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.m_xmlhelper.releaseTransformer(xmr);
            throw throwable;
        }
        this.m_xmlhelper.releaseTransformer(xmr);
    }

    public void processResponse(SAXSource response) {
        Transformer xmr = null;
        try {
            try {
                XMLReader reader = response.getXMLReader();
                try {
                    reader.setFeature(EdoXmlReader.SAXFeature_ValueAsElement, true);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                this.m_responseProcessor.initialize();
                reader.setContentHandler((ContentHandler)((Object)this.m_responseProcessor));
                reader.parse(response.getInputSource());
            }
            catch (SAXException ex) {
                _location.catching("processResponse", (Throwable)ex);
                RpeException nex = new RpeException("while parsing", ex);
                _location.throwing("processResponse", (Throwable)nex);
                throw nex;
            }
            catch (IOException ex) {
                _location.catching("processResponse", (Throwable)ex);
                RpeException nex = new RpeException("while parsing", ex);
                _location.throwing("processResponse", (Throwable)nex);
                throw nex;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_xmlhelper.releaseTransformer(xmr);
            throw throwable;
        }
        this.m_xmlhelper.releaseTransformer(xmr);
    }

    public void processResponse(InputStream response) throws IOException {
        SAXParser parser = null;
        try {
            try {
                parser = this.m_xmlhelper.getParser();
                InputSource is = new InputSource(response);
                this.m_responseProcessor.initialize();
                parser.parse(is, (DefaultHandler)((Object)this.m_responseProcessor));
            }
            catch (SAXException ex) {
                _location.catching("parseResponse", (Throwable)ex);
                RpeException nex = new RpeException("while parsing", ex);
                _location.throwing("parseResponse", (Throwable)nex);
                throw nex;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_xmlhelper.releaseParser(parser);
            throw throwable;
        }
        this.m_xmlhelper.releaseParser(parser);
    }

    public void processErrors(RpeContextSpi errorManager, IRpeConnection conn) {
        if (this.m_terrors.getRecordCount() > 0) {
            int row = 0;
            int len = this.m_terrors.getRecordCount();
            while (row < len) {
                String object;
                String opCode;
                String method;
                int iLine = this.to_int(this.m_terrors.getStringValue(row, ERRORS_LINE));
                int iParam = this.to_int(this.m_terrors.getStringValue(row, ERRORS_PARAM));
                int iValue = this.to_int(this.m_terrors.getStringValue(row, ERRORS_VALUE));
                String category = this.m_terrors.getStringValue(row, ERRORS_CATEGORY);
                String errClass = this.m_terrors.getStringValue(row, ERRORS_CLASS);
                String errCode = this.m_terrors.getStringValue(row, ERRORS_CODE);
                String errState = this.m_terrors.getStringValue(row, ERRORS_STATE);
                String errDesc = this.m_terrors.getStringValue(row, ERRORS_DESC);
                String errLocation = this.m_terrors.getStringValue(row, ERRORS_LOCATION);
                if (iLine > 0 && iLine <= this.m_linesCount) {
                    method = this.m_tlines.getStringValue(iLine - 1, LINES_METHOD);
                    opCode = this.m_tlines.getStringValue(iLine - 1, LINES_OPCODE);
                    object = this.m_tlines.getStringValue(iLine - 1, LINES_OBJECT);
                } else {
                    method = null;
                    opCode = null;
                    object = null;
                }
                String param = iParam > 0 && iParam <= this.m_paramsCount ? this.m_tparams.getStringValue(iParam - 1, PARAMS_NAME) : (iParam == Integer.MIN_VALUE ? this.m_terrors.getStringValue(row, ERRORS_PARAM) : null);
                String value = iValue > 0 ? this.m_valueManager.getValue(iValue).toString() : (iValue == Integer.MIN_VALUE ? this.m_terrors.getStringValue(row, ERRORS_VALUE) : null);
                errorManager.addError(method, opCode, object, errClass, param, value, category, errCode, errDesc, errState, errLocation, conn);
                ++row;
            }
        }
    }

    private int to_int(String value) {
        int ivalue;
        if (null == value) {
            ivalue = 0;
        } else if ((value = value.trim()).length() == 0) {
            ivalue = 0;
        } else {
            try {
                ivalue = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                _location.catching("to_int of '" + value + "'", (Throwable)ex);
                ivalue = Integer.MIN_VALUE;
            }
        }
        return ivalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.esp").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/esp/RpeEspProtocol.java#1 $");
        input_lines = new StructureDescriptor(null, "LINES", new FieldDescriptor[]{new FieldDescriptor("OBJECT", "STRING"), new FieldDescriptor("OPCODE", "STRING"), new FieldDescriptor("METHOD", "STRING"), new FieldDescriptor("BEG_IMP_PARMS", "INTEGER"), new FieldDescriptor("CNT_IMP_PARMS", "INTEGER"), new FieldDescriptor("BEG_OUT_PARMS", "INTEGER"), new FieldDescriptor("CNT_OUT_PARMS", "INTEGER")});
        LINES_OBJECT = input_lines.getFieldIndex("OBJECT");
        LINES_OPCODE = input_lines.getFieldIndex("OPCODE");
        LINES_METHOD = input_lines.getFieldIndex("METHOD");
        LINES_BEG_IMP = input_lines.getFieldIndex("BEG_IMP_PARMS");
        LINES_CNT_IMP = input_lines.getFieldIndex("CNT_IMP_PARMS");
        LINES_BEG_OUT = input_lines.getFieldIndex("BEG_OUT_PARMS");
        LINES_CNT_OUT = input_lines.getFieldIndex("CNT_OUT_PARMS");
        input_params = new StructureDescriptor(null, "PARAMS", new FieldDescriptor[]{new FieldDescriptor("NAME", "STRING"), new FieldDescriptor("TYPE", "STRING"), new FieldDescriptor("VALUE", "INTEGER"), new FieldDescriptor("META", "STRING"), new FieldDescriptor("KIND", "STRING")});
        PARAMS_NAME = input_params.getFieldIndex("NAME");
        PARAMS_TYPE = input_params.getFieldIndex("TYPE");
        PARAMS_VALUE = input_params.getFieldIndex("VALUE");
        PARAMS_META = input_params.getFieldIndex("META");
        PARAMS_KIND = input_params.getFieldIndex("KIND");
        output_errors = new StructureDescriptor(null, "ERRORS", new FieldDescriptor[]{new FieldDescriptor("CATEGORY", "STRING"), new FieldDescriptor("LINE", "STRING"), new FieldDescriptor("CLASS", "STRING"), new FieldDescriptor("PARAM", "STRING"), new FieldDescriptor("VALUE", "STRING"), new FieldDescriptor("CODE", "STRING"), new FieldDescriptor("STATE", "STRING"), new FieldDescriptor("DESCRIPTION", "STRING"), new FieldDescriptor("LOCATION", "STRING")});
        ERRORS_CATEGORY = output_errors.getFieldIndex("CATEGORY");
        ERRORS_LINE = output_errors.getFieldIndex("LINE");
        ERRORS_CLASS = output_errors.getFieldIndex("CLASS");
        ERRORS_PARAM = output_errors.getFieldIndex("PARAM");
        ERRORS_VALUE = output_errors.getFieldIndex("VALUE");
        ERRORS_CODE = output_errors.getFieldIndex("CODE");
        ERRORS_STATE = output_errors.getFieldIndex("STATE");
        ERRORS_DESC = output_errors.getFieldIndex("DESCRIPTION");
        ERRORS_LOCATION = output_errors.getFieldIndex("LOCATION");
    }
}

