/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.esp;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeCommunicationException;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.esp.RpeEspProtocol;
import com.sap.tc.col.rpe.esp.RpeTransportInputStream;
import com.sap.tc.col.rpe.esp.RpeTransportOutputStream;
import com.sap.tc.col.rpe.jco.RpeJCoConnectionBase;
import com.sap.tc.col.rpe.spi.IRpeConnectionFactory;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.IOException;

public class RpeEspConnection
extends RpeJCoConnectionBase
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$esp$RpeEspConnection == null ? (class$com$sap$tc$col$rpe$esp$RpeEspConnection = RpeEspConnection.class$("com.sap.tc.col.rpe.esp.RpeEspConnection")) : class$com$sap$tc$col$rpe$esp$RpeEspConnection).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private static int TABLES_REQUEST;
    private static int TABLES_RESPONSE;
    private static int IMPORT_LAST_TRIPTIME;
    protected JCO.Table m_trequest;
    protected JCO.Table m_tresponse;
    protected RpeEspProtocol m_protocol;
    private String trace_loc;
    static IFunctionTemplate engineFunctionTemplate;
    private static char[] blanks;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$esp$RpeEspConnection;

    protected JCO.Function createFunction(JCO.Client connection) {
        JCO.Function function = RpeEspConnection.getEngineFunctionTemplate(connection).getFunction();
        JCO.ParameterList tables = function.getTableParameterList();
        this.m_trequest = tables.getTable(TABLES_REQUEST);
        this.m_tresponse = tables.getTable(TABLES_RESPONSE);
        this.m_protocol = new RpeEspProtocol(this.m_valueManager);
        this.trace_loc = this.getProperty("esp.trace.location");
        return function;
    }

    protected void releaseFunction() {
        super.releaseFunction();
        this.m_trequest = null;
        this.m_tresponse = null;
        this.m_protocol = null;
    }

    protected void resetCall() {
        super.resetCall();
        try {
            this.m_protocol.clear();
            this.m_trequest.clear();
            this.m_tresponse.clear();
        }
        catch (JCO.Exception ex) {
            _location.catching("resetCall", (Throwable)ex);
            String message = "Unrecognized exception in ESP Connection in resetCall() : " + ex.getKey();
            _location.fatalT(message);
            RpeCommunicationException rex = new RpeCommunicationException(message, (Exception)((Object)ex));
            _location.throwing("resetCall", (Throwable)rex);
            throw rex;
        }
    }

    public int addParam(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        return this.m_protocol.addParam(name, type, kind, meta, value);
    }

    public int addLine(String objectKey, String opCode, String method, int beginImportParams, int countImportParams, int beginExportingParams, int countExportingParams) {
        return this.m_protocol.addLine(objectKey, opCode, method, beginImportParams, countImportParams, beginExportingParams, countExportingParams);
    }

    protected void fillInput() throws Exception {
        this.m_function.getImportParameterList().setValue(this.m_timeForLastCall, IMPORT_LAST_TRIPTIME);
        RpeTransportOutputStream outStream = new RpeTransportOutputStream(this.m_trequest);
        this.m_protocol.fillRequest(outStream);
        outStream.close();
        if (this.trace_loc != null) {
            try {
                String trace_file = this.trace_loc + System.currentTimeMillis() + "_request" + ".xml";
                RpeEspConnection.dumpTransportContents(this.m_trequest, trace_file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processOutput() throws Exception {
        if (this.trace_loc != null) {
            try {
                String trace_file = this.trace_loc + System.currentTimeMillis() + "_response" + ".xml";
                RpeEspConnection.dumpTransportContents(this.m_tresponse, trace_file);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        RpeTransportInputStream inStream = new RpeTransportInputStream(this.m_tresponse);
        this.m_protocol.processResponse(inStream);
        inStream.close();
        this.m_protocol.processErrors(this.m_errorManager, this);
    }

    static IFunctionTemplate getEngineFunctionTemplate(JCO.Client client) {
        if (engineFunctionTemplate == null) {
            Class clazz = class$com$sap$tc$col$rpe$esp$RpeEspConnection == null ? (class$com$sap$tc$col$rpe$esp$RpeEspConnection = RpeEspConnection.class$("com.sap.tc.col.rpe.esp.RpeEspConnection")) : class$com$sap$tc$col$rpe$esp$RpeEspConnection;
            synchronized (clazz) {
                if (engineFunctionTemplate == null) {
                    _location.pathT("Creating Engine function template.");
                    JCO.MetaData input = new JCO.MetaData("INPUT", 1);
                    input.addInfo("LAST_TRIPTIME", 8, 2);
                    IMPORT_LAST_TRIPTIME = input.indexOf("LAST_TRIPTIME");
                    IMetaData output = null;
                    JCO.MetaData rpe_transport = new JCO.MetaData("RPE_XTRANSPORT", 1);
                    rpe_transport.addInfo("CHUNK", 4, 2048, 0, 0);
                    JCO.MetaData tables = new JCO.MetaData("TABLES", 1);
                    tables.addInfo("REQUEST", 99, 0, 0, 0, 0, (Object)rpe_transport);
                    tables.addInfo("RESPONSE", 99, 0, 0, 0, 0, (Object)rpe_transport);
                    TABLES_REQUEST = tables.indexOf("REQUEST");
                    TABLES_RESPONSE = tables.indexOf("RESPONSE");
                    JCO.AbapException[] exceptions = new JCO.AbapException[]{};
                    engineFunctionTemplate = new JCO.FunctionTemplate("RPE_REQUEST", (IMetaData)input, output, (IMetaData)tables, exceptions);
                    _location.pathT("Created Engine function template.");
                    if (_location.getEffectiveSeverity() <= 100) {
                        _location.debugT(engineFunctionTemplate.toString());
                    }
                }
            }
        }
        return engineFunctionTemplate;
    }

    public static void dumpTransportContents(JCO.Table table, String file) throws IOException {
        int currentRow = table.getRow();
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            if (!table.isEmpty()) {
                table.firstRow();
                do {
                    byte[] srow = table.getByteArray(0);
                    fos.write(srow);
                } while (table.nextRow());
            }
            fos.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            table.setRow(currentRow);
            throw throwable;
        }
        table.setRow(currentRow);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.esp").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/esp/RpeEspConnection.java#1 $");
        blanks = null;
    }

    public static class ConnectionFactory
    implements IRpeConnectionFactory {
        public IRpeConnectionSpi createConnection(String channel) {
            return new RpeEspConnection();
        }
    }
}

