/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.esp;

import com.sap.tc.col.cxa.ContextAccessor;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.core.RpeValueManager;
import com.sap.tc.col.rpe.esp.RpeEspProtocol;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.col.rpe.spi.IRpeValueManager;
import com.sap.tc.col.rpe.spi.RpeContextSpi;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class ConnectionBase
implements IRpeConnectionSpi {
    private static final String _className = (class$com$sap$tc$col$rpe$esp$RpeEspConnection == null ? (class$com$sap$tc$col$rpe$esp$RpeEspConnection = ConnectionBase.class$("com.sap.tc.col.rpe.esp.RpeEspConnection")) : class$com$sap$tc$col$rpe$esp$RpeEspConnection).getName();
    private static final Location _location = Location.getLocation((String)_className);
    protected Properties m_conProps = new Properties();
    protected Properties m_servProps = new Properties();
    protected RpeContextSpi m_errorManager;
    protected IRpeValueManager m_valueManager;
    protected RpeEspProtocol m_protocol;
    protected String trace_loc;
    protected String strInfo = "Not connected.";
    static /* synthetic */ Class class$com$sap$tc$col$rpe$esp$RpeEspConnection;

    public void connect() {
        this.trace_loc = this.m_conProps.getProperty("esp.trace.location");
        this.m_valueManager = new RpeValueManager();
        this.m_protocol = new RpeEspProtocol(this.m_valueManager);
        this.m_servProps = this.connect(this.m_conProps);
        String user = this.m_servProps.getProperty("USER");
        String client = this.m_servProps.getProperty("CLIENT");
        String system = this.m_servProps.getProperty("SYSTEM_ID");
        String server = this.m_servProps.getProperty("SERVER");
        String cluster = this.m_servProps.getProperty("CLUSTER_NAME");
        String nodeId = this.m_servProps.getProperty("CLUSTER_ID");
        String kernelRelease = this.m_servProps.getProperty("KERNEL_VERSION");
        this.strInfo = (client != null ? client + '_' : "") + user + '@' + system + " (Server: " + server + " Cluster: " + cluster + " Node: " + nodeId + ") Kernel Release: " + kernelRelease;
        ContextAccessor.raiseEvent((String)"ON_RPE_CONNECTION_CONNECT", (Object)this);
    }

    protected abstract Properties connect(Properties var1);

    public void release() {
        this.m_valueManager = null;
        this.m_protocol = null;
    }

    public void initializeCall(RpeContextSpi errorManager) {
        this.m_errorManager = errorManager;
        this.m_protocol.clear();
        this.m_valueManager.clear();
    }

    public void discardCall() {
        this.m_errorManager = null;
        this.m_valueManager.clear();
        this.m_protocol.clear();
    }

    public int addParam(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        return this.m_protocol.addParam(name, type, kind, meta, value);
    }

    public int addLine(String objectKey, String opCode, String method, int beginImportParams, int countImportParams, int beginExportingParams, int countExportingParams) {
        return this.m_protocol.addLine(objectKey, opCode, method, beginImportParams, countImportParams, beginExportingParams, countExportingParams);
    }

    public void connect(String locator, String client, String user, String password, String language) {
        if (locator != null) {
            this.parseProperties(locator);
        }
        if (client != null) {
            ((Hashtable)this.m_conProps).put("client", client);
        }
        if (user != null) {
            ((Hashtable)this.m_conProps).put("user", user);
        }
        if (password != null) {
            ((Hashtable)this.m_conProps).put("passwd", password);
        }
        if (language != null) {
            ((Hashtable)this.m_conProps).put("lang", language);
        }
        this.connect();
    }

    public void connect(String locator, String client, String sso, String language) {
        if (locator != null) {
            this.parseProperties(locator);
        }
        if (client != null) {
            ((Hashtable)this.m_conProps).put("client", client);
        }
        if (sso != null) {
            ((Hashtable)this.m_conProps).put("sapsso2", sso);
        }
        if (language != null) {
            ((Hashtable)this.m_conProps).put("lang", language);
        }
        this.connect();
    }

    public Properties getConnectionInfo() {
        return this.m_servProps;
    }

    public String getProperty(String name) {
        return this.m_conProps.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.m_conProps.setProperty(name, value);
    }

    private void parseProperties(String properties) {
        StringTokenizer tokenizer = new StringTokenizer(properties, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken("=");
            tokenizer.nextToken("=");
            String value = tokenizer.nextToken("\"'/");
            if ("'".equals(value)) {
                value = tokenizer.nextToken("'");
                tokenizer.nextToken("'");
            } else if ("\"".equals(value)) {
                value = tokenizer.nextToken("\"");
                tokenizer.nextToken("\"");
            }
            this.m_conProps.setProperty(key, value);
            if (!tokenizer.hasMoreTokens()) continue;
            tokenizer.nextToken("/");
        }
    }

    public String toString() {
        return this.strInfo;
    }

    public abstract void flush();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.esp").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/esp/ConnectionBase.java#2 $");
    }
}

