/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.cxa.ContextAccessor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.core.EdoAtomicValue;
import com.sap.tc.col.edo.core.EdoIndexTable;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.IRpeContextFactory;
import com.sap.tc.col.rpe.RpeContext;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeMethodOpCode;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.core.ClassNameConnectionFactory;
import com.sap.tc.col.rpe.core.RpeMethodBase;
import com.sap.tc.col.rpe.core.RpeObjectBase;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.esp.RpeEspConnection;
import com.sap.tc.col.rpe.jco.RpeJCoConnection;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.col.rpe.spi.RpeContextSpi;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;

public class RpeContextImpl
extends RpeContextSpi
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$core$RpeContextImpl == null ? (class$com$sap$tc$col$rpe$core$RpeContextImpl = RpeContextImpl.class$("com.sap.tc.col.rpe.core.RpeContextImpl")) : class$com$sap$tc$col$rpe$core$RpeContextImpl).getName();
    static final Location _location = Location.getLocation((String)_className);
    protected ObjectManager m_objectManager;
    protected SimpleInstructionQueue m_instructionQueue;
    protected IRpeConnectionSpi m_defaultConnection;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$core$RpeContextImpl;

    public RpeContextImpl() {
        this.m_objectManager = new ObjectManager();
        this.m_instructionQueue = new SimpleInstructionQueue(this);
        this.m_defaultConnection = null;
        ContextAccessor.raiseEvent((String)RpeContext.eventOnCreate, (Object)this);
    }

    protected RpeContextImpl(RpeContextImpl original) {
        super(original);
        this.m_objectManager = original.m_objectManager;
        this.m_instructionQueue = new SimpleInstructionQueue(this);
        this.m_defaultConnection = original.m_defaultConnection;
        ContextAccessor.raiseEvent((String)RpeContext.eventOnCreate, (Object)this);
    }

    public IEdoStructure createStructure(IStructureDescriptor type) {
        if (type == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createStructure", "type", type, "should not be null");
            _location.throwing("createStructure", (Throwable)ex);
            throw ex;
        }
        EdoStructure struct = new EdoStructure(type);
        return struct;
    }

    public IEdoTable createTable(IStructureDescriptor type) {
        if (type == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createTable", "type", type, "should not be null");
            _location.throwing("createTable", (Throwable)ex);
            throw ex;
        }
        EdoTable table = new EdoTable(type);
        return table;
    }

    public IEdoAtomicValue createValue(String value) {
        EdoAtomicValue simpleValue = new EdoAtomicValue("STRING");
        simpleValue.setStringValue(value);
        return simpleValue;
    }

    public IEdoIndexTable createIndexTable(IStructureDescriptor type, int inRecordFieldIndex, int outRecordFieldIndex) {
        EdoIndexTable indexTable = new EdoIndexTable(type, inRecordFieldIndex, outRecordFieldIndex);
        return indexTable;
    }

    public IEdoIndexTable createIndexTable(IStructureDescriptor type, String inRecordFieldName, String outRecordFieldName) {
        EdoIndexTable indexTable = new EdoIndexTable(type, inRecordFieldName, outRecordFieldName);
        return indexTable;
    }

    public RpeParameter createParameter(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        if (name == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createParameter", "name", name, "should not be null");
            _location.throwing("createParameter", (Throwable)ex);
            throw ex;
        }
        if (type == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createParameter", "type", type, "should not be null");
            _location.throwing("createParameter", (Throwable)ex);
            throw ex;
        }
        if (kind == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createParameter", "kind", kind, "should not be null");
            _location.throwing("createParameter", (Throwable)ex);
            throw ex;
        }
        if (meta == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createParameter", "meta", meta, "should not be null");
            _location.throwing("createParameter", (Throwable)ex);
            throw ex;
        }
        if (value == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createParameter", "value", value, "should not be null");
            _location.throwing("createParameter", (Throwable)ex);
            throw ex;
        }
        RpeParameter parameter = new RpeParameter(name, type, kind, meta, value);
        return parameter;
    }

    public RpeMethod createMethod(String name, RpeMethodOpCode opCode) {
        if (name == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createMethod", "name", name, "should not be null");
            _location.throwing("createMethod", (Throwable)ex);
            throw ex;
        }
        RpeMethod method = new RpeMethod(name, opCode);
        return method;
    }

    protected RpeObject createObject(String className, IRpeConnectionSpi connection, String name) {
        if (connection == null) {
            connection = this.m_defaultConnection;
        }
        if (!this.m_objectManager.hasConnection(connection)) {
            IllegalArgumentException ex = new IllegalArgumentException("The connection is not associated with this context or has been closed.");
            _location.throwing("createObject", (Throwable)ex);
            throw ex;
        }
        if (name == null || name.length() == 0) {
            name = this.m_objectManager.newObjectName();
        } else if (this.m_objectManager.hasObjectByName(name)) {
            IllegalArgumentException ex = new IllegalArgumentException("The name is already in use.");
            _location.throwing("createObject", (Throwable)ex);
            throw ex;
        }
        RpeObject objRef = new RpeObject(this, connection, name);
        this.m_objectManager.registerObject(objRef);
        if (null != className && className.length() > 0) {
            RpeMethod method = this.createMethod("", RpeMethodOpCode.Create);
            method.addImportingParameter("CLASSNAME", "STRING", RpeParameterMeta.Atomic, (IEdoValue)this.createValue(className));
            method.addImportingParameter("OBJECTKEY", "STRING", RpeParameterMeta.Atomic, (IEdoValue)this.createValue(name));
            this.queueMethod(objRef, method);
        }
        return objRef;
    }

    protected void releaseObjectInternal(RpeObject objRef) {
        if (objRef == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "releaseObjectInternal", "objRef", objRef, "should not be null");
            _location.throwing("releaseObjectInternal", (Throwable)ex);
            throw ex;
        }
        this.checkRootContext(objRef, "releaseObjectInternal");
        if (this.m_objectManager.hasConnection(((RpeObjectBase)objRef).getConnection())) {
            RpeMethod method = this.createMethod("", RpeMethodOpCode.Release);
            this.queueMethod(objRef, method);
            this.m_objectManager.unregisterObject(objRef);
        }
    }

    private void checkRootContext(RpeObject objRef, String _methodName) {
        RpeContextImpl ctxt;
        try {
            ctxt = ((RpeContextImpl)((RpeObjectBase)objRef).getContext()).getRootContext();
        }
        catch (ClassCastException ex) {
            ctxt = null;
        }
        if (ctxt != this.getRootContext()) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, _methodName, "objRef", objRef, "object does not belong to this context");
            _location.throwing(_methodName, (Throwable)ex);
            throw ex;
        }
    }

    public void callMethod(RpeObject objRef, RpeMethod method, boolean flush) {
        this.queueMethod(objRef, (RpeMethod)method.clone());
        if (flush || this.m_isSynchronous) {
            this.flush();
        }
    }

    private void queueMethod(RpeObject objRef, RpeMethod operation) {
        if (objRef == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "queueMethod", "objRef", objRef, "should not be null");
            _location.throwing("queueMethod", (Throwable)ex);
            throw ex;
        }
        if (!this.m_objectManager.hasConnection(((RpeObjectBase)objRef).getConnection())) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "queueMethod", "objRef", objRef, "The connection is not associated with this context or is already closed.");
            _location.throwing("queueMethod", (Throwable)ex);
            throw ex;
        }
        this.checkRootContext(objRef, "queueMethod");
        if (operation == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "queueMethod", "operation", operation, "should not be null");
            _location.throwing("queueMethod", (Throwable)ex);
            throw ex;
        }
        if (!((RpeMethodBase)operation).verifyObjectParameters(((RpeObjectBase)objRef).getConnection())) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "queueMethod", "objRef", objRef, "a parameter does not belong to the connection.");
            _location.throwing("queueMethod", (Throwable)ex);
            throw ex;
        }
        this.m_instructionQueue.add(objRef, operation);
    }

    public void flush() {
        ContextAccessor.raiseEvent((String)RpeContext.eventOnBeforeFlush, (Object)this);
        this.m_instructionQueue.flush();
        ContextAccessor.raiseEvent((String)RpeContext.eventOnAfterFlush, (Object)this);
    }

    public void flush(IRpeConnectionSpi connection) {
        try {
            if (!this.m_objectManager.hasConnection(connection)) {
                throw new RpeIllegalArgumentException(_className, "flush", "connection", connection, "This connection does not belong to this context, or has been already closed.");
            }
            connection.flush();
        }
        catch (Exception ex) {
            _location.catching("flush", (Throwable)ex);
            connection.discardCall();
            this.addError(null, null, null, null, null, null, "RPE", "SYSTEM", ex.getMessage(), "FATAL", null, connection);
        }
    }

    public void release() {
        IRpeConnectionSpi[] connections = this.m_objectManager.allConnections();
        int i = 0;
        int len = connections.length;
        while (i < len) {
            this.releaseConnection(connections[i]);
            ++i;
        }
    }

    public IRpeConnection setDefaultConnection(IRpeConnection connection) {
        IRpeConnectionSpi old_default = this.m_defaultConnection;
        this.m_defaultConnection = (IRpeConnectionSpi)connection;
        return old_default;
    }

    protected void addConnection(IRpeConnectionSpi connection, boolean isDefault) {
        if (isDefault && this.m_defaultConnection != null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addConnection", "isDefault", "true", "default connection is already set");
            _location.throwing("addConnection", (Throwable)ex);
            throw ex;
        }
        if (connection == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addConnection", "connection", connection, "should not be null");
            _location.throwing("addConnection", (Throwable)ex);
            throw ex;
        }
        if (this.m_objectManager.hasConnection(connection)) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addConnection", "connection", connection, "Connection cannot be added more than once.");
            _location.throwing("addConnection", (Throwable)ex);
            throw ex;
        }
        this.m_objectManager.addConnection(connection);
        if (isDefault) {
            this.m_defaultConnection = connection;
            _location.debugT("Connection set as default.");
        }
    }

    protected void releaseConnection(IRpeConnectionSpi connection) {
        if (connection == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "releaseConnection", "connection", connection, "should not be null");
            _location.throwing("releaseConnection", (Throwable)ex);
            throw ex;
        }
        if (!this.m_objectManager.removeConnection(connection)) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "releaseConnection", "connection", connection, "Connection does not belong to this context.");
            _location.throwing("releaseConnection", (Throwable)ex);
            throw ex;
        }
        connection.release();
        if (connection == this.m_defaultConnection) {
            this.m_defaultConnection = null;
        }
    }

    public RpeContext createSharedContext() {
        SharedContext sharedContext = new SharedContext(this);
        return sharedContext;
    }

    protected RpeContextImpl getRootContext() {
        return this;
    }

    public int getInstructionQueueSize() {
        return this.m_instructionQueue.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/core/RpeContextImpl.java#1 $");
        RpeContextSpi.Connectors.put("JCO", new RpeJCoConnection.ConnectionFactory());
        _location.pathT("JCO added as a Connector.");
        RpeContextSpi.Connectors.put("ESP", new RpeEspConnection.ConnectionFactory());
        _location.pathT("ESP added as a Connector.");
        RpeContextSpi.Connectors.put("local", new ClassNameConnectionFactory("com.sap.tc.col.rpe.esp.LocalConnection"));
        _location.pathT("Local added as a Connector.");
        RpeContextSpi.Connectors.put("remote", new ClassNameConnectionFactory("com.sap.tc.col.rpe.esp.J2eeRemoteConnection"));
    }

    private static final class SharedContext
    extends RpeContextImpl {
        protected RpeContextImpl m_root;

        public SharedContext(RpeContextImpl root) {
            super(root);
            this.m_root = root;
        }

        public RpeContext createSharedContext() {
            return this.m_root.createSharedContext();
        }

        protected RpeContextImpl getRootContext() {
            return this.m_root;
        }
    }

    private static final class ObjectManager {
        protected static String namePrefix = "RPE_";
        protected final HashMap m_names = new HashMap();
        protected final HashMap m_connections = new HashMap();
        protected long m_nameCount = 0L;

        public String newObjectName() {
            String name;
            while (this.m_names.containsKey(name = namePrefix + ++this.m_nameCount)) {
            }
            return name;
        }

        public boolean hasObjectByName(String name) {
            return this.m_names.containsKey(name);
        }

        public RpeObject getObjectByName(String name) {
            return (RpeObject)this.m_names.get(name);
        }

        public void registerObject(RpeObject objRef) {
            String name = objRef.getName();
            this.m_names.put(name, objRef);
            IRpeConnectionSpi conxn = ((RpeObjectBase)objRef).getConnection();
            HashMap names = (HashMap)this.m_connections.get(conxn);
            names.put(name, name);
        }

        public void unregisterObject(RpeObject objRef) {
            String name = objRef.getName();
            this.m_names.remove(name);
            IRpeConnectionSpi conxn = ((RpeObjectBase)objRef).getConnection();
            HashMap names = (HashMap)this.m_connections.get(conxn);
            names.remove(name);
        }

        public void addConnection(IRpeConnectionSpi connection) {
            this.m_connections.put(connection, new HashMap());
        }

        public boolean hasConnection(IRpeConnectionSpi connection) {
            return this.m_connections.containsKey(connection);
        }

        public boolean removeConnection(IRpeConnectionSpi connection) {
            boolean found = false;
            HashMap namesMap = (HashMap)this.m_connections.get(connection);
            if (namesMap != null) {
                found = true;
                this.m_names.keySet().removeAll(namesMap.keySet());
                this.m_connections.remove(connection);
            }
            return found;
        }

        public IRpeConnectionSpi[] allConnections() {
            IRpeConnectionSpi[] connections = new IRpeConnectionSpi[this.m_connections.size()];
            this.m_connections.keySet().toArray(connections);
            return connections;
        }
    }

    private static final class SimpleInstructionQueue {
        protected ArrayList m_methodQueue = new ArrayList();
        protected ArrayList m_objectQueue = new ArrayList();
        protected RpeContextImpl m_context;

        public SimpleInstructionQueue(RpeContextImpl context) {
            this.m_context = context;
        }

        public final int size() {
            int queueSize = this.m_methodQueue.size();
            if (queueSize != this.m_objectQueue.size()) {
                RpeException ex = new RpeException("Internal error: the queues have different sizes.");
                _location.throwing("SimpleInstructionQueue::size", (Throwable)ex);
                throw ex;
            }
            return queueSize;
        }

        public void add(RpeObject objRef, RpeMethod operation) {
            this.m_objectQueue.add(objRef);
            this.m_methodQueue.add(operation);
        }

        public void flush() {
            IRpeConnectionSpi connection = null;
            int index = 0;
            int len = this.size();
            while (index < len) {
                RpeObject objRef = (RpeObject)this.m_objectQueue.get(index);
                RpeMethod method = (RpeMethod)this.m_methodQueue.get(index);
                if (connection != ((RpeObjectBase)objRef).getConnection()) {
                    if (connection != null) {
                        this.m_context.flush(connection);
                    }
                    connection = ((RpeObjectBase)objRef).getConnection();
                    connection.initializeCall(this.m_context);
                }
                ((RpeMethodBase)method).addToConnection(objRef, connection);
                ++index;
            }
            if (connection != null) {
                this.m_context.flush(connection);
            }
            this.reset();
        }

        public void reset() {
            this.m_methodQueue.clear();
            this.m_objectQueue.clear();
        }
    }

    public static final class SimpleContextFactory
    implements IRpeContextFactory {
        public RpeContext createContext() {
            return new RpeContextImpl();
        }
    }
}

