/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe;

import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.RpeMethodOpCode;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.core.RpeMethodBase;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Iterator;

public class RpeMethod
extends RpeMethodBase
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$RpeMethod == null ? (class$com$sap$tc$col$rpe$RpeMethod = RpeMethod.class$("com.sap.tc.col.rpe.RpeMethod")) : class$com$sap$tc$col$rpe$RpeMethod).getName();
    private static final Location _location = Location.getLocation((String)_className);
    protected String m_name;
    protected RpeMethodOpCode m_opCode;
    protected HashMap m_parameters;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$RpeMethod;

    public RpeMethod(String name, RpeMethodOpCode opCode) {
        String _methodName = "RpeMethod";
        if (name == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "RpeMethod", "name", name, "should not be null");
            _location.throwing("RpeMethod", (Throwable)ex);
            throw ex;
        }
        if (opCode == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "RpeMethod", "opCode", opCode, "should not be null");
            _location.throwing("RpeMethod", (Throwable)ex);
            throw ex;
        }
        this.m_name = name;
        this.m_opCode = opCode;
        this.m_parameters = new HashMap();
    }

    public String getName() {
        return this.m_name;
    }

    public RpeMethodOpCode getOpCode() {
        return this.m_opCode;
    }

    public void addParameter(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        String _methodName = "addParameter";
        if (name == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "name", name, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        if (type == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "type", type, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        if (kind == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "kind", kind, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        if (meta == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "meta", meta, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        if (value == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "value", value, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        this.addParameter(new RpeParameter(name, type, kind, meta, value));
    }

    public void addParameter(RpeParameter param) {
        String _methodName = "addParameter";
        if (param == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "param", param, "should not be null");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        String name = param.getName();
        if (this.m_parameters.get(name) != null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "addParameter", "param", param, "duplicate name");
            _location.throwing("addParameter", (Throwable)ex);
            throw ex;
        }
        this.m_parameters.put(name, param);
    }

    public void removeParameter(RpeParameter param) {
        String _methodName = "removeParameter";
        if (param == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "removeParameter", "param", param, "should not be null");
            _location.throwing("removeParameter", (Throwable)ex);
            throw ex;
        }
        String paramName = param.getName();
        Object removedParam = this.m_parameters.get(paramName);
        if (removedParam == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "removeParameter", "param", param, "parameter not found");
            _location.throwing("removeParameter", (Throwable)ex);
            throw ex;
        }
        this.m_parameters.remove(paramName);
    }

    public RpeParameter removeParameter(String paramName) {
        String _methodName = "removeParameter";
        if (paramName == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "removeParameter", "paramName", paramName, "should not be null");
            _location.throwing("removeParameter", (Throwable)ex);
            throw ex;
        }
        RpeParameter param = (RpeParameter)this.m_parameters.remove(paramName);
        if (param == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "removeParameter", "paramName", paramName, "prameter not found");
            _location.throwing("removeParameter", (Throwable)ex);
            throw ex;
        }
        return param;
    }

    public void addImportingParameter(String name, String type, RpeParameterMeta meta, IEdoValue value) {
        this.addParameter(name, type, RpeParameterKind.Importing, meta, value);
    }

    public void addExportingParameter(String name, String type, RpeParameterMeta meta, IEdoValue value) {
        this.addParameter(name, type, RpeParameterKind.Exporting, meta, value);
    }

    public void addChangingParameter(String name, String type, RpeParameterMeta meta, IEdoValue value) {
        this.addParameter(name, type, RpeParameterKind.Changing, meta, value);
    }

    public void addReturnParameter(String name, String type, RpeParameterMeta meta, IEdoValue value) {
        this.addParameter(name, type, RpeParameterKind.Return, meta, value);
    }

    public RpeParameter getParameter(String name) {
        RpeParameter param = (RpeParameter)this.m_parameters.get(name);
        return param;
    }

    public String getParameterType(String name) {
        RpeParameter param = this.getParameter(name);
        String type = param != null ? param.getType() : null;
        return type;
    }

    public RpeParameterMeta getParameterMeta(String name) {
        RpeParameter param = this.getParameter(name);
        RpeParameterMeta meta = param != null ? param.getMeta() : null;
        return meta;
    }

    public RpeParameterKind getParameterKind(String name) {
        RpeParameter param = this.getParameter(name);
        RpeParameterKind kind = param != null ? param.getKind() : null;
        return kind;
    }

    public IEdoValue getParameterValue(String name) {
        RpeParameter param = this.getParameter(name);
        IEdoValue value = param != null ? param.getValue() : null;
        return value;
    }

    public void setParameterValue(String name, IEdoValue value) {
        String _methodName = "setParameterValue";
        if (value == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "setParameterValue", "value", value, "should not be null");
            _location.throwing("setParameterValue", (Throwable)ex);
            throw ex;
        }
        RpeParameter param = this.getParameter(name);
        if (param == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "setParameterValue", "name", name, "parameter not found");
            _location.throwing("setParameterValue", (Throwable)ex);
            throw ex;
        }
        param = new RpeParameter(param, value);
        this.m_parameters.put(name, param);
    }

    protected int addToConnection(RpeObject objRef, IRpeConnectionSpi connection) {
        int ce = 0;
        int be = 0;
        int ci = 0;
        int bi = 0;
        Iterator iter = this.m_parameters.values().iterator();
        if (iter.hasNext()) {
            RpeParameter param = (RpeParameter)iter.next();
            bi = param.addToConnection(connection);
            ci = 1;
            while (iter.hasNext()) {
                param = (RpeParameter)iter.next();
                param.addToConnection(connection);
                ++ci;
            }
        }
        int lineIndex = connection.addLine(objRef.getName(), this.m_opCode.toString(), this.m_name, bi, ci, be, ce);
        return lineIndex;
    }

    protected boolean verifyObjectParameters(IRpeConnection connection) {
        boolean isOkay = true;
        Iterator iter = this.m_parameters.values().iterator();
        while (iter.hasNext()) {
            RpeParameter param = (RpeParameter)iter.next();
            if (param.getMeta() != RpeParameterMeta.Object || ((RpeObject)param.getValue()).getConnection() == connection) continue;
            isOkay = false;
            break;
        }
        return isOkay;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other == null || other.getClass() != (class$com$sap$tc$col$rpe$RpeMethod == null ? (class$com$sap$tc$col$rpe$RpeMethod = RpeMethod.class$("com.sap.tc.col.rpe.RpeMethod")) : class$com$sap$tc$col$rpe$RpeMethod)) {
            isEqual = false;
        } else if (this == other) {
            isEqual = true;
        } else {
            RpeMethod that = (RpeMethod)other;
            isEqual = this.m_name.equals(that.m_name) && this.m_opCode == that.m_opCode && this.m_parameters.equals(that.m_parameters);
        }
        return isEqual;
    }

    public Object clone() {
        RpeMethod that = new RpeMethod(this.m_name, this.m_opCode);
        that.m_parameters.putAll(this.m_parameters);
        return that;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_api/com/sap/tc/col/rpe/RpeMethod.java#1 $");
    }
}

