/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe;

import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.logging.Location;
import java.util.Properties;

public class RpeError {
    public static final String CATEGORY_SCRIPT = "RPE";
    public static final String CATEGORY_BUSINESS = "BOL";
    public static final String CODE_SYSTEM = "SYSTEM";
    public static final String CODE_AUTHORIZATION = "AUTHORIZATION";
    public static final String CODE_SECURITY_CLASS = "SECURITY_CLASS";
    public static final String CODE_SECURITY_METHOD = "SECURITY_METHOD";
    public static final String CODE_INVALID_OPCODE = "INVALID_OPCODE";
    public static final String CODE_INVALID_CLASS = "RPE_CNF";
    public static final String CODE_INVALID_METHOD = "RPE_CMF";
    public static final String CODE_INVALID_TYPE = "RPE_CPF";
    public static final String CODE_INVALID_RESULT = "RPE_CRF";
    public static final String CODE_DYNAMIC_INVOKE = "RPE_CMF";
    public static final String CODE_OBJECT_NOT_FOUND = "RPE_ONF";
    public static final String STATE_FATAL = "FATAL";
    public static final String STATE_RECOVERED = "RECOVERED";
    public final String category;
    public final String code;
    public final String description;
    public final String state;
    public final String object;
    public final String className;
    public final String opcode;
    public final String method;
    public final String parameter;
    public final String value;
    public final String location;
    public final IRpeConnection connection;

    public RpeError(String category, String code, String state, String description, String object, String className, String opcode, String method, String parameter, String value, String location, IRpeConnection connection) {
        this.category = category;
        this.object = object;
        this.className = className;
        this.opcode = opcode;
        this.method = method;
        this.parameter = parameter;
        this.value = value;
        this.code = code;
        this.state = state;
        this.description = description;
        this.location = location;
        this.connection = connection;
    }

    public String getTrace() {
        return this.object + "{" + this.className + "}" + "->" + this.method + "(" + this.parameter + ":\"" + this.value + "\")";
    }

    public Properties getConnectionInfo() {
        return this.connection.getConnectionInfo();
    }

    public String toString() {
        return this.object + "{" + this.className + "}" + "->" + this.method + "(" + this.parameter + ":\"" + this.value + "\") : " + " Resulted in " + this.category + ":" + this.code + "=>\"" + this.description + "\"" + (this.location != null ? " at " + this.location : "") + " State:" + this.state + " on " + this.connection.getConnectionInfo();
    }

    private static String toString(byte[] xString) {
        String retVal;
        try {
            retVal = new String(xString, "UTF-8");
        }
        catch (Exception ex) {
            retVal = null;
        }
        return retVal;
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_api/com/sap/tc/col/rpe/RpeError.java#1 $");
    }
}

