/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.IRpeContextFactory;
import com.sap.tc.col.rpe.RpeConfigurationHelper;
import com.sap.tc.col.rpe.RpeErrors;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeMethodOpCode;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;

public abstract class RpeContext
implements CCDirectives {
    public static final String eventOnCreate = new String("ON_RPE_CONTEXT_CREATE");
    public static final String eventOnBeforeFlush = new String("ON_RPE_CONTEXT_BEFORE_FLUSH");
    public static final String eventOnAfterFlush = new String("ON_RPE_CONTEXT_AFTER_FLUSH");
    private static final String _className = (class$com$sap$tc$col$rpe$RpeContext == null ? (class$com$sap$tc$col$rpe$RpeContext = RpeContext.class$("com.sap.tc.col.rpe.RpeContext")) : class$com$sap$tc$col$rpe$RpeContext).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private static IRpeContextFactory factory;
    protected boolean m_isSynchronous;
    protected RpeErrors m_errors;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$RpeContext;

    public static RpeContext createContext() {
        RpeContext ctxt = factory.createContext();
        return ctxt;
    }

    protected RpeContext() {
        this.m_isSynchronous = false;
        this.m_errors = null;
    }

    protected RpeContext(RpeContext original) {
        this.m_isSynchronous = original.m_isSynchronous;
        this.m_errors = null;
    }

    public abstract RpeContext createSharedContext();

    public abstract IRpeConnection createConnection(String var1, boolean var2);

    public abstract IRpeConnection setDefaultConnection(IRpeConnection var1);

    public abstract void releaseConnection(IRpeConnection var1);

    protected abstract RpeObject createObject(String var1, IRpeConnectionSpi var2, String var3);

    public final RpeObject createObject(String className, IRpeConnection connection, String name) {
        return this.createObject(className, (IRpeConnectionSpi)connection, name);
    }

    public final RpeObject createObject(String className, IRpeConnection connection) {
        return this.createObject(className, (IRpeConnectionSpi)connection, null);
    }

    public final RpeObject createObject(IRpeConnection connection, String name) {
        return this.createObject(null, (IRpeConnectionSpi)connection, name);
    }

    public final RpeObject createObject(IRpeConnection connection) {
        return this.createObject(null, (IRpeConnectionSpi)connection, null);
    }

    public final RpeObject createObject(String className, String name) {
        return this.createObject(className, (IRpeConnectionSpi)null, name);
    }

    public final RpeObject createObject(String className) {
        return this.createObject(className, (IRpeConnectionSpi)null, (String)null);
    }

    public final RpeObject createTemporaryObject(String name) {
        return this.createObject((String)null, (IRpeConnectionSpi)null, name);
    }

    public final RpeObject createObject() {
        return this.createObject((String)null, (IRpeConnectionSpi)null, (String)null);
    }

    public abstract IEdoAtomicValue createValue(String var1);

    public abstract IEdoStructure createStructure(IStructureDescriptor var1);

    public abstract IEdoTable createTable(IStructureDescriptor var1);

    public abstract IEdoIndexTable createIndexTable(IStructureDescriptor var1, int var2, int var3);

    public abstract IEdoIndexTable createIndexTable(IStructureDescriptor var1, String var2, String var3);

    public abstract RpeParameter createParameter(String var1, String var2, RpeParameterKind var3, RpeParameterMeta var4, IEdoValue var5);

    protected abstract RpeMethod createMethod(String var1, RpeMethodOpCode var2);

    public RpeMethod createMethod(String name) {
        return this.createMethod(name, RpeMethodOpCode.Method);
    }

    public final void releaseObject(RpeObject objRef) {
        this.releaseObjectInternal(objRef);
    }

    protected abstract void releaseObjectInternal(RpeObject var1);

    public boolean isSynchronous() {
        return this.m_isSynchronous;
    }

    public void setSynchronous(boolean sync) {
        if (sync && !this.m_isSynchronous) {
            this.flush();
        }
        this.m_isSynchronous = sync;
    }

    public abstract void callMethod(RpeObject var1, RpeMethod var2, boolean var3);

    public abstract int getInstructionQueueSize();

    public abstract void flush();

    public abstract void release();

    public final boolean hasError() {
        return this.m_errors != null ? !this.m_errors.isEmpty() : false;
    }

    public RpeErrors getErrors() {
        return this.m_errors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_api/com/sap/tc/col/rpe/RpeContext.java#1 $");
        factory = (IRpeContextFactory)RpeConfigurationHelper.getInstance("com.sap.tc.col.rpe.RpeContext.ContextFactory", "com.sap.tc.col.rpe.core.RpeContextImpl$SimpleContextFactory");
    }
}

