/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.ConvertXToX;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.i18n.cp.ConverterJNITestDataCpCToX;
import com.sap.i18n.cp.ConverterJNITestDataCpXToC;
import com.sap.i18n.cp.ConverterJNITestDataCpXToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToC;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToX;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConverterJNITImpl {
    private VerifyIntf m_oVerify;
    public static ConverterJNITestDataCpXToC[] m_aTestDataXToCAll = new ConverterJNITestDataCpXToC[]{new ConverterJNITestDataCpXToC("1100", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{65, -60, 67}, new char[]{'A', '\u00c4', 'C'}, 0)}), new ConverterJNITestDataCpXToC("8000", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToC(new byte[]{-127, -127}, new char[]{'\uff1d'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{65, -60, 67}, new char[]{'A', '\uff84', 'C'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{65, -127}, new char[]{'A', '\u0081'}, 0)}), new ConverterJNITestDataCpXToC("", 16, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67}, new char[0], 16)})};
    public static ConverterJNITestDataCpCToX[] m_aTestDataCToXAll = new ConverterJNITestDataCpCToX[]{new ConverterJNITestDataCpCToX("1100", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u00c4', 'C'}, new byte[]{65, -60, 67}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\uff1d'}, new byte[]{65, 35}, 0)}), new ConverterJNITestDataCpCToX("8000", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u00c4', 'C'}, new byte[]{65, 35, 67}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\uff1d'}, new byte[]{65, -127, -127}, 0)}), new ConverterJNITestDataCpCToX("", 16, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[0], 16)})};
    public static ConverterJNITestDataCpXToX[] m_aTestDataXToXAll = new ConverterJNITestDataCpXToX[]{new ConverterJNITestDataCpXToX("1100", "1401", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -60, 67}, new byte[]{65, -60, 67}, 0)}), new ConverterJNITestDataCpXToX("1100", "8000", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -60, 67}, new byte[]{65, 35, 67}, 0)}), new ConverterJNITestDataCpXToX("8000", "4102", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[]{0, 65, 0, 66, 0, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{65, -127, -127}, new byte[]{0, 65, -1, 29}, 0)}), new ConverterJNITestDataCpXToX("4102", "8000", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, 66, 0, 67}, new byte[]{65, 66, 67}, 0), new ConverterJNITestDataSingleXToX(new byte[]{0, 65, -1, 29}, new byte[]{65, -127, -127}, 0), new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, -60}, new byte[]{65, 35}, 0)}), new ConverterJNITestDataCpXToX("4102", "4103", 0, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{0, 65, 0, 66, 0, 67}, new byte[]{65, 0, 66, 0, 67, 0}, 0)}), new ConverterJNITestDataCpXToX("", "", 16, new ConverterJNITestDataSingleXToX[]{new ConverterJNITestDataSingleXToX(new byte[]{65, 66, 67}, new byte[0], 16)})};

    public ConverterJNITImpl(VerifyIntf oVerify) {
        this.m_oVerify = oVerify;
    }

    private void verify(boolean bCond, String sErrText, String sTestName) {
        this.m_oVerify.verifyTest(bCond, sErrText, sTestName);
    }

    public void testMain() {
        this.testConvertXToC();
        this.testConvertCToX();
        this.testConvertXToX();
        this.stressConvertXToC();
    }

    public void testFast() {
        this.testConvertXToC();
        this.testConvertCToX();
        this.testConvertXToX();
    }

    void verifyConvertInit(char[] acCpIn, char[] acCpOut, int nReturn, int nReturnExpected, String sName) {
        this.verify(nReturn == nReturnExpected, new String(acCpIn) + "->" + new String(acCpOut) + ": Init returned " + nReturn + " (" + nReturnExpected + ")", sName);
    }

    public void testConvertXToC() {
        int i = 0;
        while (i < m_aTestDataXToCAll.length) {
            ConverterJNITestDataCpXToC oDataCp = m_aTestDataXToCAll[i];
            int[] aRet = new int[]{0, 0};
            boolean bCnvInitOk = true;
            ConvertBase.CheckConverterJNIAvailable();
            byte[] aCnvObj = ConverterJNI.ConvertInit(oDataCp.m_acCpIn, ConvertBase.m_acUcCp, true, aRet);
            this.verifyConvertInit(oDataCp.m_acCpIn, ConvertBase.m_acUcCp, aRet[0], oDataCp.m_nReturn, "ConvertXToC");
            bCnvInitOk = aRet[0] == 0;
            ConvertXToC oCnvObj = new ConvertXToC(oDataCp.m_acCpIn, true);
            this.verifyConvertInit(oDataCp.m_acCpIn, ConvertBase.m_acUcCp, oCnvObj.GetLastRet(), oDataCp.m_nReturn, "ConvertXToC");
            int j = 0;
            while (j < oDataCp.m_aData.length) {
                ConverterJNITestDataSingleXToC oData = oDataCp.m_aData[j];
                String sOut = ConverterJNI.ConvertXToCDirect(oDataCp.m_acCpIn, oData.m_abDataIn, aRet);
                this.verifyConvertXToC(oDataCp.m_acCpIn, oData.m_abDataIn, sOut, oData.m_acDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertXToCDirect");
                if (bCnvInitOk) {
                    sOut = ConverterJNI.ConvertXToC(aCnvObj, oData.m_abDataIn, aRet);
                    this.verifyConvertXToC(oDataCp.m_acCpIn, oData.m_abDataIn, sOut, oData.m_acDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                if (bCnvInitOk) {
                    sOut = oCnvObj.Convert(oData.m_abDataIn);
                    this.verifyConvertXToC(oDataCp.m_acCpIn, oData.m_abDataIn, sOut, oData.m_acDataOut, oCnvObj.GetLastRet(), oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                ++j;
            }
            ConverterJNI.ConvertFinish(aCnvObj);
            ++i;
        }
    }

    void verifyConvertXToC(char[] acCpIn, byte[] abIn, String sOut, char[] acOutExpected, int nReturn, int nReturnExpected, String sName) {
        if (nReturn != nReturnExpected) {
            this.verify(false, new String(acCpIn) + "->" + "UC" + " returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        }
        String sInBytes = StrUtil.buildByteString(abIn);
        String sOutBytes = StrUtil.buildByteString(sOut);
        String sOutExpectedBytes = StrUtil.buildByteString(new String(acOutExpected));
        this.verify(sOutBytes.equals(sOutExpectedBytes), new String(acCpIn) + "->" + "UC" + ": " + sInBytes + "->" + sOutBytes + " (" + sOutExpectedBytes + ")", sName);
    }

    public void stressConvertXToC() {
        System.out.println("Stress test begin");
        ConvertXToC oCnvObj = new ConvertXToC(new char[]{'1', '4', '0', '1'}, true);
        String sOut = "";
        byte[] abIn = new byte[1];
        int i = 0;
        while (i < abIn.length) {
            abIn[i] = (byte)(64 + i % 10);
            ++i;
        }
        long startLoop = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 0x100000) {
            sOut = oCnvObj.Convert(abIn);
            ++i2;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"Frequent\"", startLoop, endLoop, 0x100000L);
    }

    public void testConvertCToX() {
        int i = 0;
        while (i < m_aTestDataCToXAll.length) {
            ConverterJNITestDataCpCToX oDataCp = m_aTestDataCToXAll[i];
            int[] aRet = new int[]{0, 0};
            boolean bCnvInitOk = true;
            ConvertBase.CheckConverterJNIAvailable();
            byte[] aCnvObj = ConverterJNI.ConvertInit(ConvertBase.m_acUcCp, oDataCp.m_acCpOut, true, aRet);
            this.verifyConvertInit(ConvertBase.m_acUcCp, oDataCp.m_acCpOut, aRet[0], oDataCp.m_nReturn, "ConvertCToX");
            bCnvInitOk = aRet[0] == 0;
            ConvertCToX oCnvObj = new ConvertCToX(oDataCp.m_acCpOut, true);
            this.verifyConvertInit(ConvertBase.m_acUcCp, oDataCp.m_acCpOut, oCnvObj.GetLastRet(), oDataCp.m_nReturn, "ConvertCToX");
            int j = 0;
            while (j < oDataCp.m_aData.length) {
                ConverterJNITestDataSingleCToX oData = oDataCp.m_aData[j];
                byte[] abOut = ConverterJNI.ConvertCToXDirect(oDataCp.m_acCpOut, new String(oData.m_acDataIn), aRet);
                this.verifyConvertCToX(oData.m_acDataIn, oDataCp.m_acCpOut, abOut, oData.m_abDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertCToXDirect");
                if (bCnvInitOk) {
                    abOut = ConverterJNI.ConvertCToX(aCnvObj, new String(oData.m_acDataIn), aRet);
                    this.verifyConvertCToX(oData.m_acDataIn, oDataCp.m_acCpOut, abOut, oData.m_abDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                if (bCnvInitOk) {
                    abOut = oCnvObj.Convert(new String(oData.m_acDataIn));
                    this.verifyConvertCToX(oData.m_acDataIn, oDataCp.m_acCpOut, abOut, oData.m_abDataOut, oCnvObj.GetLastRet(), oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                ++j;
            }
            ConverterJNI.ConvertFinish(aCnvObj);
            ++i;
        }
    }

    void verifyConvertCToX(char[] sIn, char[] acCpOut, byte[] abOut, byte[] abOutExpected, int nReturn, int nReturnExpected, String sName) {
        if (nReturn != nReturnExpected) {
            this.verify(false, "UC->" + new String(acCpOut) + " returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        }
        String sOutBytes = StrUtil.buildByteString(abOut);
        String sOutBytesExpected = StrUtil.buildByteString(abOutExpected);
        String sInBytes = StrUtil.buildByteString(new String(sIn));
        this.verify(sOutBytes.equals(sOutBytesExpected), "UC->" + new String(acCpOut) + ": " + sInBytes + "->" + sOutBytes + " (" + sOutBytesExpected + ")", sName);
    }

    public void testConvertXToX() {
        int i = 0;
        while (i < m_aTestDataXToXAll.length) {
            ConverterJNITestDataCpXToX oDataCp = m_aTestDataXToXAll[i];
            int[] aRet = new int[]{0, 0};
            boolean bCnvInitOk = true;
            ConvertBase.CheckConverterJNIAvailable();
            byte[] aCnvObj = ConverterJNI.ConvertInit(oDataCp.m_acCpIn, oDataCp.m_acCpOut, true, aRet);
            this.verifyConvertInit(oDataCp.m_acCpIn, oDataCp.m_acCpOut, aRet[0], oDataCp.m_nReturn, "ConvertXToX");
            bCnvInitOk = aRet[0] == 0;
            ConvertXToX oCnvObj = new ConvertXToX(oDataCp.m_acCpIn, oDataCp.m_acCpOut, true);
            this.verifyConvertInit(oDataCp.m_acCpIn, oDataCp.m_acCpOut, oCnvObj.GetLastRet(), oDataCp.m_nReturn, "ConvertXToX");
            int j = 0;
            while (j < oDataCp.m_aData.length) {
                ConverterJNITestDataSingleXToX oData = oDataCp.m_aData[j];
                byte[] abOut = ConverterJNI.ConvertXToXDirect(oDataCp.m_acCpIn, oDataCp.m_acCpOut, oData.m_abDataIn, aRet);
                this.verifyConvertXToX(oDataCp.m_acCpIn, oDataCp.m_acCpOut, oData.m_abDataIn, abOut, oData.m_abDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertXToXDirect");
                if (bCnvInitOk) {
                    abOut = ConverterJNI.ConvertXToX(aCnvObj, oData.m_abDataIn, aRet);
                    this.verifyConvertXToX(oDataCp.m_acCpIn, oDataCp.m_acCpOut, oData.m_abDataIn, abOut, oData.m_abDataOut, aRet[0], oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                if (bCnvInitOk) {
                    abOut = oCnvObj.Convert(oData.m_abDataIn);
                    this.verifyConvertXToX(oDataCp.m_acCpIn, oDataCp.m_acCpOut, oData.m_abDataIn, abOut, oData.m_abDataOut, oCnvObj.GetLastRet(), oData.m_nReturn, "ConverterJNI.ConvertXToX");
                }
                ++j;
            }
            ConverterJNI.ConvertFinish(aCnvObj);
            ++i;
        }
    }

    void verifyConvertXToX(char[] acCpIn, char[] acCpOut, byte[] abIn, byte[] abOut, byte[] abOutExpected, int nReturn, int nReturnExpected, String sName) {
        if (nReturn != nReturnExpected) {
            this.verify(false, new String(acCpIn) + "->" + new String(acCpOut) + " returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        }
        String sInBytes = StrUtil.buildByteString(abIn);
        String sOutBytes = StrUtil.buildByteString(abOut);
        String sOutExpectedBytes = StrUtil.buildByteString(abOutExpected);
        this.verify(sOutBytes.equals(sOutExpectedBytes), new String(acCpIn) + "->" + new String(acCpOut) + ": " + sInBytes + "->" + sOutBytes + " (" + sOutExpectedBytes + ")", sName);
    }

    private void timecheckPrintResult(String name, long startLoop, long endLoop, long numOp) {
        long timeLoop = endLoop - startLoop;
        long timeperopLoop = (endLoop - startLoop) * 1000L * 1000L / numOp;
        System.out.println("Time " + name + " Loop: " + timeLoop + " per op (ns): " + timeperopLoop);
    }
}

