/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.CheckCharsetOfString;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.verify.intf.VerifyIntf;

public class CheckCharsetOfStringTImpl {
    private VerifyIntf m_oVerify;

    public CheckCharsetOfStringTImpl(VerifyIntf oVerify) {
        this.m_oVerify = oVerify;
    }

    private void verify(boolean bCond, String sErrText, String sTestName) {
        this.m_oVerify.verifyTest(bCond, sErrText, sTestName);
    }

    public void testMain() {
        this.testCheck();
        this.stressCheck();
    }

    public void testFast() {
        this.testCheck();
    }

    public void testCheck() {
        this.verifyCheck("Hello", "EN", true, -1, "", "English only");
        this.verifyCheck("Hello", "en", true, -1, "", "English only lowercase lang");
        this.verifyCheck("H\u00e4h\u00e4", "DE", true, -1, "", "German for German");
        this.verifyCheck("HaH\u00e4h\u00e4h\u00e4", "EN", false, 3, "HaHahaha", "German for English");
        this.verifyCheck("HaH\u00e4", "PL", true, -1, "", "German for Polish");
        this.verifyCheck("HaH\u00e4", "HU", true, -1, "", "German for Hungarian");
        this.verifyCheck("HaH\u00e4Ha", "JA", false, 3, "", "German for Japanese");
        this.verifyCheck("HaH\u20ac", "DE", false, 3, "HaHEUR", "Latin-1 specific for German");
        this.verifyCheck("HaH\u20ac", "XX", false, 0, "", "Undefined language");
        this.verifyCheck("AB\u00a3C", "FR", true, -1, "", "Latin-1 specific for French");
        this.verifyCheck("AB\u0100C", "FR", false, 2, "", "Non Latin-1 for French");
        this.verifyCheck("AB\uff1dC", "JA", true, -1, "", "Japanese");
        this.verifyCheck("AB\u0100C", "JA", false, 2, "", "Non-Japanese");
    }

    public void stressCheck() {
        long startLoop = 0L;
        long endLoop = 0L;
        System.out.println("Stress test begin");
        char[] acLarge = new char[0x200000];
        int i = 0;
        while (i < acLarge.length) {
            acLarge[i] = 65;
            ++i;
        }
        String sLarge = new String(acLarge);
        startLoop = System.currentTimeMillis();
        this.verifyCheck(sLarge, "EN", true, -1, "", "Large");
        endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"Large\"", startLoop, endLoop, 1L);
        startLoop = System.currentTimeMillis();
        this.verifyCheckMultiple("0123456789", "PL", true, -1, "", "Frequent", 0x100000);
        endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"Frequent\"", startLoop, endLoop, 0x100000L);
        startLoop = System.currentTimeMillis();
        int i2 = 1;
        while (i2 < 65536) {
            CheckCharsetOfString oCheck = new CheckCharsetOfString("EN");
            ++i2;
        }
        endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"Frequent init\"", startLoop, endLoop, 65536L);
    }

    private void verifyCheck(String sText, String sLang, boolean bReturnExpected, int nInDoneExpected, String sProposalExpected, String sName) {
        CheckCharsetOfString.CheckInfo oResult;
        CheckCharsetOfString oCheck = new CheckCharsetOfString(new String(sLang));
        try {
            oResult = oCheck.check(sText);
        }
        catch (ConverterException e) {
            oResult = new CheckCharsetOfString.CheckInfo(false, 0, "");
        }
        this.verify(oResult.getSuccess() == bReturnExpected, "Lang: " + sLang + "Text: " + sText + " " + "Returned: " + oResult.getSuccess() + " (" + bReturnExpected + ")", sName);
        if (!bReturnExpected) {
            this.verify(oResult.getWrongPos() == nInDoneExpected, "Lang: " + sLang + "Text: " + sText + " " + "WrongPos: " + oResult.getWrongPos() + " (" + nInDoneExpected + ")", sName);
            this.verify(oResult.getProposal().equals(sProposalExpected), "Lang: " + sLang + "Text: " + sText + " " + "Proposal: " + oResult.getProposal() + " (" + sProposalExpected + ")", sName);
        }
    }

    private void verifyCheckMultiple(String sText, String sLang, boolean bReturnExpected, int nInDoneExpected, String sProposalExpected, String sName, int nCnt) {
        CheckCharsetOfString oCheck = new CheckCharsetOfString(new String(sLang));
        CheckCharsetOfString.CheckInfo oResult = new CheckCharsetOfString.CheckInfo(false, 0, "");
        int i = 0;
        while (i < nCnt) {
            try {
                oResult = oCheck.check(sText);
            }
            catch (ConverterException e) {
                oResult = new CheckCharsetOfString.CheckInfo(false, 0, "");
            }
            ++i;
        }
        this.verify(oResult.getSuccess() == bReturnExpected, "Lang: " + sLang + "Text: " + sText + " " + "Returned: " + oResult.getSuccess() + " (" + bReturnExpected + ")", sName);
        if (!bReturnExpected) {
            this.verify(oResult.getWrongPos() == nInDoneExpected, "Lang: " + sLang + "Text: " + sText + " " + "WrongPos: " + oResult.getWrongPos() + " (" + nInDoneExpected + ")", sName);
            this.verify(oResult.getProposal().equals(sProposalExpected), "Lang: " + sLang + "Text: " + sText + " " + "Proposal: " + oResult.getProposal() + " (" + sProposalExpected + ")", sName);
        }
    }

    private void timecheckPrintResult(String name, long startLoop, long endLoop, long numOp) {
        long timeLoop = endLoop - startLoop;
        long timeperopLoop = (endLoop - startLoop) * 1000L * 1000L / numOp;
        System.out.println("Time " + name + " Loop: " + timeLoop + " per op (ns): " + timeperopLoop);
    }
}

