/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.ConverterException;

public class CheckCharsetOfString {
    private static LangFilter[] m_langFilters = new LangFilter[]{new LangFilter("EN", "1101", "1155"), new LangFilter("ID", "1101", "1155"), new LangFilter("MS", "1101", "1155"), new LangFilter("DE", "1106", "1157"), new LangFilter("AF", "1100", "0000"), new LangFilter("CA", "1100", "0000"), new LangFilter("DA", "1100", "0000"), new LangFilter("ES", "1100", "0000"), new LangFilter("FI", "1100", "0000"), new LangFilter("FR", "1100", "0000"), new LangFilter("IS", "1100", "0000"), new LangFilter("IT", "1100", "0000"), new LangFilter("NL", "1100", "0000"), new LangFilter("NO", "1100", "0000"), new LangFilter("PT", "1100", "0000"), new LangFilter("CS", "1401", "0000"), new LangFilter("HR", "1401", "0000"), new LangFilter("HU", "1401", "0000"), new LangFilter("PL", "1401", "0000"), new LangFilter("RO", "1401", "0000"), new LangFilter("SH", "1401", "0000"), new LangFilter("SK", "1401", "0000"), new LangFilter("SL", "1401", "0000"), new LangFilter("BG", "1500", "0000"), new LangFilter("RU", "1500", "0000"), new LangFilter("SR", "1500", "0000"), new LangFilter("SV", "1500", "0000"), new LangFilter("UK", "1500", "0000"), new LangFilter("TR", "1610", "0000"), new LangFilter("EL", "1700", "0000"), new LangFilter("HE", "1800", "0000"), new LangFilter("ET", "1900", "0000"), new LangFilter("LT", "1900", "0000"), new LangFilter("LV", "1900", "0000"), new LangFilter("JA", "8000", "0000"), new LangFilter("ZH", "8300", "0000"), new LangFilter("ZF", "8400", "0000"), new LangFilter("KO", "8500", "0000"), new LangFilter("TH", "8600", "0000"), new LangFilter("AR", "8700", "0000")};
    private LangFilter m_langFilter;
    private ConvertCToX m_filterCnv;
    private ConvertCToX m_translitCnv;
    private ConvertXToC m_translitbackCnv;

    public CheckCharsetOfString(String lang) {
        this.m_langFilter = this.getLangFilter(lang);
        if (this.m_langFilter != null) {
            this.initCnv(this.m_langFilter);
        }
    }

    private void initCnv(LangFilter filter) {
        this.m_filterCnv = new ConvertCToX(filter.m_filterCp, false);
        if (!new String(filter.m_translitCp).equals("0000")) {
            this.m_translitCnv = new ConvertCToX(filter.m_translitCp, true);
            this.m_translitbackCnv = new ConvertXToC(filter.m_filterCp, true);
        }
    }

    private LangFilter getLangFilter(String lang) {
        LangFilter filter = null;
        int i = 0;
        while (i < m_langFilters.length) {
            if (CheckCharsetOfString.m_langFilters[i].m_lang.equalsIgnoreCase(lang)) {
                filter = m_langFilters[i];
                break;
            }
            ++i;
        }
        return filter;
    }

    public CheckInfo check(String text) throws ConverterException {
        byte[] textTranslit;
        if (this.m_langFilter == null) {
            throw new ConverterException("Unkown language");
        }
        if (!this.m_filterCnv.InitOk()) {
            throw new ConverterException("Converter initialization failed");
        }
        byte[] textFiltered = this.m_filterCnv.Convert(text);
        if (textFiltered != null) {
            return new CheckInfo(true, 0, "");
        }
        String proposal = "";
        if (this.m_translitCnv != null && (textTranslit = this.m_translitCnv.Convert(text)) != null) {
            proposal = this.m_translitbackCnv.Convert(textTranslit);
        }
        int nInDone = this.m_filterCnv.GetLastError().m_nInDone;
        CheckInfo oResult = new CheckInfo(false, nInDone, proposal);
        return oResult;
    }

    public static class CheckInfo {
        private boolean m_success;
        private int m_wrongPos;
        private String m_proposal;

        public CheckInfo(boolean success, int wrongPos, String proposal) {
            this.m_success = success;
            this.m_wrongPos = wrongPos;
            this.m_proposal = proposal;
        }

        public boolean getSuccess() {
            return this.m_success;
        }

        public int getWrongPos() {
            return this.m_wrongPos;
        }

        public String getProposal() {
            return this.m_proposal;
        }
    }

    private static class LangFilter {
        public String m_lang;
        public char[] m_filterCp;
        public char[] m_translitCp;

        public LangFilter(String lang, String filterCp, String translitCp) {
            this.m_lang = lang;
            this.m_filterCp = filterCp.toCharArray();
            this.m_translitCp = translitCp.toCharArray();
        }
    }
}

