/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class ReorderPartCommand
extends AbstractCommand {
    private boolean valuesInitialized;
    private int oldIndex;
    private int newIndex;
    private LogicSubpart child;
    private LogicDiagram parent;

    public ReorderPartCommand(LogicSubpart child, LogicDiagram parent, int oldIndex, int newIndex) {
        super(LogicMessages.ReorderPartCommand_Label);
        this.child = child;
        this.parent = parent;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
    }

    public void execute() {
        this.parent.removeChild(this.child);
        this.parent.addChild(this.child, this.newIndex);
    }

    public String getDescription() {
        return String.valueOf(LogicMessages.ReorderPartCommand_Description) + this.child.getID() + " in " + this.parent.getID() + " from index " + this.oldIndex + " to " + this.newIndex;
    }

    public void undo() {
        this.parent.removeChild(this.child);
        this.parent.addChild(this.child, this.oldIndex);
    }
}

