/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.DimensionPropertySource;
import org.eclipse.gef.examples.logicdesigner.model.LocationPropertySource;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class LogicSubpart
extends LogicElement {
    private String id;
    protected Hashtable inputs = new Hashtable(7);
    protected Point location = new Point(0, 0);
    protected Vector outputs = new Vector(4, 4);
    static final long serialVersionUID = 1L;
    protected Dimension size = new Dimension(-1, -1);
    protected static IPropertyDescriptor[] descriptors = null;
    public static String ID_SIZE = "size";
    public static String ID_LOCATION = "location";

    static {
        descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)ID_SIZE, LogicMessages.PropertyDescriptor_LogicSubPart_Size), new PropertyDescriptor((Object)ID_LOCATION, LogicMessages.PropertyDescriptor_LogicSubPart_Location)};
    }

    public LogicSubpart() {
        this.setID(this.getNewID());
    }

    public void connectInput(Wire w) {
        this.inputs.put(w.getTargetTerminal(), w);
        this.update();
        this.fireStructureChange("inputs", w);
    }

    public void connectOutput(Wire w) {
        this.outputs.addElement(w);
        this.update();
        this.fireStructureChange("outputs", w);
    }

    public void disconnectInput(Wire w) {
        this.inputs.remove(w.getTargetTerminal());
        this.update();
        this.fireStructureChange("inputs", w);
    }

    public void disconnectOutput(Wire w) {
        this.outputs.removeElement(w);
        this.update();
        this.fireStructureChange("outputs", w);
    }

    public Vector getConnections() {
        Vector v = (Vector)this.outputs.clone();
        Enumeration ins = this.inputs.elements();
        while (ins.hasMoreElements()) {
            v.addElement(ins.nextElement());
        }
        return v;
    }

    public Image getIcon() {
        return this.getIconImage();
    }

    public abstract Image getIconImage();

    public String getID() {
        return this.id;
    }

    protected boolean getInput(String terminal) {
        Wire w = (Wire)this.inputs.get(terminal);
        return w == null ? false : w.getValue();
    }

    public Point getLocation() {
        return this.location;
    }

    protected abstract String getNewID();

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propName) {
        if (ID_SIZE.equals(propName)) {
            return new DimensionPropertySource(this.getSize());
        }
        if (ID_LOCATION.equals(propName)) {
            return new LocationPropertySource(this.getLocation());
        }
        return null;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Vector getSourceConnections() {
        return (Vector)this.outputs.clone();
    }

    public Vector getTargetConnections() {
        Enumeration enumeration = this.inputs.elements();
        Vector v = new Vector(this.inputs.size());
        while (enumeration.hasMoreElements()) {
            v.addElement(enumeration.nextElement());
        }
        return v;
    }

    public boolean isPropertySet() {
        return true;
    }

    public void setID(String s) {
        this.id = s;
    }

    public void setLocation(Point p) {
        if (this.location.equals((Object)p)) {
            return;
        }
        this.location = p;
        this.firePropertyChange("location", null, p);
    }

    protected void setOutput(String terminal, boolean val) {
        Enumeration enumeration = this.outputs.elements();
        while (enumeration.hasMoreElements()) {
            Wire w = (Wire)enumeration.nextElement();
            if (!w.getSourceTerminal().equals(terminal) || !this.equals(w.getSource())) continue;
            w.setValue(val);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (ID_SIZE.equals(id)) {
            DimensionPropertySource dimPS = (DimensionPropertySource)value;
            this.setSize(new Dimension(dimPS.getValue()));
        } else if (ID_LOCATION.equals(id)) {
            LocationPropertySource locPS = (LocationPropertySource)value;
            this.setLocation(new Point(locPS.getValue()));
        }
    }

    public void setSize(Dimension d) {
        if (this.size.equals((Object)d)) {
            return;
        }
        this.size = d;
        this.firePropertyChange("size", null, this.size);
    }
}

