/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class LogicDiagram
extends LogicSubpart {
    static final long serialVersionUID = 1L;
    private static int count;
    private static Image LOGIC_ICON;
    protected List children = new ArrayList();
    public static String ID_ROUTER;
    public static Integer ROUTER_MANUAL;
    public static Integer ROUTER_MANHATTAN;
    protected Integer connectionRouter = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.examples.logicdesigner.model.LogicDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGIC_ICON = new Image(null, clazz.getResourceAsStream("icons/circuit16.gif"));
        ID_ROUTER = "router";
        ROUTER_MANUAL = new Integer(0);
        ROUTER_MANHATTAN = new Integer(1);
    }

    public LogicDiagram() {
        this.size.width = 100;
        this.size.height = 100;
        this.location.x = 20;
        this.location.y = 20;
    }

    public void addChild(LogicElement child) {
        this.addChild(child, -1);
    }

    public void addChild(LogicElement child, int index) {
        if (index >= 0) {
            this.children.add(index, child);
        } else {
            this.children.add(child);
        }
        this.fireStructureChange("Children", child);
    }

    public List getChildren() {
        return this.children;
    }

    public Integer getConnectionRouter() {
        if (this.connectionRouter == null) {
            this.connectionRouter = ROUTER_MANUAL;
        }
        return this.connectionRouter;
    }

    public Image getIconImage() {
        return LOGIC_ICON;
    }

    public String getNewID() {
        return Integer.toString(count++);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.gef.examples.logicdesigner.model.LogicDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            ComboBoxPropertyDescriptor cbd = new ComboBoxPropertyDescriptor((Object)ID_ROUTER, LogicMessages.PropertyDescriptor_LogicDiagram_ConnectionRouter, new String[]{LogicMessages.PropertyDescriptor_LogicDiagram_Manual, LogicMessages.PropertyDescriptor_LogicDiagram_Manhattan});
            cbd.setLabelProvider((ILabelProvider)new ConnectionRouterLabelProvider());
            return new IPropertyDescriptor[]{cbd};
        }
        return super.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object propName) {
        if (propName.equals(ID_ROUTER)) {
            return this.connectionRouter;
        }
        return super.getPropertyValue(propName);
    }

    public void removeChild(LogicElement child) {
        this.children.remove(child);
        this.fireStructureChange("Children", child);
    }

    public void setConnectionRouter(Integer router) {
        Integer oldConnectionRouter = this.connectionRouter;
        this.connectionRouter = router;
        this.firePropertyChange(ID_ROUTER, oldConnectionRouter, this.connectionRouter);
    }

    public void setPropertyValue(Object id, Object value) {
        if (ID_ROUTER.equals(id)) {
            this.setConnectionRouter((Integer)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public String toString() {
        return LogicMessages.LogicDiagram_LabelText;
    }

    private class ConnectionRouterLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof Integer) {
                Integer integer = (Integer)element;
                if (ROUTER_MANUAL.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicDiagram_Manual;
                }
                if (ROUTER_MANHATTAN.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicDiagram_Manhattan;
                }
            }
            return super.getText(element);
        }
    }
}

