/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class CreateCommand
extends AbstractCommand {
    private LogicSubpart child;
    private Rectangle rect;
    private LogicDiagram parent;
    private int index = -1;

    public CreateCommand() {
        super(LogicMessages.CreateCommand_Label);
    }

    public void execute() {
        if (this.rect != null) {
            this.child.setLocation(this.rect.getLocation());
            if (!this.rect.isEmpty()) {
                this.child.setSize(this.rect.getSize());
            }
        }
        if (this.index < 0) {
            this.parent.addChild(this.child);
        } else {
            this.parent.addChild(this.child, this.index);
        }
    }

    public String getDescription() {
        String name = this.child.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return String.valueOf(LogicMessages.CreateCommand_Description) + " " + name;
    }

    public LogicDiagram getParent() {
        return this.parent;
    }

    public void redo() {
        if (this.rect != null) {
            this.child.setLocation(this.rect.getLocation());
            this.child.setSize(this.rect.getSize());
        }
        if (this.index < 0) {
            this.parent.addChild(this.child);
        } else {
            this.parent.addChild(this.child, this.index);
        }
    }

    public void setChild(LogicSubpart subpart) {
        this.child = subpart;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setLocation(Rectangle r) {
        this.rect = r;
    }

    public void setParent(LogicDiagram newParent) {
        this.parent = newParent;
    }

    public void undo() {
        this.parent.removeChild(this.child);
    }
}

