/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class AddCommand
extends AbstractCommand {
    private LogicSubpart child;
    private LogicDiagram parent;
    private int index = -1;

    public AddCommand() {
        super(LogicMessages.AddCommand_Label);
    }

    public void execute() {
        if (this.index < 0) {
            this.parent.addChild(this.child);
        } else {
            this.parent.addChild(this.child, this.index);
        }
    }

    public String getDescription() {
        String name = this.child.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return String.valueOf(LogicMessages.AddCommand_Description) + name;
    }

    public LogicDiagram getParent() {
        return this.parent;
    }

    public void redo() {
        if (this.index < 0) {
            this.parent.addChild(this.child);
        } else {
            this.parent.addChild(this.child, this.index);
        }
    }

    public void setChild(LogicSubpart subpart) {
        this.child = subpart;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setParent(LogicDiagram newParent) {
        this.parent = newParent;
    }

    public void undo() {
        this.parent.removeChild(this.child);
    }
}

