/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.LogicColorConstants;
import org.eclipse.swt.graphics.Color;

public class LogicFlowBorder
extends LineBorder {
    private int grabBarWidth = 20;
    private Dimension grabBarSize = new Dimension(this.grabBarWidth, 18);
    private Color grabBarColor = LogicColorConstants.logicGreen;

    public LogicFlowBorder() {
    }

    public LogicFlowBorder(int width) {
        this.setGrabBarWidth(width);
        this.grabBarSize = new Dimension(width, 18);
    }

    public LogicFlowBorder(int width, Color color) {
        this(width);
        this.setGrabBarColor(color);
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.width + 2, this.grabBarWidth + 2, this.width + 2, this.width + 2);
    }

    public Dimension getPreferredSize() {
        return this.grabBarSize;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds();
        AbstractBorder.tempRect.setBounds(new Rectangle(bounds.x, bounds.y, this.grabBarWidth, bounds.height));
        graphics.setBackgroundColor(this.grabBarColor);
        graphics.fillRectangle(AbstractBorder.tempRect);
        super.paint(figure, graphics, insets);
    }

    public void setGrabBarColor(Color color) {
        this.grabBarColor = color;
    }

    public void setGrabBarWidth(int width) {
        this.grabBarWidth = width;
    }

    public void setOutlineColor(Color c) {
        this.color = c;
    }

    public void setOutlineWidth(int w) {
        this.width = w;
    }
}

