/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitBorder;
import org.eclipse.gef.examples.logicdesigner.figures.FixedConnectionAnchor;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.swt.graphics.Color;

public class CircuitFigure
extends NodeFigure {
    private IFigure pane;

    public CircuitFigure() {
        this.setBorder((Border)new CircuitBorder());
        ScrollPane scrollpane = new ScrollPane();
        this.pane = new FreeformLayer();
        this.pane.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)scrollpane);
        scrollpane.setViewport((Viewport)new FreeformViewport());
        scrollpane.setView(this.pane);
        this.createConnectionAnchors();
        this.setBackgroundColor(ColorConstants.buttonLightest);
        this.setOpaque(true);
    }

    protected void createConnectionAnchors() {
        int i = 0;
        while (i < 8) {
            FixedConnectionAnchor in = new FixedConnectionAnchor((IFigure)this);
            FixedConnectionAnchor out = new FixedConnectionAnchor((IFigure)this);
            if (i > 3) {
                in.topDown = false;
                in.offsetV = this.getInsets().top;
                out.topDown = false;
            } else {
                out.offsetV = this.getInsets().top;
            }
            this.setOutputConnectionAnchor(i, (ConnectionAnchor)out);
            this.setInputConnectionAnchor(i, (ConnectionAnchor)in);
            this.outputConnectionAnchors.addElement(out);
            this.inputConnectionAnchors.addElement(in);
            ++i;
        }
    }

    public Color getBorderColor() {
        return ((CircuitBorder)this.getBorder()).getBorderColor();
    }

    public IFigure getContentsPane() {
        return this.pane;
    }

    protected FixedConnectionAnchor getInputConnectionAnchor(int i) {
        return (FixedConnectionAnchor)((Object)this.connectionAnchors.get(Circuit.TERMINALS_IN[i]));
    }

    protected FixedConnectionAnchor getOutputConnectionAnchor(int i) {
        return (FixedConnectionAnchor)((Object)this.connectionAnchors.get(Circuit.TERMINALS_OUT[i]));
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        int connBuffer = 10;
        prefSize = new Dimension(prefSize.width + connBuffer, prefSize.height + connBuffer);
        Dimension defaultSize = new Dimension(100, 100);
        prefSize.union(defaultSize);
        return prefSize;
    }

    protected void layoutConnectionAnchors() {
        int innerwidth = this.getBounds().width - this.getInsets().right * 2;
        int i = 0;
        while (i < 4) {
            int x;
            this.getOutputConnectionAnchor((int)(i + 4)).offsetH = x = (2 * i + 1) * this.getSize().width / 8;
            this.getInputConnectionAnchor((int)i).offsetH = x;
            this.getInputConnectionAnchor((int)(i + 4)).offsetH = x = this.getInsets().right + (2 * i + 1) * innerwidth / 8;
            this.getOutputConnectionAnchor((int)i).offsetH = x;
            ++i;
        }
    }

    public void setBorderColor(Color c) {
        ((CircuitBorder)this.getBorder()).setBorderColor(c);
        this.repaint();
    }

    public void setInputConnectionAnchor(int i, ConnectionAnchor c) {
        this.connectionAnchors.put(Circuit.TERMINALS_IN[i], c);
    }

    public void setOutputConnectionAnchor(int i, ConnectionAnchor c) {
        this.connectionAnchors.put(Circuit.TERMINALS_OUT[i], c);
    }

    public String toString() {
        return "CircuitBoardFigure";
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.layoutConnectionAnchors();
        super.validate();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

