/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CircuitBorder
extends AbstractBorder {
    private static Image downTab;
    private Color borderColor = ColorConstants.button;
    private static Color inner;
    private static Insets insets;
    private static Image upTab;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.examples.logicdesigner.figures.CircuitBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        downTab = new Image(null, clazz.getResourceAsStream("icons/downtab.bmp"));
        inner = new Color(null, 186, 176, 190);
        insets = new Insets(14, 10, 14, 10);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.gef.examples.logicdesigner.figures.CircuitBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        upTab = new Image(null, clazz2.getResourceAsStream("icons/uptab.bmp"));
    }

    private void drawSoldering(Graphics g, Rectangle rec) {
        g.setForegroundColor(FigureUtilities.lighter((Color)this.borderColor));
        int y1 = rec.y;
        int y2 = y1 + CircuitBorder.insets.top - 5;
        int y3 = y1 + rec.height - CircuitBorder.insets.bottom;
        int y4 = y3 + CircuitBorder.insets.bottom - 5;
        int width = rec.width;
        int innerwidth = width - CircuitBorder.insets.right * 2;
        int i = 0;
        while (i < 4) {
            int x1 = rec.x + (2 * i + 1) * width / 8;
            g.drawImage(upTab, x1 - 2, y1);
            g.drawImage(downTab, x1 - 2, y4);
            int x2 = rec.x + CircuitBorder.insets.right + (2 * i + 1) * innerwidth / 8;
            g.drawImage(downTab, x2 - 2, y2);
            g.drawImage(upTab, x2 - 2, y3);
            g.drawLine(x1, y1 + 5, x2, y2);
            g.drawLine(x2, y3 + 5, x1, y4);
            ++i;
        }
    }

    public Insets getInsets(IFigure figure) {
        return insets;
    }

    Color getBorderColor() {
        return this.borderColor;
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(IFigure figure, Graphics g, Insets in) {
        Rectangle r = figure.getBounds().getCropped(in);
        Rectangle rec = r.getExpanded(4, 0);
        g.setLineWidth(28);
        g.setForegroundColor(this.borderColor);
        g.drawRectangle(rec);
        g.setLineWidth(1);
        Color lighter = FigureUtilities.lighter((Color)this.borderColor);
        Color darker = ColorConstants.black;
        g.setForegroundColor(lighter);
        g.drawLine(r.x, r.y, r.right(), r.y);
        g.drawLine(r.x, r.y, r.x, r.bottom());
        r.crop(new Insets(1, 1, 0, 0));
        --r.width;
        --r.height;
        g.setForegroundColor(darker);
        g.drawLine(r.right(), r.bottom(), r.right(), r.y);
        g.drawLine(r.right(), r.bottom(), r.x, r.bottom());
        r.expand(1, 1);
        r.crop(this.getInsets(figure));
        g.setForegroundColor(darker);
        g.drawLine(r.x, r.y, r.right(), r.y);
        g.drawLine(r.x, r.y, r.x, r.bottom());
        r.crop(new Insets(1, 1, 0, 0));
        --r.width;
        --r.height;
        g.setForegroundColor(lighter);
        g.drawLine(r.right(), r.bottom(), r.right(), r.y);
        g.drawLine(r.right(), r.bottom(), r.x, r.bottom());
        g.setBackgroundColor(inner);
        this.drawSoldering(g, figure.getBounds().getCropped(in));
    }

    void setBorderColor(Color c) {
        this.borderColor = c;
    }
}

