/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.AbstractTreeContainerEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.CreateCommand;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.ReorderPartCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class LogicTreeContainerEditPolicy
extends AbstractTreeContainerEditPolicy {
    protected Command createCreateCommand(LogicSubpart child, Rectangle r, int index, String label) {
        Rectangle rect;
        CreateCommand cmd = new CreateCommand();
        if (r == null) {
            rect = new Rectangle();
            rect.setSize(new Dimension(-1, -1));
        } else {
            rect = r;
        }
        cmd.setLocation(rect);
        cmd.setParent((LogicDiagram)this.getHost().getModel());
        cmd.setChild(child);
        cmd.setLabel(label);
        if (index >= 0) {
            cmd.setIndex(index);
        }
        return cmd;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in LogicTreeContainerEditPolicy");
        List editparts = request.getEditParts();
        int index = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            EditPart child = (EditPart)editparts.get(i);
            if (this.isAncestor(child, this.getHost())) {
                command.add((Command)UnexecutableCommand.INSTANCE);
            } else {
                LogicSubpart childModel = (LogicSubpart)child.getModel();
                command.add(this.createCreateCommand(childModel, new Rectangle(new Point(), childModel.getSize()), index, "Reparent LogicSubpart"));
            }
            ++i;
        }
        return command;
    }

    protected Command getCreateCommand(CreateRequest request) {
        LogicSubpart child = (LogicSubpart)request.getNewObject();
        int index = this.findIndexOfTreeItemAt(request.getLocation());
        return this.createCreateCommand(child, null, index, "Create LogicSubpart");
    }

    protected Command getMoveChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand command = new CompoundCommand();
        List editparts = request.getEditParts();
        List children = this.getHost().getChildren();
        int newIndex = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            EditPart child = (EditPart)editparts.get(i);
            int tempIndex = newIndex;
            int oldIndex = children.indexOf(child);
            if (oldIndex == tempIndex || oldIndex + 1 == tempIndex) {
                command.add((Command)UnexecutableCommand.INSTANCE);
                return command;
            }
            if (oldIndex < tempIndex) {
                --tempIndex;
            }
            command.add((Command)new ReorderPartCommand((LogicSubpart)child.getModel(), (LogicDiagram)this.getHost().getModel(), oldIndex, tempIndex));
            ++i;
        }
        return command;
    }

    protected boolean isAncestor(EditPart source, EditPart target) {
        if (source == target) {
            return true;
        }
        if (target.getParent() != null) {
            return this.isAncestor(source, target.getParent());
        }
        return false;
    }
}

