/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NodeEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicElementEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicNodeEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.WireEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.requests.DropRequest;

public abstract class LogicEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener {
    private AccessibleEditPart acc;

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.getLogicSubpart().addPropertyChangeListener(this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new LogicElementEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolciy", (EditPolicy)new LogicNodeEditPolicy());
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new NodeEditPolicy());
    }

    protected abstract AccessibleEditPart createAccessible();

    protected ConnectionEditPart createConnection(Object wire) {
        WireEditPart wirepart = (WireEditPart)this.getRoot().getViewer().getEditPartRegistry().get(wire);
        if (wirepart == null) {
            wirepart = new WireEditPart();
            wirepart.setModel(wire);
        }
        return wirepart;
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        this.getLogicSubpart().removePropertyChangeListener(this);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    protected LogicSubpart getLogicSubpart() {
        return (LogicSubpart)this.getModel();
    }

    protected List getModelSourceConnections() {
        return this.getLogicSubpart().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getLogicSubpart().getTargetConnections();
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        Wire wire = (Wire)connEditPart.getModel();
        return this.getNodeFigure().getConnectionAnchor(wire.getSourceTerminal());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        Wire wire = (Wire)connEditPart.getModel();
        return this.getNodeFigure().getConnectionAnchor(wire.getTargetTerminal());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    protected final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return this.getNodeFigure().getConnectionAnchorName(c);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Children".equals(prop)) {
            this.refreshChildren();
        } else if ("inputs".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("outputs".equals(prop)) {
            this.refreshSourceConnections();
        } else if (prop.equals(LogicSubpart.ID_SIZE) || prop.equals(LogicSubpart.ID_LOCATION)) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        Point loc = this.getLogicSubpart().getLocation();
        Dimension size = this.getLogicSubpart().getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }
}

