/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.LogicContainerEditPart;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class LogicDiagramEditPart
extends LogicContainerEditPart
implements LayerConstants {
    private final List fEmptyHandles = new ArrayList();

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = LogicMessages.LogicDiagram_LabelText;
            }
        };
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolciy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setBorder((Border)new MarginBorder(5));
        f.setOpaque(true);
        return f;
    }

    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(int x, int y) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(int x, int y) {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (LogicDiagram.ID_ROUTER.equals(evt.getPropertyName())) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    protected void refreshVisuals() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (this.getLogicDiagram().getConnectionRouter().equals(LogicDiagram.ROUTER_MANUAL)) {
            FanRouter router = new FanRouter();
            router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            cLayer.setConnectionRouter((ConnectionRouter)router);
        } else {
            cLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        }
    }
}

