/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.AbstractCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.LogicElementEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class LEDEditPolicy
extends LogicElementEditPolicy {
    private static final String INCREMENT_REQUEST = "Increment";
    private static final String DECREMENT_REQUEST = "Decrement";

    public Command getCommand(Request request) {
        if (INCREMENT_REQUEST.equals(request.getType())) {
            return this.getIncrementDecrementCommand(true);
        }
        if (DECREMENT_REQUEST.equals(request.getType())) {
            return this.getIncrementDecrementCommand(false);
        }
        return super.getCommand(request);
    }

    protected Command getIncrementDecrementCommand(boolean type) {
        IncrementDecrementCommand command = new IncrementDecrementCommand(type);
        command.setChild((LogicSubpart)this.getHost().getModel());
        return command;
    }

    static class IncrementDecrementCommand
    extends AbstractCommand {
        boolean isIncrement = true;
        LED child = null;

        public IncrementDecrementCommand(boolean increment) {
            super(LogicMessages.IncrementDecrementCommand_LabelText);
            this.isIncrement = increment;
        }

        public void setChild(LogicSubpart child) {
            this.child = (LED)child;
        }

        public void execute() {
            int value = this.child.getValue();
            if (this.isIncrement) {
                if (value == 15) {
                    value = -1;
                }
                this.child.setValue(value + 1);
            } else {
                if (value == 0) {
                    value = 16;
                }
                this.child.setValue(value - 1);
            }
        }

        public void undo() {
            this.isIncrement = !this.isIncrement;
            this.execute();
            this.isIncrement = !this.isIncrement;
        }

        public void redo() {
            this.execute();
        }
    }
}

