/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.examples.logicdesigner.IncrementDecrementAction;
import org.eclipse.gef.examples.logicdesigner.LogicContextMenuProvider;
import org.eclipse.gef.examples.logicdesigner.LogicPlugin;
import org.eclipse.gef.examples.logicdesigner.TextTransferDropTargetListener;
import org.eclipse.gef.examples.logicdesigner.edit.GraphicalPartFactory;
import org.eclipse.gef.examples.logicdesigner.edit.TreePartFactory;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.ContextMenuProvider;
import org.eclipse.gef.ui.parts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class LogicEditor
extends GraphicalEditorWithPalette
implements CommandStackListener {
    private ContextMenuProvider contextMenuProvider;
    private KeyHandler sharedKeyHandler;
    private LogicDiagram logicDiagram = new LogicDiagram();
    private boolean savePreviouslyNeeded = false;
    private ResourceTracker resourceListener = new ResourceTracker();
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part != LogicEditor.this) {
                return;
            }
            if (!((FileEditorInput)LogicEditor.this.getEditorInput()).getFile().exists()) {
                Shell shell = LogicEditor.this.getSite().getShell();
                String title = GEFMessages.GraphicalEditor_FILE_DELETED_TITLE_UI;
                String message = GEFMessages.GraphicalEditor_FILE_DELETED_WITHOUT_SAVE_INFO;
                String[] buttons = new String[]{GEFMessages.GraphicalEditor_SAVE_BUTTON_UI, GEFMessages.GraphicalEditor_CLOSE_BUTTON_UI};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttons, 0);
                if (dialog.open() == 0) {
                    if (!LogicEditor.this.performSaveAs()) {
                        this.partActivated(part);
                    }
                } else {
                    LogicEditor.this.closeEditor(false);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LogicEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject e) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new FreeformGraphicalRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        viewer.setContextMenuProvider(this.getContextMenuProvider());
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
    }

    protected void createOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.getLogicDiagram());
        out.close();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        ((FileEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.createOutputStream(out);
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, progressMonitor);
            out.close();
            this.getCommandStack().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ui.stackview.CommandStackInspectorPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return new OutlinePage((EditPartViewer)new TreeViewer());
        }
        return super.getAdapter(type);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)0), this.getActionRegistry().getAction((Object)"delete"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"$direct edit"));
        }
        return this.sharedKeyHandler;
    }

    protected ContextMenuProvider getContextMenuProvider() {
        if (this.contextMenuProvider == null) {
            this.contextMenuProvider = new LogicContextMenuProvider((IEditorPart)this);
        }
        return this.contextMenuProvider;
    }

    protected LogicDiagram getLogicDiagram() {
        return this.logicDiagram;
    }

    protected PaletteRoot getPaletteRoot() {
        return LogicPlugin.createPalette();
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getLogicDiagram());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TextTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), (Transfer)TextTransfer.getInstance()));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
    }

    protected void initializeActionRegistry() {
        super.initializeActionRegistry();
        ActionRegistry registry = this.getActionRegistry();
        registry.registerAction((IAction)new IncrementDecrementAction((IEditorPart)this, true));
        registry.registerAction((IAction)new IncrementDecrementAction((IEditorPart)this, false));
        registry.registerAction((IAction)new DirectEditAction((IEditorPart)this));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 1));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 4));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 8));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 32));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 2));
        registry.registerAction((IAction)new AlignmentAction((IEditorPart)this, 16));
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().getUndoCommand() != null;
    }

    protected boolean performSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    LogicEditor.this.createOutputStream(out);
                    file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void setInput(IEditorInput input) {
        this.superSetInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            InputStream is = file.getContents(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.setLogicDiagram((LogicDiagram)ois.readObject());
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLogicDiagram(LogicDiagram diagram) {
        this.logicDiagram = diagram;
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.setTitle(file.getName());
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    class OutlinePage
    extends ContentOutlinePage {
        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)LogicEditor.super.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new TreePartFactory());
            this.getViewer().setContextMenuProvider(LogicEditor.this.getContextMenuProvider());
            this.getViewer().setKeyHandler(LogicEditor.this.getCommonKeyHandler());
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            super.dispose();
        }

        protected void hookOutlineViewer() {
            LogicEditor.super.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.getViewer().setContents((Object)LogicEditor.this.getLogicDiagram());
        }

        protected void unhookOutlineViewer() {
            LogicEditor.super.getSelectionSynchronizer().removeViewer(this.getViewer());
        }
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)LogicEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!LogicEditor.this.isDirty()) {
                        LogicEditor.this.closeEditor(false);
                    }
                } else {
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = LogicEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(this, newFile){
                        private final /* synthetic */ IFile val$newFile;
                        private final /* synthetic */ ResourceTracker this$1;
                        {
                            this.this$1 = resourceTracker;
                            this.val$newFile = iFile;
                        }

                        public void run() {
                            ResourceTracker.access$0(this.this$1).superSetInput((IEditorInput)new FileEditorInput(this.val$newFile));
                        }
                    });
                }
            }
            return false;
        }

        static /* synthetic */ LogicEditor access$0(ResourceTracker resourceTracker) {
            return resourceTracker.LogicEditor.this;
        }
    }
}

