/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.examples.logicdesigner.LogicDiagramFactory;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateLogicPage1
extends WizardNewFileCreationPage
implements MouseListener {
    private IWorkbench workbench;
    private static int exampleCount = 1;
    private Button model1 = null;
    private Button model2 = null;
    private int modelSelected = 1;

    public CreateLogicPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("sampleLogicPage1", selection);
        this.setTitle(LogicMessages.CreateLogicPage1_Title);
        this.setDescription(LogicMessages.CreateLogicPage1_Description);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/logic.gif"));
        this.workbench = aWorkbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("emptyModel" + exampleCount + ".logic");
        Composite composite = (Composite)this.getControl();
        new Label(composite, 0);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(LogicMessages.CreateLogicPage1_ModelNames_GroupName);
        group.setLayoutData((Object)new GridData(768));
        this.model1 = new Button((Composite)group, 16);
        this.model1.setText(LogicMessages.CreateLogicPage1_ModelNames_EmptyModelName);
        this.model1.addMouseListener((MouseListener)this);
        this.model1.setSelection(true);
        this.model2 = new Button((Composite)group, 16);
        this.model2.setText(LogicMessages.CreateLogicPage1_ModelNames_FourBitAdderModelName);
        this.model2.addMouseListener((MouseListener)this);
        new Label(composite, 0);
        this.setPageComplete(this.validatePage());
    }

    protected InputStream getInitialContents() {
        LogicDiagram ld = new LogicDiagram();
        if (this.modelSelected == 2) {
            ld = (LogicDiagram)LogicDiagramFactory.createLargeModel();
        }
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(ld);
            oos.flush();
            oos.close();
            baos.close();
            bais = new ByteArrayInputStream(baos.toByteArray());
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bais;
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                page.openEditor(newFile);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        ++exampleCount;
        return true;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Widget w = e.widget;
        if (w.equals(this.model1)) {
            this.modelSelected = 1;
            this.setFileName("emptyModel" + exampleCount + ".logic");
        }
        if (w.equals(this.model2)) {
            this.modelSelected = 2;
            this.setFileName("fourBitAdder" + exampleCount + ".logic");
        }
    }
}

