/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.editors.tag.ITagEditor;
import com.tssap.editors.tag.basic.BasicTagEditorFormattingStrategy;
import com.tssap.editors.xml.XmlEditor;
import com.tssap.editors.xml.util.IXmlParser;
import com.tssap.editors.xml.util.IXmlParserErrorHandler;
import com.tssap.editors.xml.util.XmlParserFactory;
import com.tssap.j2ee.model.ext.AdditionalDTDEntityResolver;
import com.tssap.j2ee.model.ext.ModelPlugin;
import com.tssap.j2ee.model.ext.dsaliases.dd.IDataSourceAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.impl.dom.DataSourceAliases;
import com.tssap.j2ee.model.ext.ear.dd.IApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ear.dd.impl.dom.ApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.impl.dom.EjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.impl.dom.PersistentEjbMap;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.j2ee.model.ext.library.dd.impl.dom.ProviderDescriptor;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.impl.dom.LogConfiguration;
import com.tssap.j2ee.model.ext.sda.dd.ISDA;
import com.tssap.j2ee.model.ext.sda.dd.impl.dom.SDA;
import com.tssap.j2ee.model.ext.web.dd.IWebJ2eeEngine;
import com.tssap.j2ee.model.ext.web.dd.impl.dom.WebJ2eeEngine;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParserHelper {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$XMLParserHelper == null ? (class$com$tssap$j2ee$model$ext$XMLParserHelper = XMLParserHelper.class$("com.tssap.j2ee.model.ext.XMLParserHelper")) : class$com$tssap$j2ee$model$ext$XMLParserHelper));
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$XMLParserHelper;

    public static IApplicationJ2eeEngine getApplicationJ2eeEngineForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("META-INF/application-j2ee-engine.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/application-j2ee-engine.dtd")) != null) {
            ApplicationJ2eeEngine destination = new ApplicationJ2eeEngine(document);
            return destination;
        }
        return null;
    }

    public static ILogConfiguration getLogConfigurationForProject(IProject project, String fileName) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile(fileName);
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/log-configuration.dtd")) != null) {
            LogConfiguration destination = new LogConfiguration(document);
            return destination;
        }
        return null;
    }

    public static IDataSourceAliases getDataSourceAliasesForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("META-INF/data-source-aliases.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/data-source-aliases.dtd")) != null) {
            DataSourceAliases destination = new DataSourceAliases(document);
            return destination;
        }
        return null;
    }

    public static ISDA getSDAForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("META-INF/sda-dd.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, null)) != null) {
            SDA destination = new SDA(document);
            return destination;
        }
        return null;
    }

    public static IProviderDescriptor getProviderDescriptorForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("server/provider.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/library.provider.dtd")) != null) {
            ProviderDescriptor destination = new ProviderDescriptor(document);
            return destination;
        }
        return null;
    }

    public static IWebJ2eeEngine getWebJ2eeEngineForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("WEB-INF/web-j2ee-engine.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "WEB-INF/web-j2ee-engine.dtd")) != null) {
            WebJ2eeEngine destination = new WebJ2eeEngine(document);
            return destination;
        }
        return null;
    }

    public static IEjbJ2eeEngine getEjbJ2eeEngineForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("META-INF/ejb-j2ee-engine.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/ejb-j2ee-engine.dtd")) != null) {
            EjbJ2eeEngine destination = new EjbJ2eeEngine(document);
            return destination;
        }
        return null;
    }

    public static IPersistentEjbMap getPersistentEjbMapForProject(IProject project) {
        org.w3c.dom.Document document;
        IFile file = project.getProject().getFile("META-INF/persistent.xml");
        if (file != null && file.exists() && (document = XMLParserHelper.getContentAsDom(file, "META-INF/persistent.dtd")) != null) {
            PersistentEjbMap destination = new PersistentEjbMap(document);
            return destination;
        }
        return null;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        return new DocumentBuilderFactoryImpl();
    }

    public static DocumentBuilder createNewDocumentBuilder() throws ParserConfigurationException {
        return XMLParserHelper.createDocumentBuilderFactory().newDocumentBuilder();
    }

    public static org.w3c.dom.Document getContentAsDom(IFile file, String dtdFileName) {
        String METHOD = "getContentAsDom(file, dtdFileName)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "file = " + file + ", dtdFileName = " + dtdFileName);
        }
        if (!file.exists()) {
            return null;
        }
        IXmlParser xmlParser = XmlParserFactory.getNextParser();
        AdditionalDTDEntityResolver entityResolver = null;
        LoggingXMLParserErrorHandler xmlErrorHandler = null;
        if (dtdFileName != null) {
            entityResolver = new AdditionalDTDEntityResolver((Plugin)ModelPlugin.getDefault(), "templates/", dtdFileName);
            xmlErrorHandler = new LoggingXMLParserErrorHandler();
        }
        org.w3c.dom.Document document = null;
        try {
            InputStream inputStream = file.getContents();
            document = xmlParser.parseAsDom(inputStream, (IXmlParserErrorHandler)xmlErrorHandler, (EntityResolver)entityResolver);
        }
        catch (Exception e) {
            TRACER.error(METHOD, "Can not read XML: " + e.toString(), (Throwable)e);
        }
        return document;
    }

    public static void setDomAsContent(org.w3c.dom.Document document, IFile file) {
        String METHOD = "setDomAsContent(document, file)";
        if (TRACER.path()) {
            TRACER.path(METHOD, "document = " + document + ", file = " + file);
        }
        IXmlParser xmlParser = XmlParserFactory.getNextParser();
        try {
            String content = xmlParser.serializeDom(document);
            content = XMLParserHelper.formatXml(content);
            ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
            if (!file.exists()) {
                file.create((InputStream)contentStream, true, null);
            } else {
                file.setContents((InputStream)contentStream, true, true, null);
            }
        }
        catch (Exception e) {
            TRACER.error(METHOD, "Can not write XML: " + e.toString(), (Throwable)e);
        }
    }

    public static String formatXml(String xml) {
        Document document = new Document(xml);
        Region region = new Region(0, document.getLength());
        ContentFormatter formatter = new ContentFormatter();
        formatter.setFormattingStrategy((IFormattingStrategy)new BasicTagEditorFormattingStrategy((ITagEditor)new XmlEditor()), "__dftl_partition_content_type");
        formatter.format((IDocument)document, (IRegion)region);
        return document.get();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LoggingXMLParserErrorHandler
    implements IXmlParserErrorHandler {
        public void error(SAXParseException e) throws SAXException {
            String METHOD = "error(saxParseException)";
            TRACER.error(METHOD, "Can not parse XML: " + ((SAXException)e).toString(), (Throwable)e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            String METHOD = "fatalError(saxParseException)";
            TRACER.error(METHOD, "Can not parse XML: " + ((SAXException)e).toString(), (Throwable)e);
        }

        public void warning(SAXParseException e) throws SAXException {
            String METHOD = "warning(saxParseException)";
            TRACER.error(METHOD, "Can not parse XML: " + ((SAXException)e).toString(), (Throwable)e);
        }

        public void reset() {
        }
    }
}

