/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class TypeSignatureWrapper {
    private IType _enclosingType;
    private String _typeSignature;
    private int _arrayCount;
    private String _readableFormat;
    private String _package;
    private String _class;
    private String _datatype;

    public TypeSignatureWrapper(IType enclosingType, String typeSignature) throws Exception {
        this._enclosingType = enclosingType;
        this._typeSignature = typeSignature;
        this._arrayCount = Signature.getArrayCount((String)typeSignature);
        String typeWithoutArray = Signature.getElementType((String)typeSignature);
        if (typeWithoutArray.length() != 1) {
            String typeWithoutSignature = Signature.toString((String)typeWithoutArray);
            if (enclosingType != null) {
                String[][] resolvedType = enclosingType.resolveType(typeWithoutSignature);
                if (resolvedType == null || resolvedType.length == 0) {
                    throw new Exception("The class " + typeWithoutSignature + " can not be resolved in the enclosing type " + enclosingType);
                }
                if (resolvedType.length > 1) {
                    throw new Exception("The class " + typeWithoutSignature + " can not be resolved uniquely in the enclosing type " + enclosingType + ". Instead there are " + resolvedType.length + " possibilities.");
                }
                this._package = resolvedType[0][0];
                this._class = resolvedType[0][1];
            } else {
                int index = typeWithoutSignature.lastIndexOf(46);
                if (index >= 0) {
                    this._package = typeWithoutSignature.substring(0, index);
                    this._class = typeWithoutSignature.substring(index + 1);
                } else {
                    this._package = "";
                    this._class = typeWithoutSignature;
                }
            }
        } else {
            this._datatype = Signature.toString((String)typeWithoutArray);
        }
        StringBuffer readableFormatBuffer = new StringBuffer();
        if (this._datatype != null) {
            readableFormatBuffer.append(this._datatype);
        } else {
            readableFormatBuffer.append(this.getFullClassName());
        }
        int i = 0;
        while (i < this._arrayCount) {
            readableFormatBuffer.append("[]");
            ++i;
        }
        this._readableFormat = readableFormatBuffer.toString();
    }

    public static TypeSignatureWrapper getClassWrapper(String className) throws Exception {
        TypeSignatureWrapper result = new TypeSignatureWrapper(null, "L" + className + ";");
        return result;
    }

    public final IType getEnclosingType() {
        return this._enclosingType;
    }

    public final String getTypeSignature() {
        return this._typeSignature;
    }

    public final int getArrayCount() {
        return this._arrayCount;
    }

    public final String getDatatype() {
        return this._datatype;
    }

    public final String getPackageName() {
        return this._package;
    }

    public final String getClassName() {
        return this._class;
    }

    public final String getFullClassName() {
        return this._package.length() > 0 ? this._package + '.' + this._class : this._class;
    }

    public final boolean isDatatype() {
        return this._datatype != null;
    }

    public final boolean isClass() {
        return this._datatype == null;
    }

    public final boolean isDatatypeClass() {
        return this.isClass() && this._package.startsWith("java.");
    }

    public final boolean isSimpleType() {
        return this.getArrayCount() != 0 || this.isDatatype() || this.isDatatypeClass();
    }

    public final String getReadableFormat() {
        return this._readableFormat;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeSignatureWrapper)) {
            return false;
        }
        TypeSignatureWrapper other = (TypeSignatureWrapper)o;
        return this.getReadableFormat().equals(other.getReadableFormat());
    }

    public int hashCode() {
        return this.getReadableFormat().hashCode();
    }

    public String toString() {
        return this.getReadableFormat();
    }
}

