/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.Util;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class SemanticCheckerHelper {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$Util == null ? (class$com$tssap$j2ee$model$ext$Util = SemanticCheckerHelper.class$("com.tssap.j2ee.model.ext.Util")) : class$com$tssap$j2ee$model$ext$Util));
    private static final String SEMANTIC_MARKER = "com.tssap.j2ee.model.ext.semanticmarker";
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$Util;

    public static void addMarkerEmptyValueForTagIgnoreParent(IFile file, String parentTagName, String tagName) {
        SemanticCheckerHelper.addMarker(file, "The value for the tag <" + tagName + "> below <" + parentTagName + "> is empty. Because of this the complete parent-tag <" + parentTagName + "> will be ignored.", -1, 1, false);
    }

    public static void addMarkerEmptyValueForTagIsError(IFile file, String parentTagName, String tagName) {
        SemanticCheckerHelper.addMarker(file, "The value for the tag <" + tagName + "> below <" + parentTagName + "> must not be empty", -1, 2, false);
    }

    public static void addMarkerDuplicateValueForTagIsError(IFile file, String parentTagName, String tagName, String value) {
        SemanticCheckerHelper.addMarker(file, "The value '" + value + "' for the tag <" + tagName + "> below <" + parentTagName + "> is not unique", -1, 2, false);
    }

    public static void removeAllMarkers(IFile file) {
        String METHOD = "removeAllMarkers()";
        try {
            if (file != null) {
                file.deleteMarkers(SEMANTIC_MARKER, true, 2);
            }
        }
        catch (CoreException e) {
            TRACER.error("removeAllMarkers()", "Can not remove all markers for file " + file + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void addMarker(IFile file, String message, int lineNumber, int severity, boolean fatal) {
        String METHOD = "addMarker()";
        try {
            if (file != null) {
                IMarker marker = file.createMarker(SEMANTIC_MARKER);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                if (lineNumber >= 0) {
                    marker.setAttribute("lineNumber", lineNumber);
                }
            }
        }
        catch (CoreException e) {
            TRACER.error("addMarker()", "Can not remove all markers for file " + file + " with message '" + message + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public static void addMarkerIfValueNotInList(IFile file, String parentTagName, String tagName, String value, String[] allowedValues) {
        if (!Util.isObjectInArray(value, allowedValues)) {
            SemanticCheckerHelper.addMarker(file, "The value '" + value + "' for the tag <" + tagName + "> below <" + parentTagName + "> is not valid. It must be one of " + Util.toString(allowedValues) + ".", -1, 2, false);
        }
    }

    public static void addMarkerIfValueNotInteger(IFile file, String parentTagName, String tagName, String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception e) {
            SemanticCheckerHelper.addMarker(file, "The value '" + value + "' for the tag <" + tagName + "> below <" + parentTagName + "> must be an integer", -1, 2, false);
        }
    }

    public static void addMarkerIfValueNotIntegerGreaterMin(IFile file, String parentTagName, String tagName, String value, int min) {
        try {
            int i = Integer.parseInt(value);
            if (i < min) {
                throw new Exception("The number is below the minimum");
            }
        }
        catch (Exception e) {
            SemanticCheckerHelper.addMarker(file, "The value '" + value + "' for the tag <" + tagName + "> below <" + parentTagName + "> must be an integer with (" + min + " <= n)", -1, 2, false);
        }
    }

    public static void addMarkerIfValueNotIntegerInInterval(IFile file, String parentTagName, String tagName, String value, int min, int max) {
        try {
            int i = Integer.parseInt(value);
            if (i < min || i > max) {
                throw new Exception("The number is not in the interval");
            }
        }
        catch (Exception e) {
            SemanticCheckerHelper.addMarker(file, "The value '" + value + "' for the tag <" + tagName + "> below <" + parentTagName + "> must be an integer with (" + min + " <= n <= " + max + ")", -1, 2, false);
        }
    }

    public static void addMarkerEmptyValueForAttributeIsError(IFile file, String tagName, String attributeName) {
        SemanticCheckerHelper.addMarker(file, "The value for the attribute <" + attributeName + "> from <" + tagName + "> tag must not be empty.", -1, 2, false);
    }

    public static void addMarkerIfAttrValueNotInteger(IFile file, String tagName, String value, String attributeName) {
        if (value.equals("") || value == null) {
            return;
        }
        try {
            Integer.parseInt(value);
        }
        catch (Exception e) {
            SemanticCheckerHelper.addMarker(file, "The value '" + value + "' of the attribute <" + attributeName + "> from <" + tagName + "> tag must be an integer.", -1, 2, false);
        }
    }

    public static void addMarkerIfValueNotJavaClass(IFile file, String parentTagName, String tagName, String tagValue) {
        IStatus status = JavaConventions.validateJavaTypeName((String)tagValue);
        if (status != null && status.getSeverity() == 4) {
            SemanticCheckerHelper.addMarker(file, "The value '" + tagValue + "' for the tag <" + tagName + "> below <" + parentTagName + "> must be a class name.", -1, 2, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

