/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.j2ee.model.ext.web.dd.ICode;
import com.tssap.j2ee.model.ext.web.dd.ICookie;
import com.tssap.j2ee.model.ext.web.dd.ICookieConfig;
import com.tssap.j2ee.model.ext.web.dd.IEjbLocalRef;
import com.tssap.j2ee.model.ext.web.dd.IEjbRef;
import com.tssap.j2ee.model.ext.web.dd.IFailOverAlert;
import com.tssap.j2ee.model.ext.web.dd.IGroupName;
import com.tssap.j2ee.model.ext.web.dd.ILoginModule;
import com.tssap.j2ee.model.ext.web.dd.ILoginModuleConfiguration;
import com.tssap.j2ee.model.ext.web.dd.ILoginModuleStack;
import com.tssap.j2ee.model.ext.web.dd.IMaxAge;
import com.tssap.j2ee.model.ext.web.dd.IMaxSessions;
import com.tssap.j2ee.model.ext.web.dd.IMessageTimeout;
import com.tssap.j2ee.model.ext.web.dd.IName;
import com.tssap.j2ee.model.ext.web.dd.IOption;
import com.tssap.j2ee.model.ext.web.dd.IOptions;
import com.tssap.j2ee.model.ext.web.dd.IResourceEnvRef;
import com.tssap.j2ee.model.ext.web.dd.IResourceRef;
import com.tssap.j2ee.model.ext.web.dd.IResponseStatus;
import com.tssap.j2ee.model.ext.web.dd.ISecurityRoleMap;
import com.tssap.j2ee.model.ext.web.dd.IServerComponentRef;
import com.tssap.j2ee.model.ext.web.dd.IServerRoleName;
import com.tssap.j2ee.model.ext.web.dd.IType;
import com.tssap.j2ee.model.ext.web.dd.IUserName;
import com.tssap.j2ee.model.ext.web.dd.IWebJ2eeEngine;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;

public class SapWarSemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapWarSemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapWarSemanticChecker = SapWarSemanticChecker.class$("com.tssap.j2ee.model.ext.SapWarSemanticChecker")) : class$com$tssap$j2ee$model$ext$SapWarSemanticChecker));
    public static final String[] ALLOWED_TYPE_VALUES = new String[]{"SESSION", "APPLICATION"};
    public static final int[] STANDARD_CODES = new int[]{200, 201, 202, 203, 204, 205, 206, 300, 301, 302, 303, 304, 305, 306, 307, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 500, 501, 502, 503, 504, 505};
    public static final String[] ALLOWED_REFERENCE_TYPES = new String[]{"service", "interface"};
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapWarSemanticChecker;

    public static void semanticCheck(IFile file, IWebJ2eeEngine source) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            SapWarSemanticChecker.semanticCheckOfReferences(file, source);
            SapWarSemanticChecker.semanticCheckOfSecurityRoleMaps(file, source);
            SapWarSemanticChecker.semanticCheckOfCookies(file, source);
            SapWarSemanticChecker.semanticCheckOfResponseStatus(file, source);
            SapWarSemanticChecker.semanticCheckOfLoginModule(file, source);
            SapWarSemanticChecker.semanticCheckOfNumbers(file, source);
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    public static void semanticCheckOfReferences(IFile file, IWebJ2eeEngine source) {
        IServerComponentRef[] serverComponentRef = source.getServerComponentRefs();
        String parentTagName = "server-component-ref";
        HashSet<String> valueSet = new HashSet<String>();
        int k = 0;
        while (k < serverComponentRef.length) {
            String name = serverComponentRef[k].getName().getValue();
            String tagName = "name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            String jndiName = serverComponentRef[k].getJndiName().getValue();
            tagName = "jndi-name";
            if (jndiName == null || jndiName.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
            }
            String type = serverComponentRef[k].getType().getValue();
            tagName = "type";
            SemanticCheckerHelper.addMarkerIfValueNotInList(file, parentTagName, tagName, type, ALLOWED_REFERENCE_TYPES);
            ++k;
        }
        IEjbRef[] ejbRef = source.getEjbRefs();
        parentTagName = "ejb-ref";
        valueSet = new HashSet();
        int k2 = 0;
        while (k2 < ejbRef.length) {
            String name = ejbRef[k2].getEjbRefName().getValue();
            String tagName = "ejb-ref-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            String jndiName = ejbRef[k2].getJndiName().getValue();
            tagName = "jndi-name";
            if (jndiName == null || jndiName.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
            }
            ++k2;
        }
        IEjbLocalRef[] ejbLocalRef = source.getEjbLocalRefs();
        parentTagName = "ejb-local-ref";
        valueSet = new HashSet();
        int k3 = 0;
        while (k3 < ejbLocalRef.length) {
            String name = ejbLocalRef[k3].getEjbRefName().getValue();
            String tagName = "ejb-ref-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            String jndiName = ejbLocalRef[k3].getJndiName().getValue();
            tagName = "jndi-name";
            if (jndiName == null || jndiName.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
            }
            ++k3;
        }
        IResourceRef[] resourceRef = source.getResourceRefs();
        parentTagName = "resource-ref";
        valueSet = new HashSet();
        int k4 = 0;
        while (k4 < resourceRef.length) {
            String name = resourceRef[k4].getResRefName().getValue();
            String tagName = "res-ref-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            String jndiName = resourceRef[k4].getResLink().getValue();
            tagName = "res-link";
            if (jndiName == null || jndiName.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
            }
            ++k4;
        }
        IResourceEnvRef[] resourceEnvRef = source.getResourceEnvRefs();
        parentTagName = "resource-env-ref";
        valueSet = new HashSet();
        int k5 = 0;
        while (k5 < resourceEnvRef.length) {
            String name = resourceEnvRef[k5].getResourceEnvRefName().getValue();
            String tagName = "resource-env-ref-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            String jndiName = resourceEnvRef[k5].getJndiName().getValue();
            tagName = "jndi-name";
            if (jndiName == null || jndiName.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
            }
            ++k5;
        }
    }

    public static void semanticCheckOfSecurityRoleMaps(IFile file, IWebJ2eeEngine source) {
        ISecurityRoleMap[] securityRoleMap = source.getSecurityRoleMaps();
        String parentTagName = "security-role-map";
        HashSet<String> valueSet = new HashSet<String>();
        int k = 0;
        while (k < securityRoleMap.length) {
            String name = securityRoleMap[k].getRoleName().getValue();
            String tagName = "role-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            IServerRoleName serverRoleName = securityRoleMap[k].getServerRoleName();
            if (serverRoleName != null) {
                name = serverRoleName.getValue();
                tagName = "server-role-name";
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                }
            }
            IUserName[] userName = securityRoleMap[k].getUserNames();
            tagName = "user-name";
            int j = 0;
            while (j < userName.length) {
                name = userName[j].getValue();
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                }
                ++j;
            }
            IGroupName[] groupName = securityRoleMap[k].getGroupNames();
            tagName = "group-name";
            int j2 = 0;
            while (j2 < groupName.length) {
                name = groupName[j2].getValue();
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                }
                ++j2;
            }
            ++k;
        }
    }

    public static void semanticCheckOfCookies(IFile file, IWebJ2eeEngine source) {
        ICookieConfig cookieConfig = source.getCookieConfig();
        if (cookieConfig != null) {
            HashSet<String> valueSet = new HashSet<String>();
            ICookie[] cookie = cookieConfig.getCookies();
            int i = 0;
            while (i < cookie.length) {
                SemanticCheckerHelper.addMarkerIfValueNotInList(file, "cookie", "type", cookie[i].getType().getValue(), ALLOWED_TYPE_VALUES);
                IType type = cookie[i].getType();
                String name = type.getValue();
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, "cookie", "type", name);
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfResponseStatus(IFile file, IWebJ2eeEngine source) {
        HashSet<String> valueSet = new HashSet<String>();
        String parentTagName = "response-status";
        String tagName = "code";
        IResponseStatus[] responseStatus = source.getResponseStatuss();
        int i = 0;
        while (i < responseStatus.length) {
            ICode code = responseStatus[i].getCode();
            if (code != null) {
                String name = code.getValue();
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
                try {
                    int c = Integer.parseInt(name);
                    int z = 0;
                    while (z < STANDARD_CODES.length) {
                        if (STANDARD_CODES[z] == c) {
                            SemanticCheckerHelper.addMarker(file, "The value '" + c + "' for the tag <" + tagName + "> below <" + parentTagName + "> is not allowed, because it is a standard HTTP response code, which must not be overwritten.", -1, 2, false);
                            break;
                        }
                        ++z;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void semanticCheckOfLoginModule(IFile file, IWebJ2eeEngine source) {
        ILoginModuleStack loginModuleStack;
        ILoginModuleConfiguration loginModuleConfiguration = source.getLoginModuleConfiguration();
        if (loginModuleConfiguration != null && (loginModuleStack = loginModuleConfiguration.getLoginModuleStack()) != null) {
            ILoginModule[] loginModule = loginModuleStack.getLoginModules();
            int i = 0;
            while (i < loginModule.length) {
                IOptions options = loginModule[i].getOptions();
                if (options != null) {
                    HashSet<String> valueSet = new HashSet<String>();
                    String parentTagName = "option";
                    String tagName = "name";
                    IOption[] option = options.getOptions();
                    int k = 0;
                    while (k < option.length) {
                        String value;
                        boolean elementIsNew;
                        IName name = option[k].getName();
                        if (name != null && !(elementIsNew = valueSet.add(value = name.getValue()))) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, value);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfNumbers(IFile file, IWebJ2eeEngine source) {
        ICookieConfig cookieConfig;
        IMaxSessions maxSessions;
        IMessageTimeout messageTimeout;
        IResponseStatus[] responseStatus = source.getResponseStatuss();
        int i = 0;
        while (i < responseStatus.length) {
            ICode code = responseStatus[i].getCode();
            if (code != null) {
                SemanticCheckerHelper.addMarkerIfValueNotIntegerInInterval(file, "response-status", "code", code.getValue(), 101, 999);
            }
            ++i;
        }
        IFailOverAlert failOverAlert = source.getFailOverAlert();
        if (failOverAlert != null && (messageTimeout = failOverAlert.getMessageTimeout()) != null) {
            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "fail-over-alert", "message-timeout", messageTimeout.getValue(), 1);
        }
        if ((maxSessions = source.getMaxSessions()) != null) {
            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "web-j2ee-engine", "max-sessions", maxSessions.getValue(), 1);
        }
        if ((cookieConfig = source.getCookieConfig()) != null) {
            ICookie[] cookie = cookieConfig.getCookies();
            int i2 = 0;
            while (i2 < cookie.length) {
                IMaxAge maxAge = cookie[i2].getMaxAge();
                if (maxAge != null) {
                    SemanticCheckerHelper.addMarkerIfValueNotInteger(file, "cookie", "max-age", maxAge.getValue());
                }
                ++i2;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

