/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.j2ee.model.ext.log.dd.IAssociatedDestinations;
import com.tssap.j2ee.model.ext.log.dd.IDestinationRef;
import com.tssap.j2ee.model.ext.log.dd.IFormatterRef;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.ILogControllers;
import com.tssap.j2ee.model.ext.log.dd.ILogDestination;
import com.tssap.j2ee.model.ext.log.dd.ILogDestinations;
import com.tssap.j2ee.model.ext.log.dd.ILogFilter;
import com.tssap.j2ee.model.ext.log.dd.ILogFilters;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatter;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatters;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;

public class SapLogSemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapLogSemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapLogSemanticChecker = SapLogSemanticChecker.class$("com.tssap.j2ee.model.ext.SapLogSemanticChecker")) : class$com$tssap$j2ee$model$ext$SapLogSemanticChecker));
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapLogSemanticChecker;

    public static void semanticCheck(IFile file, ILogConfiguration source) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            HashSet formatterNames = SapLogSemanticChecker.semanticCheckOfFormatters(file, source);
            SapLogSemanticChecker.semanticCheckOfDestinations(file, source, formatterNames);
            SapLogSemanticChecker.semanticCheckOfControllers(file, source);
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    public static HashSet semanticCheckOfFormatters(IFile file, ILogConfiguration source) {
        ILogFormatter[] formatter;
        HashSet<String> valueSet = new HashSet<String>();
        ILogFormatters formatters = source.getLogFormatters();
        if (formatters != null && (formatter = formatters.getLogFormatters()) != null) {
            int i = 0;
            while (i < formatter.length) {
                String name = formatter[i].getAttribName();
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, "log-configuration", "log-formatter", name);
                }
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForAttributeIsError(file, "log-formatter", "name");
                }
                ++i;
            }
        }
        return valueSet;
    }

    public static void semanticCheckOfDestinations(IFile file, ILogConfiguration source, HashSet formatterNames) {
        ILogDestination[] destination;
        ILogDestinations destinations = source.getLogDestinations();
        if (destinations != null && (destination = destinations.getLogDestinations()) != null) {
            int i = 0;
            while (i < destination.length) {
                ILogFilter[] filter;
                ILogFilters logFilters;
                String nameToFind;
                String name = destination[i].getAttribName();
                String tagName = "log-destination";
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForAttributeIsError(file, tagName, "name");
                }
                String limit = destination[i].getAttribLimit();
                SemanticCheckerHelper.addMarkerIfAttrValueNotInteger(file, tagName, limit, "limit");
                String count = destination[i].getAttribCount();
                SemanticCheckerHelper.addMarkerIfAttrValueNotInteger(file, tagName, count, "count");
                IFormatterRef formatterRef = destination[i].getFormatterRef();
                if (formatterRef != null && !formatterNames.contains(nameToFind = formatterRef.getAttribName())) {
                    SemanticCheckerHelper.addMarker(file, "The attribute 'name' with the value '" + nameToFind + "' for the tag <" + "formatter-ref" + "> below <" + "log-destination" + "> is not valid. It must be one of the <log-formatter>, which are defined in this file.", -1, 2, false);
                }
                if ((logFilters = destination[i].getLogFilters()) != null && (filter = logFilters.getLogFilters()) != null) {
                    int j = 0;
                    while (j < filter.length) {
                        String type = filter[j].getAttribType();
                        SemanticCheckerHelper.addMarkerIfValueNotJavaClass(file, tagName, "log-filter", type);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfControllers(IFile file, ILogConfiguration source) {
        ILogControllers controllers = source.getLogControllers();
        if (controllers != null) {
            HashSet<String> valueSet = new HashSet<String>();
            ILogController[] controller = controllers.getLogControllers();
            if (controller != null) {
                int i = 0;
                while (i < controller.length) {
                    IAssociatedDestinations associatedDestinations;
                    ILogFilters logFilters;
                    String name = controller[i].getAttribName();
                    boolean elementIsNew = valueSet.add(name);
                    if (!elementIsNew) {
                        SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, "log-configuration", "log-controller", name);
                    }
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForAttributeIsError(file, "log-controller", "name");
                    }
                    if ((logFilters = controller[i].getLogFilters()) != null) {
                        HashSet<String> filterValueSet = new HashSet<String>();
                        ILogFilter[] logFilter = logFilters.getLogFilters();
                        int k = 0;
                        while (k < logFilter.length) {
                            name = logFilter[k].getAttribType();
                            SemanticCheckerHelper.addMarkerIfValueNotJavaClass(file, "log-controller", "log-filter", name);
                            elementIsNew = filterValueSet.add(name);
                            if (!elementIsNew) {
                                SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, "log-filters", "log-filter", name);
                            }
                            ++k;
                        }
                    }
                    if ((associatedDestinations = controller[i].getAssociatedDestinations()) != null) {
                        HashSet<String> destinationsValueSet = new HashSet<String>();
                        IDestinationRef[] destinationRef = associatedDestinations.getDestinationRefs();
                        int k = 0;
                        while (k < destinationRef.length) {
                            name = destinationRef[k].getAttribName();
                            elementIsNew = destinationsValueSet.add(name);
                            if (!elementIsNew) {
                                SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, "associated-destinations", "destination-ref", name);
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

