/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.log.dd.IAnonymousDestination;
import com.tssap.j2ee.model.ext.log.dd.IAssociatedDestinations;
import com.tssap.j2ee.model.ext.log.dd.IDestinationRef;
import com.tssap.j2ee.model.ext.log.dd.ILogConfiguration;
import com.tssap.j2ee.model.ext.log.dd.ILogController;
import com.tssap.j2ee.model.ext.log.dd.ILogControllers;
import com.tssap.j2ee.model.ext.log.dd.ILogDestination;
import com.tssap.j2ee.model.ext.log.dd.ILogDestinations;
import com.tssap.j2ee.model.ext.log.dd.ILogFilter;
import com.tssap.j2ee.model.ext.log.dd.ILogFilters;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatter;
import com.tssap.j2ee.model.ext.log.dd.ILogFormatters;

public class SapLogConfigurationDefaultFactory {
    public static final String DEFAULT_FORMATTER_ENTRY_NAME = "DefaultFormatter";
    public static final String DEFAULT_FORMATTER_TYPE = "ListFormatter";
    public static final String DEFAULT_DESTINATION_NAME = "DefaultDestination";
    public static final String DEFAULT_DESTINATION_TYPE = "FileLog";
    public static final String DEFAULT_LOGFILTER_NAME = "com.sap.test.MyFilter";
    public static final String DEFAULT_CONTROLLER_NAME = "DefaultController";
    public static final String DEDAULT_DESTINATION_REF_NAME = "<choose name>";
    public static final String DEDAULT_DESTINATION_REF_TYPE = "LOG";
    public static final String DEDAULT_ANONYMOUS_REF_TYPE = "LOG";
    public static final String DEDAULT_DESTINATION_ANONYM_TYPE = "ConsoleLog";

    public static ILogFormatter createFormatter(ILogFormatters formatters) throws J2eeCreateException {
        ILogFormatter formatter = formatters.createLogFormatter(null);
        formatter.setAttribName(DEFAULT_FORMATTER_ENTRY_NAME);
        formatter.setAttribType(DEFAULT_FORMATTER_TYPE);
        return formatter;
    }

    public static ILogDestination createDestination(ILogDestinations destinations) throws J2eeCreateException {
        ILogDestination destination = destinations.createLogDestination(null);
        destination.setAttribName(DEFAULT_DESTINATION_NAME);
        destination.setAttribType(DEFAULT_DESTINATION_TYPE);
        return destination;
    }

    public static ILogFilter createLogFilter(ILogDestination destination) throws J2eeCreateException {
        ILogFilters logFilters = destination.getLogFilters();
        if (logFilters == null) {
            logFilters = destination.createLogFilters(null);
        }
        ILogFilter logFilter = logFilters.createLogFilter(null);
        logFilter.setAttribType(DEFAULT_LOGFILTER_NAME);
        return logFilter;
    }

    public static ILogFilter createLogFilter(ILogController controller) throws J2eeCreateException {
        ILogFilters logFilters = controller.getLogFilters();
        if (logFilters == null) {
            logFilters = controller.createLogFilters(null);
        }
        ILogFilter logFilter = logFilters.createLogFilter(null);
        logFilter.setAttribType(DEFAULT_LOGFILTER_NAME);
        return logFilter;
    }

    public static ILogController createController(ILogControllers controllers) throws J2eeCreateException {
        ILogController controller = controllers.createLogController(null);
        controller.setAttribName(DEFAULT_CONTROLLER_NAME);
        return controller;
    }

    public static IDestinationRef createDestinationRef(ILogController controller) throws J2eeCreateException {
        IAssociatedDestinations assDest = controller.getAssociatedDestinations();
        IDestinationRef destRef = null;
        if (assDest == null) {
            assDest = controller.createAssociatedDestinations(null);
        }
        destRef = assDest.createDestinationRef(null);
        destRef.setAttribName(DEDAULT_DESTINATION_REF_NAME);
        destRef.setAttribAssociationType("LOG");
        return destRef;
    }

    public static IAnonymousDestination createAnonymousDestination(ILogController controller) throws J2eeCreateException {
        IAssociatedDestinations assDest = controller.getAssociatedDestinations();
        IAnonymousDestination dest = null;
        if (assDest == null) {
            assDest = controller.createAssociatedDestinations(null);
        }
        dest = assDest.createAnonymousDestination(null);
        dest.setAttribType(DEDAULT_DESTINATION_ANONYM_TYPE);
        dest.setAttribAssociationType("LOG");
        return dest;
    }

    public static void removeFormatterAndEmptyParents(ILogConfiguration logConfiguration, ILogFormatter formatter) {
        if (logConfiguration.getLogFormatters() != null) {
            logConfiguration.getLogFormatters().removeLogFormatter(formatter);
            if (logConfiguration.getLogFormatters().getLogFormatters().length == 0) {
                logConfiguration.removeLogFormatters();
            }
        }
    }

    public static void removeDestinationAndEmptyParents(ILogConfiguration logConfiguration, ILogDestination destination) {
        if (logConfiguration.getLogDestinations() != null) {
            logConfiguration.getLogDestinations().removeLogDestination(destination);
            if (logConfiguration.getLogDestinations().getLogDestinations().length == 0) {
                logConfiguration.removeLogDestinations();
            }
        }
    }

    public static void removeLogFilterAndEmptyParents(ILogConfiguration logConfiguration, ILogDestination destination, ILogFilter logFilter) {
        if (destination.getLogFilters() != null) {
            destination.getLogFilters().removeLogFilter(logFilter);
            if (destination.getLogFilters().getLogFilters().length == 0) {
                destination.removeLogFilters();
            }
        }
    }

    public static void removeControllerAndEmptyParents(ILogConfiguration logConfiguration, ILogController controller) {
        if (logConfiguration.getLogControllers() != null) {
            logConfiguration.getLogControllers().removeLogController(controller);
            if (logConfiguration.getLogControllers().getLogControllers().length == 0) {
                logConfiguration.removeLogControllers();
            }
        }
    }

    public static void removeLogFilterAndEmptyParents(ILogController controller, ILogFilter logFilter) {
        if (controller.getLogFilters() != null) {
            controller.getLogFilters().removeLogFilter(logFilter);
            if (controller.getLogFilters().getLogFilters().length == 0) {
                controller.removeLogFilters();
            }
        }
    }

    public static void removeDestinationRefAndEmptyParents(ILogController controller, IDestinationRef destRef) {
        if (controller.getAssociatedDestinations() != null) {
            controller.getAssociatedDestinations().removeDestinationRef(destRef);
            if (controller.getAssociatedDestinations().getDestinationRefs().length == 0 && controller.getAssociatedDestinations().getAnonymousDestinations().length == 0) {
                controller.removeAssociatedDestinations();
            }
        }
    }

    public static void removeAnonymousDestAndEmptyParents(ILogController controller, IAnonymousDestination dest) {
        if (controller.getAssociatedDestinations() != null) {
            controller.getAssociatedDestinations().removeAnonymousDestination(dest);
            if (controller.getAssociatedDestinations().getDestinationRefs().length == 0 && controller.getAssociatedDestinations().getAnonymousDestinations().length == 0) {
                controller.removeAssociatedDestinations();
            }
        }
    }
}

