/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.j2ee.model.ext.library.dd.IComponentName;
import com.tssap.j2ee.model.ext.library.dd.IDisplayName;
import com.tssap.j2ee.model.ext.library.dd.IMajorVersion;
import com.tssap.j2ee.model.ext.library.dd.IMicroVersion;
import com.tssap.j2ee.model.ext.library.dd.IMinorVersion;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.j2ee.model.ext.library.dd.IProviderName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;

public class SapLibrarySemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapLibrarySemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapLibrarySemanticChecker = SapLibrarySemanticChecker.class$("com.tssap.j2ee.model.ext.SapLibrarySemanticChecker")) : class$com$tssap$j2ee$model$ext$SapLibrarySemanticChecker));
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapLibrarySemanticChecker;

    public static void semanticCheck(IFile file, IProviderDescriptor source) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            SapLibrarySemanticChecker.semanticCheckOfProviderDescriptor(file, source);
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    public static void semanticCheckOfProviderDescriptor(IFile file, IProviderDescriptor provider) {
        IMajorVersion majorVersion;
        String majorV;
        IComponentName compName;
        String compNameV;
        IDisplayName displayName = provider.getDisplayName();
        String displayNameV = displayName.getValue();
        if (displayNameV == null || displayNameV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "display-name");
        }
        if ((compNameV = (compName = provider.getComponentName()).getValue()) == null || compNameV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "component-name");
        }
        if ((majorV = (majorVersion = provider.getMajorVersion()).getValue()) == null || majorV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "major-version");
        } else {
            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "provider-descriptor", "major-version", majorV, 0);
        }
        IMinorVersion minorVersion = provider.getMinorVersion();
        String minorV = minorVersion.getValue();
        if (minorV == null || minorV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "minor-version");
        } else {
            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "provider-descriptor", "minor-version", minorV, 0);
        }
        IMicroVersion microVersion = provider.getMicroVersion();
        String microV = microVersion.getValue();
        if (microV == null || microV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "micro-version");
        } else {
            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "provider-descriptor", "micro-version", microV, 0);
        }
        IProviderName providerName = provider.getProviderName();
        String providerV = providerName.getValue();
        if (providerV == null || providerV.trim().length() == 0) {
            SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "provider-descriptor", "provider-name");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

