/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.j2ee.model.ext.ejbjarpersistent.ITableRelationAdditionalInfo;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ICmrField;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IColumn;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IDatabaseVendor;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IDvColumn;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IEntityBean;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IEntityBeans;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IFieldMap;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IFinderDescriptor;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IFkColumn;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IHelpTable;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ILoadSelectedObjects;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IMethodParams;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPkFieldName;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IQl21Compatible;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IReadOnly;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IRelationships;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ISelectForUpdate;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ISwitchOffStoring;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ISwitchOffVerification;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableRelation;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.ITableRelationshipRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class SapEjbJarPersistentDefaultFactory {
    public static final String DEFAULT_KEYTYPE_FOR_PRIMARYKEY = "PrimaryKey";
    public static final String DEFAULT_KEYTYPE_FOR_NON_PRIMARYKEY = "NoKey";
    public static final String DEFAULT_HELP_TABLE = "<help-table>";

    public static IEntityBean createEntityBean(IEntityBeans entityBeans, String ejbName) throws J2eeCreateException {
        IEntityBean entityBean = entityBeans.createEntityBean(null);
        entityBean.createEjbName(null).setValue(ejbName);
        entityBean.createTableName(null).setValue(ejbName.toUpperCase());
        return entityBean;
    }

    public static IFieldMap createFieldMap(IEntityBean entityBean, String fieldName, boolean isPrimarykey) throws J2eeCreateException {
        IFieldMap fieldMap = entityBean.createFieldMap(null);
        fieldMap.createFieldName(null).setValue(fieldName);
        fieldMap.createColumn(null).createColumnName(null).setValue(fieldName.toUpperCase());
        if (isPrimarykey) {
            fieldMap.setAttribKeyType(DEFAULT_KEYTYPE_FOR_PRIMARYKEY);
        } else {
            fieldMap.setAttribKeyType(DEFAULT_KEYTYPE_FOR_NON_PRIMARYKEY);
        }
        return fieldMap;
    }

    public static IColumn createColumn(IFieldMap fieldMap, String name) throws J2eeCreateException {
        IColumn column = fieldMap.createColumn(null);
        column.createColumnName(null).setValue(name);
        IDvColumn[] dvColumn = fieldMap.getDvColumns();
        int i = 0;
        while (i < dvColumn.length) {
            fieldMap.removeDvColumn(dvColumn[i]);
            ++i;
        }
        return column;
    }

    public static IDvColumn createDvColumn(IFieldMap fieldMap, String name) throws J2eeCreateException {
        IDvColumn column = fieldMap.createDvColumn(null);
        column.createSubfieldName(null).setValue(name);
        column.createColumnName(null).setValue(fieldMap.getFieldName().getValue().toUpperCase() + "_" + name.toUpperCase());
        if (fieldMap.getColumn() != null) {
            fieldMap.removeColumn();
        }
        return column;
    }

    public static ITableRelation createTableRelation(IPersistentEjbMap persistentEjbMap, String leftEjbName, String rightEjbName) throws J2eeCreateException {
        IRelationships relationships = persistentEjbMap.getRelationships();
        if (relationships == null) {
            relationships = persistentEjbMap.createRelationships(null);
        }
        ITableRelation tableRelation = relationships.createTableRelation(null);
        ITableRelationshipRole leftRole = tableRelation.createTableRelationshipRole(null);
        leftRole.createEjbName(null).setValue(leftEjbName);
        leftRole.setAttribKeyType(DEFAULT_KEYTYPE_FOR_NON_PRIMARYKEY);
        ITableRelationshipRole rightRole = tableRelation.createTableRelationshipRole(null);
        rightRole.createEjbName(null).setValue(rightEjbName);
        rightRole.setAttribKeyType(DEFAULT_KEYTYPE_FOR_NON_PRIMARYKEY);
        return tableRelation;
    }

    public static IFinderDescriptor createFinderDescriptor(IEntityBean entityBean, String method, String[] params) throws J2eeCreateException {
        IFinderDescriptor result = entityBean.createFinderDescriptor(null);
        result.createMethodName(null).setValue(method);
        IMethodParams methodParams = result.createMethodParams(null);
        int i = 0;
        while (i < params.length) {
            methodParams.createMethodParam(null).setValue(params[i]);
            ++i;
        }
        result.createLoadSelectedObjects(null).setAttribLock("read");
        return result;
    }

    public static boolean addOrRemoveDvColumns(IFieldMap fieldMap, String[] names) throws J2eeCreateException {
        boolean anythingChanged = false;
        List<String> namesList = Arrays.asList(names);
        ArrayList<String> subFieldNameList = new ArrayList<String>();
        IDvColumn[] dvColumn = fieldMap.getDvColumns();
        int i = 0;
        while (i < dvColumn.length) {
            String subFieldName = dvColumn[i].getSubfieldName().getValue();
            subFieldNameList.add(subFieldName);
            if (!namesList.contains(subFieldName)) {
                anythingChanged = true;
                fieldMap.removeDvColumn(dvColumn[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < names.length) {
            if (!subFieldNameList.contains(names[i2])) {
                anythingChanged = true;
                SapEjbJarPersistentDefaultFactory.createDvColumn(fieldMap, names[i2]);
            }
            ++i2;
        }
        if (fieldMap.getColumn() != null) {
            anythingChanged = true;
            fieldMap.removeColumn();
        }
        return anythingChanged;
    }

    public static IReadOnly addOrRemoveReadOnly(IEntityBean entityBean, boolean create) throws J2eeCreateException {
        IReadOnly result = null;
        if (create) {
            result = entityBean.getReadOnly();
            if (result == null) {
                result = entityBean.createReadOnly(null);
            }
        } else if (entityBean.getReadOnly() != null) {
            entityBean.removeReadOnly();
        }
        return result;
    }

    public static ISelectForUpdate addOrRemoveSelectForUpdate(IEntityBean entityBean, boolean create) throws J2eeCreateException {
        ISelectForUpdate result = null;
        if (create) {
            result = entityBean.getSelectForUpdate();
            if (result == null) {
                result = entityBean.createSelectForUpdate(null);
            }
        } else if (entityBean.getSelectForUpdate() != null) {
            entityBean.removeSelectForUpdate();
        }
        return result;
    }

    public static ISwitchOffVerification addOrRemoveSwitchOffVerification(IPersistentEjbMap persistentEjbMap, boolean create) throws J2eeCreateException {
        ISwitchOffVerification result = null;
        if (create) {
            result = persistentEjbMap.getSwitchOffVerification();
            if (result == null) {
                result = persistentEjbMap.createSwitchOffVerification(null);
            }
        } else if (persistentEjbMap.getSwitchOffVerification() != null) {
            persistentEjbMap.removeSwitchOffVerification();
        }
        return result;
    }

    public static IDatabaseVendor addOrRemoveDatabaseVendor(IPersistentEjbMap persistentEjbMap, String value) throws J2eeCreateException {
        IDatabaseVendor result = null;
        if (value != null) {
            result = persistentEjbMap.getDbProperties().getDatabaseVendor();
            if (result == null) {
                result = persistentEjbMap.getDbProperties().createDatabaseVendor(null);
            }
            result.setAttribName(value);
        } else if (persistentEjbMap.getDbProperties().getDatabaseVendor() != null) {
            persistentEjbMap.getDbProperties().removeDatabaseVendor();
        }
        return result;
    }

    public static ICmrField addOrRemoveCmrField(ITableRelationshipRole tableRelationshipRole, String value) throws J2eeCreateException {
        ICmrField result = tableRelationshipRole.getCmrField();
        if (value == null && result != null) {
            tableRelationshipRole.removeCmrField();
            result = null;
        } else if (value != null) {
            if (result == null) {
                result = tableRelationshipRole.createCmrField(null);
            }
            result.setValue(value);
        }
        return result;
    }

    public static IHelpTable addOrRemoveHelpTable(ITableRelation tableRelation, boolean mustExist) throws J2eeCreateException {
        IHelpTable result = tableRelation.getHelpTable();
        if (!mustExist && result != null) {
            tableRelation.removeHelpTable();
            result = null;
        } else if (mustExist && result == null) {
            result = tableRelation.createHelpTable(null);
            result.setValue(DEFAULT_HELP_TABLE);
        }
        return result;
    }

    public static boolean addOrRemoveFkColumns(ITableRelationAdditionalInfo info, ITableRelationshipRole role, String[] names) throws J2eeCreateException {
        boolean deltasFound;
        List sourceElements = Util.asLinkedList(names);
        ArrayList<String> destinationElements = new ArrayList<String>();
        IFkColumn[] fkColumn = role.getFkColumns();
        int i = 0;
        while (i < fkColumn.length) {
            IPkFieldName pkFieldName = fkColumn[i].getPkFieldName();
            if (pkFieldName != null) {
                destinationElements.add(pkFieldName.getValue());
            }
            ++i;
        }
        Util.searchDuplicates(sourceElements, destinationElements);
        boolean bl = deltasFound = sourceElements.size() != 0 || destinationElements.size() != 0;
        if (!deltasFound) {
            return false;
        }
        int i2 = 0;
        while (i2 < fkColumn.length) {
            IPkFieldName pkFieldName = fkColumn[i2].getPkFieldName();
            if (pkFieldName != null && destinationElements.contains(pkFieldName.getValue())) {
                role.removeFkColumn(fkColumn[i2]);
            }
            ++i2;
        }
        ListIterator sourceElementsIterator = sourceElements.listIterator();
        while (sourceElementsIterator.hasNext()) {
            String sourceElement = sourceElementsIterator.next().toString();
            SapEjbJarPersistentDefaultFactory.createFkColumn(info, role, sourceElement);
        }
        return true;
    }

    public static ISwitchOffStoring addOrRemoveSwitchOffStoring(IFinderDescriptor finderDescriptor, boolean create) throws J2eeCreateException {
        ISwitchOffStoring result = null;
        if (create) {
            result = finderDescriptor.getSwitchOffStoring();
            if (result == null) {
                result = finderDescriptor.createSwitchOffStoring(null);
            }
        } else if (finderDescriptor.getSwitchOffStoring() != null) {
            finderDescriptor.removeSwitchOffStoring();
        }
        return result;
    }

    public static ILoadSelectedObjects addOrRemoveLoadSelectedObjects(IFinderDescriptor finderDescriptor, boolean create) throws J2eeCreateException {
        ILoadSelectedObjects result = null;
        if (create) {
            result = finderDescriptor.getLoadSelectedObjects();
            if (result == null) {
                result = finderDescriptor.createLoadSelectedObjects(null);
            }
        } else if (finderDescriptor.getLoadSelectedObjects() != null) {
            finderDescriptor.removeLoadSelectedObjects();
        }
        return result;
    }

    public static IQl21Compatible addOrRemoveQl21Compatible(IFinderDescriptor finderDescriptor, boolean create) throws J2eeCreateException {
        IQl21Compatible result = null;
        if (create) {
            result = finderDescriptor.getQl21Compatible();
            if (result == null) {
                result = finderDescriptor.createQl21Compatible(null);
            }
        } else if (finderDescriptor.getQl21Compatible() != null) {
            finderDescriptor.removeQl21Compatible();
        }
        return result;
    }

    public static void setPrimaryKeySide(ITableRelationAdditionalInfo info, ITableRelation tableRelation, boolean leftSideShallBePrimaryKey, String[] primaryKeyNames) throws J2eeCreateException {
        ITableRelationshipRole[] role = tableRelation.getTableRelationshipRoles();
        ITableRelationshipRole roleWithPrimaryKey = leftSideShallBePrimaryKey ? role[0] : role[1];
        ITableRelationshipRole roleWithoutPrimaryKey = leftSideShallBePrimaryKey ? role[1] : role[0];
        roleWithPrimaryKey.setAttribKeyType(DEFAULT_KEYTYPE_FOR_PRIMARYKEY);
        roleWithoutPrimaryKey.setAttribKeyType(DEFAULT_KEYTYPE_FOR_NON_PRIMARYKEY);
        IFkColumn[] fkColumn = roleWithPrimaryKey.getFkColumns();
        int i = 0;
        while (i < fkColumn.length) {
            roleWithPrimaryKey.removeFkColumn(fkColumn[i]);
            ++i;
        }
        fkColumn = roleWithoutPrimaryKey.getFkColumns();
        int i2 = 0;
        while (i2 < fkColumn.length) {
            roleWithoutPrimaryKey.removeFkColumn(fkColumn[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < primaryKeyNames.length) {
            SapEjbJarPersistentDefaultFactory.createFkColumn(info, roleWithoutPrimaryKey, primaryKeyNames[i3]);
            ++i3;
        }
    }

    public static void removeTableRelation(IPersistentEjbMap persistentEjbMap, ITableRelation tableRelation) {
        IRelationships relationships = persistentEjbMap.getRelationships();
        relationships.removeTableRelation(tableRelation);
        if (relationships.getTableRelations().length == 0) {
            persistentEjbMap.removeRelationships();
        }
    }

    public static boolean removeMissingDvColumns(IFieldMap fieldMap, String[] names) throws J2eeCreateException {
        boolean anythingChanged = false;
        List<String> namesList = Arrays.asList(names);
        ArrayList<String> subFieldNameList = new ArrayList<String>();
        IDvColumn[] dvColumn = fieldMap.getDvColumns();
        int i = 0;
        while (i < dvColumn.length) {
            String subFieldName = dvColumn[i].getSubfieldName().getValue();
            subFieldNameList.add(subFieldName);
            if (!namesList.contains(subFieldName)) {
                anythingChanged = true;
                fieldMap.removeDvColumn(dvColumn[i]);
            }
            ++i;
        }
        return anythingChanged;
    }

    private static IFkColumn createFkColumn(ITableRelationAdditionalInfo info, ITableRelationshipRole role, String pkFieldName) throws J2eeCreateException {
        String cmrField = info.getLeft().getCmrField();
        if (cmrField == null) {
            cmrField = info.getRight().getCmrField();
        }
        IFkColumn createdFkColumn = role.createFkColumn(null);
        createdFkColumn.createPkFieldName(null).setValue(pkFieldName);
        createdFkColumn.createColumnName(null).setValue(cmrField.toUpperCase() + "_" + pkFieldName.toUpperCase());
        return createdFkColumn;
    }
}

