/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.j2ee.model.ext.ejbjar.dd.IAsContext;
import com.tssap.j2ee.model.ext.ejbjar.dd.IContainerSize;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbJ2eeEngine;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbLocalRef;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEjbRef;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEnterpriseBeans;
import com.tssap.j2ee.model.ext.ejbjar.dd.IEntityProps;
import com.tssap.j2ee.model.ext.ejbjar.dd.IGroupName;
import com.tssap.j2ee.model.ext.ejbjar.dd.IInitialCacheSize;
import com.tssap.j2ee.model.ext.ejbjar.dd.IIorSecurityConfig;
import com.tssap.j2ee.model.ext.ejbjar.dd.IIsolationAttribute;
import com.tssap.j2ee.model.ext.ejbjar.dd.IIsolationLevel;
import com.tssap.j2ee.model.ext.ejbjar.dd.ILrulimit;
import com.tssap.j2ee.model.ext.ejbjar.dd.IMessageProps;
import com.tssap.j2ee.model.ext.ejbjar.dd.IPassivation;
import com.tssap.j2ee.model.ext.ejbjar.dd.IPassiveTimeout;
import com.tssap.j2ee.model.ext.ejbjar.dd.IProperty;
import com.tssap.j2ee.model.ext.ejbjar.dd.IResourceEnvRef;
import com.tssap.j2ee.model.ext.ejbjar.dd.IResourceRef;
import com.tssap.j2ee.model.ext.ejbjar.dd.ISasContext;
import com.tssap.j2ee.model.ext.ejbjar.dd.ISecurityPermission;
import com.tssap.j2ee.model.ext.ejbjar.dd.ISecurityRoleMap;
import com.tssap.j2ee.model.ext.ejbjar.dd.IServerComponentRef;
import com.tssap.j2ee.model.ext.ejbjar.dd.IServerRoleName;
import com.tssap.j2ee.model.ext.ejbjar.dd.ISessionProps;
import com.tssap.j2ee.model.ext.ejbjar.dd.ISessionTimeout;
import com.tssap.j2ee.model.ext.ejbjar.dd.ITransactionDescriptor;
import com.tssap.j2ee.model.ext.ejbjar.dd.ITransportConfig;
import com.tssap.j2ee.model.ext.ejbjar.dd.IUnknownPkInterval;
import com.tssap.j2ee.model.ext.ejbjar.dd.IUserName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;

public class SapEjbJarDescriptionSemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapEjbJarDescriptionSemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapEjbJarDescriptionSemanticChecker = SapEjbJarDescriptionSemanticChecker.class$("com.tssap.j2ee.model.ext.SapEjbJarDescriptionSemanticChecker")) : class$com$tssap$j2ee$model$ext$SapEjbJarDescriptionSemanticChecker));
    public static final String DEFAULT_ISOLATION_LEVEL = "Committed";
    public static final String SPECIFYABLE_ISOLATION_LEVEL = "Repeatable";
    public static final String SPECIFYABLE_ISOLATION_LEVEL_TEXT = "repeatable read";
    public static final String[] ALLOWED_INTEGRITY_VALUES = new String[]{"required", "supported", "none"};
    public static final String[] ALLOWED_CONFIDELITY_VALUES = new String[]{"required", "supported", "none"};
    public static final String[] ALLOWED_ESTABLISH_TRUST_IN_TARGET_VALUES = new String[]{"supported", "none"};
    public static final String[] ALLOWED_ESTABLISH_TRUST_IN_CLIENT_VALUES = new String[]{"required", "supported", "none"};
    public static final String[] ALLOWED_AUTH_METHOD_VALUES = new String[]{"username_password", "none"};
    public static final String[] ALLOWED_REALM_VALUES = new String[]{"default", "none"};
    public static final String[] ALLOWED_CALLER_PROPAGATION_VALUES = new String[]{"required", "supported", "none"};
    public static final String[] ALLOWED_PROPERTY_NAME_VALUES = new String[]{"InitialSize", "MaxSize", "ResizeStep", "stateful-failover"};
    public static final String[] ALLOWED_PROPERTY_NAME_INTEGER = new String[]{"InitialSize", "MaxSize", "ResizeStep"};
    public static final String[] ALLOWED_REFERENCE_TYPES = new String[]{"service", "interface"};
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapEjbJarDescriptionSemanticChecker;

    public static void semanticCheck(IFile file, IEjbJ2eeEngine source) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfReferences(file, source);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfSecurityRoleMaps(file, source);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfIorSecurityConfigs(file, source);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfProperties(file, source);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfNumbers(file, source);
            SapEjbJarDescriptionSemanticChecker.semanticCheckOfIsolationAttribute(file, source);
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    public static void semanticCheckOfReferences(IFile file, IEjbJ2eeEngine source) {
        IEnterpriseBeans enterpriseBeans = source.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            IEnterpriseBean[] enterpriseBean = enterpriseBeans.getEnterpriseBeans();
            HashSet<String> valueSet = new HashSet<String>();
            int i = 0;
            while (i < enterpriseBean.length) {
                IMessageProps messageProps;
                IEntityProps entityProps;
                IServerComponentRef[] serverComponentRef = enterpriseBean[i].getServerComponentRefs();
                String parentTagName = "server-component-ref";
                valueSet.clear();
                int k = 0;
                while (k < serverComponentRef.length) {
                    String name = serverComponentRef[k].getName().getValue();
                    String tagName = "name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    } else {
                        boolean elementIsNew = valueSet.add(name);
                        if (!elementIsNew) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                        }
                    }
                    String jndiName = serverComponentRef[k].getJndiName().getValue();
                    tagName = "jndi-name";
                    if (jndiName == null || jndiName.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
                    }
                    String type = serverComponentRef[k].getType().getValue();
                    tagName = "type";
                    SemanticCheckerHelper.addMarkerIfValueNotInList(file, parentTagName, tagName, type, ALLOWED_REFERENCE_TYPES);
                    ++k;
                }
                IEjbRef[] ejbRef = enterpriseBean[i].getEjbRefs();
                parentTagName = "ejb-ref";
                valueSet.clear();
                int k2 = 0;
                while (k2 < ejbRef.length) {
                    String name = ejbRef[k2].getEjbRefName().getValue();
                    String tagName = "ejb-ref-name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    } else {
                        boolean elementIsNew = valueSet.add(name);
                        if (!elementIsNew) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                        }
                    }
                    String jndiName = ejbRef[k2].getJndiName().getValue();
                    tagName = "jndi-name";
                    if (jndiName == null || jndiName.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
                    }
                    ++k2;
                }
                IEjbLocalRef[] ejbLocalRef = enterpriseBean[i].getEjbLocalRefs();
                parentTagName = "ejb-local-ref";
                valueSet.clear();
                int k3 = 0;
                while (k3 < ejbLocalRef.length) {
                    String name = ejbLocalRef[k3].getEjbRefName().getValue();
                    String tagName = "ejb-ref-name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    } else {
                        boolean elementIsNew = valueSet.add(name);
                        if (!elementIsNew) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                        }
                    }
                    String jndiName = ejbLocalRef[k3].getJndiName().getValue();
                    tagName = "jndi-name";
                    if (jndiName == null || jndiName.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
                    }
                    ++k3;
                }
                IResourceRef[] resourceRef = enterpriseBean[i].getResourceRefs();
                parentTagName = "resource-ref";
                valueSet.clear();
                int k4 = 0;
                while (k4 < resourceRef.length) {
                    String name = resourceRef[k4].getResRefName().getValue();
                    String tagName = "res-ref-name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    } else {
                        boolean elementIsNew = valueSet.add(name);
                        if (!elementIsNew) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                        }
                    }
                    String jndiName = resourceRef[k4].getResLink().getValue();
                    tagName = "res-link";
                    if (jndiName == null || jndiName.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
                    }
                    ++k4;
                }
                IResourceEnvRef[] resourceEnvRef = enterpriseBean[i].getResourceEnvRefs();
                parentTagName = "resource-env-ref";
                valueSet.clear();
                int k5 = 0;
                while (k5 < resourceEnvRef.length) {
                    String name = resourceEnvRef[k5].getResourceEnvRefName().getValue();
                    String tagName = "resource-env-ref-name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    } else {
                        boolean elementIsNew = valueSet.add(name);
                        if (!elementIsNew) {
                            SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                        }
                    }
                    String jndiName = resourceEnvRef[k5].getJndiName().getValue();
                    tagName = "jndi-name";
                    if (jndiName == null || jndiName.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIgnoreParent(file, parentTagName, tagName);
                    }
                    ++k5;
                }
                ISessionProps sessionProps = enterpriseBean[i].getSessionProps();
                if (sessionProps != null) {
                    IProperty[] property = sessionProps.getPropertys();
                    SapEjbJarDescriptionSemanticChecker.semanticCheckOfProperties(file, property);
                }
                if ((entityProps = enterpriseBean[i].getEntityProps()) != null) {
                    IProperty[] property = entityProps.getPropertys();
                    SapEjbJarDescriptionSemanticChecker.semanticCheckOfProperties(file, property);
                }
                if ((messageProps = enterpriseBean[i].getMessageProps()) != null) {
                    IProperty[] property = messageProps.getPropertys();
                    SapEjbJarDescriptionSemanticChecker.semanticCheckOfProperties(file, property);
                }
                ++i;
            }
        }
    }

    private static void semanticCheckOfProperties(IFile file, IProperty[] property) {
        String parentTagName = "property";
        HashSet<String> valueSet = new HashSet<String>();
        int k = 0;
        while (k < property.length) {
            String name = property[k].getPropertyName().getValue();
            String tagName = "property-name";
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
            } else {
                boolean elementIsNew = valueSet.add(name);
                if (!elementIsNew) {
                    SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                }
            }
            ++k;
        }
    }

    public static void semanticCheckOfSecurityRoleMaps(IFile file, IEjbJ2eeEngine source) {
        ISecurityPermission securityPermission = source.getSecurityPermission();
        if (securityPermission != null) {
            ISecurityRoleMap[] securityRoleMap = securityPermission.getSecurityRoleMaps();
            String parentTagName = "security-role-map";
            HashSet<String> valueSet = new HashSet<String>();
            int k = 0;
            while (k < securityRoleMap.length) {
                String name = securityRoleMap[k].getRoleName().getValue();
                String tagName = "role-name";
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                } else {
                    boolean elementIsNew = valueSet.add(name);
                    if (!elementIsNew) {
                        SemanticCheckerHelper.addMarkerDuplicateValueForTagIsError(file, parentTagName, tagName, name);
                    }
                }
                IServerRoleName serverRoleName = securityRoleMap[k].getServerRoleName();
                if (serverRoleName != null) {
                    name = serverRoleName.getValue();
                    tagName = "server-role-name";
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    }
                }
                IUserName[] userName = securityRoleMap[k].getUserNames();
                tagName = "user-name";
                int j = 0;
                while (j < userName.length) {
                    name = userName[j].getValue();
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    }
                    ++j;
                }
                IGroupName[] groupName = securityRoleMap[k].getGroupNames();
                tagName = "group-name";
                int j2 = 0;
                while (j2 < groupName.length) {
                    name = groupName[j2].getValue();
                    if (name == null || name.trim().length() == 0) {
                        SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, parentTagName, tagName);
                    }
                    ++j2;
                }
                ++k;
            }
        }
    }

    public static void semanticCheckOfIorSecurityConfigs(IFile file, IEjbJ2eeEngine source) {
        IEnterpriseBeans enterpriseBeans = source.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            IEnterpriseBean[] enterpriseBean = enterpriseBeans.getEnterpriseBeans();
            int i = 0;
            while (i < enterpriseBean.length) {
                IIorSecurityConfig[] iorSecurityConfig = enterpriseBean[i].getIorSecurityConfigs();
                int k = 0;
                while (k < iorSecurityConfig.length) {
                    ISasContext sasContext;
                    IAsContext asContext;
                    ITransportConfig transportConfig = iorSecurityConfig[k].getTransportConfig();
                    if (transportConfig != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "transport-config", "integrity", transportConfig.getIntegrity().getValue(), ALLOWED_INTEGRITY_VALUES);
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "transport-config", "confidentiality", transportConfig.getConfidentiality().getValue(), ALLOWED_CONFIDELITY_VALUES);
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "transport-config", "establish-trust-in-target", transportConfig.getEstablishTrustInTarget().getValue(), ALLOWED_ESTABLISH_TRUST_IN_TARGET_VALUES);
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "transport-config", "establish-trust-in-client", transportConfig.getEstablishTrustInClient().getValue(), ALLOWED_ESTABLISH_TRUST_IN_CLIENT_VALUES);
                    }
                    if ((asContext = iorSecurityConfig[k].getAsContext()) != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "as-context", "auth-method", asContext.getAuthMethod().getValue(), ALLOWED_AUTH_METHOD_VALUES);
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "as-context", "realm", asContext.getRealm().getValue(), ALLOWED_REALM_VALUES);
                    }
                    if ((sasContext = iorSecurityConfig[k].getSasContext()) != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "sas-context", "caller-propagation", sasContext.getCallerPropagation().getValue(), ALLOWED_CALLER_PROPAGATION_VALUES);
                    }
                    ++k;
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfProperties(IFile file, IEjbJ2eeEngine source) {
        IEnterpriseBeans enterpriseBeans = source.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            IEnterpriseBean[] enterpriseBean = enterpriseBeans.getEnterpriseBeans();
            int i = 0;
            while (i < enterpriseBean.length) {
                IMessageProps messageProps;
                ISessionProps sessionProps;
                IEntityProps entityProps = enterpriseBean[i].getEntityProps();
                if (entityProps != null) {
                    IProperty[] property = entityProps.getPropertys();
                    int k = 0;
                    while (k < property.length) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "property", "property-name", property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_VALUES);
                        if (Util.isObjectInArray(property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_INTEGER)) {
                            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "property", "property-value", property[k].getPropertyValue().getValue(), 0);
                        }
                        ++k;
                    }
                }
                if ((sessionProps = enterpriseBean[i].getSessionProps()) != null) {
                    IProperty[] property = sessionProps.getPropertys();
                    int k = 0;
                    while (k < property.length) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "property", "property-name", property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_VALUES);
                        if (Util.isObjectInArray(property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_INTEGER)) {
                            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "property", "property-value", property[k].getPropertyValue().getValue(), 0);
                        }
                        ++k;
                    }
                }
                if ((messageProps = enterpriseBean[i].getMessageProps()) != null) {
                    IProperty[] property = messageProps.getPropertys();
                    int k = 0;
                    while (k < property.length) {
                        SemanticCheckerHelper.addMarkerIfValueNotInList(file, "property", "property-name", property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_VALUES);
                        if (Util.isObjectInArray(property[k].getPropertyName().getValue(), ALLOWED_PROPERTY_NAME_INTEGER)) {
                            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "property", "property-value", property[k].getPropertyValue().getValue(), 0);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfNumbers(IFile file, IEjbJ2eeEngine source) {
        IEnterpriseBeans enterpriseBeans = source.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            IEnterpriseBean[] enterpriseBean = enterpriseBeans.getEnterpriseBeans();
            int i = 0;
            while (i < enterpriseBean.length) {
                IEntityProps entityProps;
                ISessionProps sessionProps;
                IContainerSize containerSize = enterpriseBean[i].getContainerSize();
                if (containerSize != null) {
                    SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "enterprise-bean", "container-size", containerSize.getValue(), 1);
                }
                if ((sessionProps = enterpriseBean[i].getSessionProps()) != null) {
                    IPassivation passivation;
                    ISessionTimeout sessionTimeout = sessionProps.getSessionTimeout();
                    if (sessionTimeout != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "session-props", "session-timeout", sessionTimeout.getValue(), 0);
                    }
                    if ((passivation = sessionProps.getPassivation()) != null) {
                        ILrulimit lrulimit;
                        IPassiveTimeout passiveTimeout = passivation.getPassiveTimeout();
                        if (passiveTimeout != null) {
                            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "passivation", "passive-timeout", passiveTimeout.getValue(), 0);
                        }
                        if ((lrulimit = passivation.getLrulimit()) != null) {
                            SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "passivation", "lrulimit", lrulimit.getValue(), 0);
                        }
                    }
                }
                if ((entityProps = enterpriseBean[i].getEntityProps()) != null) {
                    IInitialCacheSize initialCacheSize;
                    IUnknownPkInterval unknownPkInterval = entityProps.getUnknownPkInterval();
                    if (unknownPkInterval != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "entity-props", "unknown-pk-interval", unknownPkInterval.getValue(), 1);
                    }
                    if ((initialCacheSize = entityProps.getInitialCacheSize()) != null) {
                        SemanticCheckerHelper.addMarkerIfValueNotIntegerGreaterMin(file, "entity-props", "initial-cache-size", initialCacheSize.getValue(), 0);
                    }
                }
                ++i;
            }
        }
    }

    public static void semanticCheckOfIsolationAttribute(IFile file, IEjbJ2eeEngine source) {
        IIsolationLevel[] isolationLevels;
        ITransactionDescriptor transactionDescr = source.getTransactionDescriptor();
        if (transactionDescr != null && (isolationLevels = transactionDescr.getIsolationLevels()) != null) {
            int i = 0;
            while (i < isolationLevels.length) {
                IIsolationAttribute attribute = isolationLevels[i].getIsolationAttribute();
                if (attribute != null && attribute.getValue() != null && !attribute.getValue().equals(SPECIFYABLE_ISOLATION_LEVEL)) {
                    SemanticCheckerHelper.addMarker(file, "The value '" + attribute.getValue() + "' for the tag <" + "isolation-attribute" + "> below <" + "isolation-level" + "> is not valid. It must be '" + SPECIFYABLE_ISOLATION_LEVEL + "'. The value '" + DEFAULT_ISOLATION_LEVEL + "' is used as a default when you do not specify the isolation-level explicitely. Because of this you should not set the value '" + DEFAULT_ISOLATION_LEVEL + "' explicitely.", -1, 1, false);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

