/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ext;

import com.tssap.j2ee.model.ext.SemanticCheckerHelper;
import com.tssap.j2ee.model.ext.dsaliases.dd.IAlias;
import com.tssap.j2ee.model.ext.dsaliases.dd.IAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.IDataSourceAliases;
import com.tssap.j2ee.model.ext.dsaliases.dd.IDataSourceName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;

public class SapDSAliasesSemanticChecker {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ext$SapDSAliasesSemanticChecker == null ? (class$com$tssap$j2ee$model$ext$SapDSAliasesSemanticChecker = SapDSAliasesSemanticChecker.class$("com.tssap.j2ee.model.ext.SapDSAliasesSemanticChecker")) : class$com$tssap$j2ee$model$ext$SapDSAliasesSemanticChecker));
    public static final int MAX_ALIASNAME_LENGTH = 32;
    private static final String ERROR_WRONG_ALIAS_LENGTH = "The prefix and alias name combined must not be longer than 32 characters";
    static /* synthetic */ Class class$com$tssap$j2ee$model$ext$SapDSAliasesSemanticChecker;

    public static void semanticCheck(IFile file, IDataSourceAliases source) {
        String METHOD = "semanticCheck()";
        try {
            SemanticCheckerHelper.removeAllMarkers(file);
            SapDSAliasesSemanticChecker.semanticCheckOfEmptyTags(file, source);
            SapDSAliasesSemanticChecker.semanticCheckOfMultipleTags(file, source);
        }
        catch (Exception e) {
            TRACER.error("semanticCheck()", "Problems in semantic-check: " + e.toString(), (Throwable)e);
        }
    }

    public static void semanticCheckOfEmptyTags(IFile file, IDataSourceAliases source) {
        IAliases[] aliases = source.getAliasess();
        int i = 0;
        while (i < aliases.length) {
            IDataSourceName dataSourceName = aliases[i].getDataSourceName();
            String name = dataSourceName.getValue();
            if (name == null || name.trim().length() == 0) {
                SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "aliases", "data-source-name");
            }
            IAlias[] alias = aliases[i].getAliass();
            int k = 0;
            while (k < alias.length) {
                String errorMessage;
                name = alias[k].getValue();
                if (name == null || name.trim().length() == 0) {
                    SemanticCheckerHelper.addMarkerEmptyValueForTagIsError(file, "aliases", "alias");
                }
                if ((errorMessage = SapDSAliasesSemanticChecker.validateAliasName(name.toCharArray())) != null) {
                    SapDSAliasesSemanticChecker.addMarkerNamingConventionsViolatedIsError(file, "aliases", "alias", errorMessage);
                }
                ++k;
            }
            ++i;
        }
    }

    public static void semanticCheckOfMultipleTags(IFile file, IDataSourceAliases source) {
        IAliases[] aliases = source.getAliasess();
        if (aliases.length > 1) {
            SapDSAliasesSemanticChecker.addMarkerMultipleTagsIsError(file, "data-source-aliases", "aliases");
        }
        int i = 0;
        while (i < aliases.length) {
            IAlias[] alias = aliases[i].getAliass();
            if (alias.length > 1) {
                SapDSAliasesSemanticChecker.addMarkerMultipleTagsIsError(file, "aliases", "alias");
            }
            ++i;
        }
    }

    public static String validateAliasName(char[] chars) {
        if (chars.length > 32) {
            return ERROR_WRONG_ALIAS_LENGTH;
        }
        int i = 0;
        while (i < chars.length) {
            boolean isValid;
            char value = chars[i];
            boolean conditionLetter = Character.isLetter(value) && Character.isUpperCase(value);
            boolean conditionUnderscore = value == '_';
            boolean conditionSlash = value == '/';
            boolean conditionDigit = Character.isDigit(value);
            boolean bl = isValid = conditionLetter || conditionUnderscore || conditionDigit || conditionSlash;
            if (!isValid) {
                return "The character " + value + " must not be present in the name";
            }
            ++i;
        }
        return null;
    }

    private static void addMarkerMultipleTagsIsError(IFile file, String parentTagName, String tagName) {
        SemanticCheckerHelper.addMarker(file, "The tag <" + tagName + "> below <" + parentTagName + "> appears more than once. Although this is allowed by the DTD, it is strongly dissuaded. Because of this the IDE does not support it.", -1, 2, false);
    }

    private static void addMarkerNamingConventionsViolatedIsError(IFile file, String parentTagName, String tagName, String errorMessage) {
        SemanticCheckerHelper.addMarker(file, "The naming-conventions for the alias-name in the tag <" + tagName + "> below <" + parentTagName + "> are violated. Details: " + errorMessage, -1, 2, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

